<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

add_action( 'transition_post_status', 'eos_scfm_mobile_publication_warning', 10, 3 );
//It prevents the mobile version publication.
function eos_scfm_mobile_publication_warning( $new_status, $old_status,$post ) {
    if ( $new_status === 'publish' && eos_scfm_related_desktop_id( $post->ID ) > 0 ) {
		$post->post_status = 'private';
		wp_update_post( $post );
    }
}

//It checks if the theme supports the blog page mobile version
function eos_scfm_is_posts_page_supported( $feature ){
	$arr = get_theme_support( 'specific_content_form_mobile' );
	if( is_array( $arr ) ){
		$arr = $arr[0];
		return isset( $arr[$feature] ) && $arr[$feature];
	}
	return false;
}

add_filter( 'load_textdomain_mofile', 'eos_scfm_load_translation_file',99,2 ); //loads plugin translation files
//Filter function to read plugin translation files
function eos_scfm_load_translation_file( $mofile, $domain ) {
	if ( 'eos-scfm' === $domain ) {
		$loc = function_exists( 'get_user_locale' ) ? get_user_locale() : get_locale();
		$mofile = EOS_SCFM_PLUGIN_DIR.'/languages/eos-scfm-' . $loc . '.mo';
	}
	return $mofile;
}
load_plugin_textdomain( 'eos-scfm',false,EOS_SCFM_PLUGIN_DIR.'/languages/' );

add_action( 'in_admin_header','eos_scfm_remove_mobile_permalink' );
//It removes the permalink for the mobile version
function eos_scfm_remove_mobile_permalink(){
	global $post;
	if( is_object( $post ) ){
		$desktop_id = eos_scfm_related_desktop_id( $post->ID );
		if( $desktop_id > 0 ){
			add_filter( 'get_sample_permalink_html', '__return_false' );
		}
	}
}

add_action( 'admin_enqueue_scripts','eos_scfm_enqueue_scripts' );
//It enqueues the admin scripts and style
function eos_scfm_enqueue_scripts(){
	wp_enqueue_style( 'eos-scfm',EOS_SCFM_PLUGIN_URL.'/admin/assets/eos-scfm-admin.css' );
}
add_action( 'admin_action_eos_scfm_duplicate_post_as_draft', 'eos_scfm_duplicate_post_as_draft' );
//It creates post duplicate as a draft and redirects then to the edit post screen
function eos_scfm_duplicate_post_as_draft(){
	global $wpdb;
	if (! ( isset( $_GET['post'] ) || ( isset($_REQUEST['action']) && 'eos_scfm_duplicate_post_as_draft' === $_REQUEST['action'] ) ) ) {
		wp_die( __( 'No post for mobile has been supplied!','eos-scfm' ) );
	}
	$post_id = absint( $_GET['post'] );
	if( 0 === $post_id ){
		wp_die( __( 'No post for mobile has been supplied!','eos-scfm' ) );
	}
	/*
	 * and all the original post data then
	 */
	$post = get_post( $post_id );
	$current_user = wp_get_current_user();
	$new_post_author = $current_user->ID;
	/*
	 * if post data exists, create the post duplicate
	 */
	if( isset( $post ) && $post != null ){
		/*
		 * new post data array
		 */
		$args = array(
			'comment_status' => $post->comment_status,
			'ping_status'    => $post->ping_status,
			'post_author'    => $new_post_author,
			'post_content'   => $post->post_content,
			'post_excerpt'   => $post->post_excerpt,
			'post_name'      => $post->post_name.'-mobile',
			'post_parent'    => $post->post_parent,
			'post_password'  => $post->post_password,
			'post_status'    => 'draft',
			'post_title'     => $post->post_title,
			'post_type'      => $post->post_type,
			'to_ping'        => $post->to_ping,
			'menu_order'     => $post->menu_order
		);
		/*
		 * insert the post by wp_insert_post() function
		 */
		$new_post_id = wp_insert_post( $args );
		update_post_meta( $post_id,'eos_scfm_mobile_post_id',$new_post_id );
		update_post_meta( $new_post_id,'eos_scfm_desktop_post_id',$post_id );
		if( absint( get_option( 'page_on_front' ) ) === $post_id ){
			update_option( 'page_on_front_mobile',absint( $new_post_id ) );
		}
		if( get_option( 'page_for_posts' ) === $post_id ){
			update_option( 'page_for_posts_mobile',absint( $new_post_id ) );
		}
		/*
		 * get all current post terms ad set them to the new post draft
		 */
		$taxonomies = get_object_taxonomies($post->post_type); // returns array of taxonomy names for post type, ex array("category", "post_tag");
		foreach ($taxonomies as $taxonomy) {
			$post_terms = wp_get_object_terms( $post_id,$taxonomy,array( 'fields' => 'slugs' ) );
			wp_set_object_terms( $new_post_id,$post_terms,$taxonomy, false );
		}
		/*
		 * duplicate all post meta just in two SQL queries
		 */
		$post_meta_infos = $wpdb->get_results("SELECT meta_key, meta_value FROM $wpdb->postmeta WHERE post_id=$post_id");
		if ( count( $post_meta_infos)!== 0 ) {
			$sql_query = "INSERT INTO $wpdb->postmeta (post_id, meta_key, meta_value) ";
			foreach( $post_meta_infos as $meta_info ){
				$meta_key = $meta_info->meta_key;
				$meta_value = addslashes($meta_info->meta_value);
				$sql_query_sel[]= "SELECT $new_post_id, '$meta_key', '$meta_value'";
			}
			$sql_query.= implode(" UNION ALL ", $sql_query_sel);
			$wpdb->query( $sql_query );
		}
		/*
		 * finally, redirect to the edit post screen for the new draft
		 */
		wp_redirect( admin_url( 'post.php?action=edit&post=' . $new_post_id ) );
		exit;
	} else {
		wp_die( sprintf( __( 'Mobile version failed, could not find original post: %s','eos-scfm' ),$post_id ) );
	}
}
add_filter( 'post_row_actions', 'eos_scfm_duplicate_post_link', 10, 2 );
add_filter( 'page_row_actions', 'eos_scfm_duplicate_post_link', 10, 2 );

//Add the duplicate link to action list for post_row_actions
function eos_scfm_duplicate_post_link( $actions,$post ) {
	if ( current_user_can('edit_posts') && in_array( $post->post_type,eos_scfm_post_types() ) ){
		$mobile_post_id = absint( get_post_meta( $post->ID,'eos_scfm_mobile_post_id',true ) );
		if( $mobile_post_id  > 0 ){
			$actions['duplicate_for_mobile'] = '<a href="'.admin_url( 'post.php?action=edit&amp;post=' . $mobile_post_id ).'" title="'.esc_html__( ' Edit mobile version','eos-scfm' ).'" rel="permalink">'.esc_html__( 'Edit mobile version','eos-scfm' ).'</a>';
		}
		else{
			$desktop_post_id = eos_scfm_related_desktop_id( $post->ID,true );
			if( 0 === $desktop_post_id ){
				$actions['edit_mobile'] = '<a href="admin.php?action=eos_scfm_duplicate_post_as_draft&amp;post=' . $post->ID . '" title="'.esc_html__( ' Create mobile version','eos-scfm' ).'" rel="permalink">'.esc_html__( 'Create mobile version','eos-scfm' ).'</a>';
			}
			elseif( $desktop_post_id > 0 ){
				if( isset( $actions['view'] ) ){
					$actions['view'] = '<a href="'.get_preview_post_link( $post ).'" title="'.esc_html__( ' Create mobile version','eos-scfm' ).'" rel="permalink">'.esc_html__( 'Preview','eos-scfm' ).'</a>'; ;
				}
			}
		}
	}
	return $actions;
}

add_action( 'admin_notices', 'eos_scfm_notices',10,2 );
//It adds the plugin metaboxes
function eos_scfm_notices(){
	if( !isset( $_GET['post'] ) ) return;
	global $post;
	if( !is_object( $post ) ) return;
	$desktop_post_id = absint( get_post_meta( $post->ID,'eos_scfm_desktop_post_id',true ) );
	$notice = false;
	if( $desktop_post_id > 0 ){
		$desktop_post = get_post( $desktop_post_id );
		if( is_object( $desktop_post ) ){
			$desktop_title = $desktop_post->post_title;
			$notice = sprintf( __( 'The content you are editing is the mobile version of %s%s%s','eos-scfm' ),'<strong>',$desktop_title,'</strong>' );
		}
	}
	$mobile_post_id = absint( get_post_meta( $post->ID,'eos_scfm_mobile_post_id',true ) );
	if( $mobile_post_id > 0 ){
		$mobile_post = get_post( $mobile_post_id );
		if( !is_object( $mobile_post ) ){
			$mobile_title = $mobile_post->post_title;
			$notice = sprintf( __( 'The content you are editing has a mobile version titled %s%s%s','eos-scfm' ),'<strong>',$mobile_title,'</strong>' );
		}
	}
	if( $notice ){
	?>
	<div class="notice notice-warning is-dismissible"><p><?php echo wp_kses( $notice,array( 'strong'=>array() ) ); ?></p></div>
	<?php
	}
}
add_filter( 'display_post_states','eos_scfm_post_status',2,99 );
//It adds the mobile version status in the posts table
function eos_scfm_post_status( $states,$post ){
	$desktop_post_id = eos_scfm_related_desktop_id( $post->ID,true );
	if( $desktop_post_id ){
		$desktop_post = get_post( $desktop_post_id );
		if( !is_object( $desktop_post ) ) return $states;
		if( isset( $states['private'] ) ){
			unset( $states['private'] );
		}
		if( 'publish' === $post->post_status ){
			$states[] = '<span title="'.esc_attr__( 'This mobile version is public, this is not good for SEO. Better you make it private','scfm' ).'" style="color:red" class="dashicons dashicons-info"></span>';
		}
		$states[] = sprintf( esc_html__( '%s Mobile Version of %s','eos-scfm' ),'<span class="dashicons dashicons-smartphone"> </span>',$desktop_post->post_title ); 
	}
	return $states;
}
foreach( eos_scfm_post_types() as $post_type ){
	add_filter( 'manage_'.$post_type.'_posts_columns', 'eos_scfm_post_columns_head' );
	add_action( 'manage_'.$post_type.'s_custom_column', 'eos_scfm_post_columns_content', 10, 2 );
}

//Add new column to posts table list
function eos_scfm_post_columns_head( $columns ){
	$cb = $columns['cb'];
	unset( $columns['cb'] );
	$title = $columns['title'];
	unset( $columns['title'] );
	$GLOBALS['scfm_is_blog_page_supported'] = eos_scfm_is_posts_page_supported( 'posts_page' );
	$GLOBALS['scfm_posts_page'] = get_option( 'page_for_posts' );
    return array_merge( array(
			'cb' => $cb,
			'title' => $title,
			'eos_scfm_device' => '<span class="dashicons dashicons-desktop"></span>|<span class="dashicons dashicons-smartphone"></span>',
		),$columns
	);
}
//Set the content for the added column in the posts table lists
function eos_scfm_post_columns_content( $column_name, $post_ID ) {
    if( $column_name === 'eos_scfm_device' ) {
		$desktop_id = eos_scfm_related_desktop_id( $post_ID );
		$mobile_id = eos_scfm_related_mobile_id( $post_ID );
		$desktop_id_link = $desktop_id > 0 ? $desktop_id : $post_ID;
		$mobile_id_link = $mobile_id > 0 ? $mobile_id : '';
		$desktop_link = '' !== $desktop_id_link ? array( '<a title="'.esc_attr__( 'Edit Desktop version','eos-scfm' ).'" href="'.get_edit_post_link( $desktop_id_link ).'">','</a>' ) : array( '','' );
		$mobile_link = $mobile_id > 0 || $desktop_id > 0 ? array( '<a title="'.esc_attr__( 'Edit Mobile version','eos-scfm' ).'" href="'.get_edit_post_link( $mobile_id_link ).'">','</a>' ) : array( '','' );
		$mobile_display = $desktop_id > 0 || $mobile_id > 0 ? 'inline-block' : 'none';
		$desktop_opacity  = $desktop_id_link > 0 || $mobile_id > 0 ? 1 : 0.4;
		$mobile_new = 'none' === $mobile_display ? '<a href="admin.php?action=eos_scfm_duplicate_post_as_draft&amp;post='.absint( $post_ID ).'" title="'.esc_html__( ' Create mobile version','eos-scfm' ).'" rel="permalink"><span class="dashicons dashicons-plus"></span></a>' : '';
		echo $desktop_link[0].'<span style="opacity:'.esc_attr( $desktop_opacity ).'" class="dashicons dashicons-desktop"></span>'.$desktop_link[1].$mobile_link[0].'<span style="display:'.$mobile_display.'" class="dashicons dashicons-smartphone"></span>'.$mobile_link[1].$mobile_new;
		global $scfm_is_blog_page_supported,$scfm_posts_page;
		if( !$scfm_is_blog_page_supported && $post_ID === absint( $scfm_posts_page ) ){
			?>
			<span class="dashicons dashicons-info" title="<?php esc_attr_e( "Your theme doesn't declare full support for the blog page mobile version, something may not work as expected on the blog mobile version","eos-scfm" ); ?>"></span>
			<?php
			return;
		}		
    }
}
add_action( 'wp_trash_post','eos_scfm_before_post_deletion' );
//it manages the mobile and desktop versions when a post or page is deleted
function eos_scfm_before_post_deletion( $post_id ){
	static $called = false;
	if( $called ) return;
	$called = true;
	global $post_type;
	if( !in_array( $post_type,eos_scfm_post_types() ) ) return;
	$desktop_id = eos_scfm_related_desktop_id( $post_id );
	$mobile_id = eos_scfm_related_mobile_id( $post_id );
	if( $desktop_id > 0 ){
		delete_post_meta( $desktop_id,'eos_scfm_mobile_post_id' );
	}
	if( $mobile_id > 0 ){
		wp_trash_post( $mobile_id );
	}
	$page_for_posts_mobile = get_option( 'page_for_posts_mobile' );
	$page_on_front_mobile = get_option( 'page_on_front_mobile' );
	if( $page_for_posts_mobile == $mobile_id || $page_for_posts_mobile == $post_id ){
		delete_option( 'page_for_posts_mobile' );
	}
	if( $page_on_front_mobile == $mobile_id || $page_on_front_mobile == $post_id ){
		delete_option( 'page_on_front_mobile' );
	}	
}

add_action( 'untrash_post','eos_scfm_after_post_untrash' );
//It reassign the mobile ID to the desktop post if no other mobile versions were created
function eos_scfm_after_post_untrash( $post_id ){
	static $called = false;
	if( $called ) return;
	$called = true;
	$desktop_id = eos_scfm_related_desktop_id( $post_id );
	if( $desktop_id > 0 ){
		$actualMobileId = get_post_meta( $desktop_id,'eos_scfm_mobile_post_id',true );
		if( $desktop_id == get_option( 'page_for_posts' ) ){
			update_option( 'page_for_posts_mobile',$post_id );
		}
		if( $desktop_id == get_option( 'page_on_front' ) ){
			update_option( 'page_on_front_mobile',$post_id );			
		}		
		if( !$actualMobileId ){
			update_post_meta( $desktop_id,'eos_scfm_mobile_post_id',$post_id );
		}
		else{
			delete_post_meta( $post_id,'eos_scfm_desktop_post_id' );
		}
	}
}
add_action( 'add_meta_boxes', 'eos_scfm_add_meta_box' );
//It adds the meta box to the page and post screen
function eos_scfm_add_meta_box(){
    add_meta_box(
        'eos-scfm',
        esc_attr__( 'Mobile version','eos-scfm' ),
        'eos_scfm_metabox_callback',
        eos_scfm_post_types(),
        'side',
        'low'
    );
}
//Callback for the metabox
function eos_scfm_metabox_callback( $post ){
	$desktop_id = eos_scfm_related_desktop_id( $post->ID );
	if( $desktop_id > 0 ){
		printf( esc_html__( 'You are editing the mobile version of %s','eos-scfm' ),'<a href="'.get_edit_post_link( $desktop_id ).'">'.get_the_title( $desktop_id ).'</a>' );
		return;
	}
	$actions = eos_scfm_duplicate_post_link( array(),$post );
	if( !empty( $actions ) ){
		foreach( $actions as $action ){
			echo '<span class="sfc-button button">'.$action.'</span>';
		}
	}
}
add_filter( 'plugin_action_links_'.EOS_SCFM_PLUGIN_BASE_NAME,'eos_scfm_plugin_add_settings_link' );
//It adds a link to the action links in the plugins page
function eos_scfm_plugin_add_settings_link( $links ){
    $settings_link = '<a class="eos-wh-setts" href="'.admin_url( 'edit.php?post_type=page' ).'">'. esc_html__( 'Pages','eos-scfm' ). '</a>';
    $settings_link .= ' | <a class="eos-wh-setts" href="'.admin_url( 'edit.php?post_type=post' ).'">'. esc_html__( 'Posts','eos-scfm' ). '</a>';
    $settings_link .= ' | <a class="eos-wh-setts" target="_blank" rel="noopener" href="https://wordpress.org/support/plugin/specific-content-for-mobile/">'. __( 'Support','eos-scfm' ). '</a>';
    array_push( $links, $settings_link );
  	return $links;	
}

add_action( 'admin_notices','eos_scfm_notice_if_public' );
//It warns the user if a mobile version is plublic instead of private
function eos_scfm_notice_if_public(){
	if( isset( $_GET['post'] ) && isset( $_GET['action'] ) && 'edit' === $_GET['action'] ){
		global $post;
		if( is_object( $post ) ){
			if( 'publish' === $post->post_status ){
				$desktop_id = eos_scfm_related_desktop_id( $post->ID );
				if( $desktop_id > 0 ){
					$class = 'notice notice-error';
					$message = __( "Mobile versions should not be public, make it private if you don't want SEO problems.",'eos-scfm' );
					printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), esc_html( $message ) );
				}
			}
		}
	}
}

add_action( 'post_updated','eos_scfm_check_diffs_on_save',10,3 );
//It cheks the differences with the previous revision.
function eos_scfm_check_diffs_on_save( $post_ID, $post_after,$post_before ){
	$mobile_id = eos_scfm_related_mobile_id( $post_ID );
	if( $mobile_id > 0 ){
		$msg = '';
		$old_content = is_object( $post_before ) ? $post_before->post_content : false;
		if( $old_content ){
			$new_content = $post_after->post_content;
			if( $old_content === $new_content ){
				$revisions = wp_get_post_revisions( $post_ID );
				if( count( $revisions ) > 0 ){
					$last_revisionArr = array_slice( $revisions,1,1 );
					$last_revision = $last_revisionArr[0];
					if( !isset( $last_revisionArr[0] ) ) return;
					if( $last_revision->post_content !== $new_content ){
						$old_content = $last_revision->post_content;
					}
					else{
						//no differences
						return;
					}
				}
				else{
					//no revisions to compare
					return;
				}
			}
			$args = array(
				'title'           => 'Differences',
				'title_left'      => 'Old Version',
				'title_right'     => 'New Version'
			);
			$left_string  = normalize_whitespace( $old_content );
			$right_string = normalize_whitespace( $new_content );
			$left_lines  = explode( "\n", $left_string );
			$right_lines = explode( "\n", $right_string );	
			require_once ABSPATH.WPINC.'/Text/Diff.php';
			$diffs = new Text_Diff( $left_lines, $right_lines );
			$diffs = $diffs->_edits;
			$arr = array();
			$changed = false;
			foreach( $diffs as $diff ){
				if( !empty( array_diff( $diff->orig,$diff->final ) ) ){
					$arr[] = array( 'orig' => $diff->orig,'final' => $diff->final );
					$changed = true;
				}
			}
			$msg = esc_html__( 'This page has a mobile version, remember to check it','eos-scfm' );
			eos_scfm_pro_synchronize_changes( $post_ID,$arr );
			//We warn the user to change also the mobile version and include the actions for the PRO version
			set_transient( 'eos_scfm_desktop_changed',array( 'id' => $mobile_id,'title' => sanitize_text_field( $post_after->post_title ),'message' => $msg ),180 );
		}
	}
}

//It synchronizes desktop and mobile changes
function eos_scfm_pro_synchronize_changes( $post_ID,$arr ){
	if( !class_exists( 'DOMDocument' ) ){
		return esc_html__( 'PHP DOM extension missing on your server, no synchronization between desktop and mobile changes was possible','eos-scfm' );
	}
	$mobile_id = eos_scfm_related_mobile_id( $post_ID );
	$desktop_id = eos_scfm_related_desktop_id( $post_ID );
	if( $mobile_id < 1 || $desktop_id > 0) return;
	$mobile = get_post( $mobile_id );
	if( !is_object( $mobile ) ) return;
	$changes = 0;
	$starts_ends = array( array( '"','""' ),array( ']','[' ),array( '>','<' ),array( "'","'" ) );
	foreach( $arr as $diffs ){
		$orig = $diffs['orig'];
		$final = $diffs['final'];
		$orig_doc = new DOMDocument();
		$final_doc = new DOMDocument();
		$k = 0;
		foreach( $orig as $orig_line ){
			if( '' !== $orig_line && $orig_line === wp_strip_all_tags( $orig_line ) ){
				//It's simple text
				$mobile->post_content = str_replace( $orig_line,$final[$k],$mobile->post_content );
				++$changes;
				continue;
			}
			$orig_line_shortcoded = do_shortcode( $orig_line );
			$final_line_shortcoded = do_shortcode( $final[$k] );			
			@$orig_doc->loadHTML( '<html><head></head><body>'.$orig_line_shortcoded.'</body></html>' );
			@$final_doc->loadHTML( '<html><head></head><body>'.$final_line_shortcoded.'</body></html>' );
			$orig_imgs = $orig_doc->getElementsByTagName( "img" );
			$final_imgs = $final_doc->getElementsByTagName( "img" );
			$orig_img_n = 0;
			$k = 0;
			if( $orig_imgs ){
				foreach( $orig_imgs as $img ){
					$orig_src =  $img->getAttribute( "src" );
					if( is_object( $final_imgs[$k] ) ){
					$final_src = $final_imgs[$k]->getAttribute( "src" );
						if( $orig_src !== $final_src ){
							$orig_attach_id = attachment_url_to_postid( $orig_src );
							$final_attach_id = attachment_url_to_postid( $final_src );
							$mobile->post_content = str_replace( $orig_attach_id,$final_attach_id,$mobile->post_content );
							$mobile->post_content = str_replace( $orig_src,$final_src,$mobile->post_content );
							++$changes;
						}
					}
					++$k;
				}
			}
			$orig_links = $orig_doc->getElementsByTagName( "a" );
			$final_links = $final_doc->getElementsByTagName( "a" );
			if( null !== $orig_links && null !== $final_links ){
				$orig_link_n = 0;
				$k = 0;
				if( $orig_links && is_object( $final_links[$k] ) ){
					foreach( $orig_links as $link ){
						if( is_object( $link ) ){
							$orig_href =  $link->getAttribute( "href" );
							$final_href = $final_links[$k]->getAttribute( "href" );
							$orig_text =  $link->textContent;
							$final_text = $final_links[$k]->textContent;
							if( $orig_href !== $final_href ){
								$mobile->post_content = str_replace( $orig_href,$final_href,$mobile->post_content );
								++$changes;
							}
							if( $orig_text !== $final_text ){
								foreach( $starts_ends as $start_end ){
									$mobile->post_content = str_replace( $start_end[0].$orig_text.$start_end[1],$start_end[0].$final_text.$start_end[1],$mobile->post_content );
								}					
								++$changes;
							}
						}
						++$k;
					}
				}
			}
			$textEls = array(
				'tt',
				'i',
				'b',
				'big',
				'small',
				'em',
				'strong',
				'dfn',
				'code',
				'samp',
				'kbd',
				'var',
				'cite',
				'abbr',
				'acronym',
				'sub',
				'sup',
				'span',
				'bdo',
				'address',
				'div',
				'p',
				'h1',
				'h2',
				'h3',
				'h4',
				'h5',
				'h6',
				'pre',
				'q',
				'ins',
				'del',
				'dt',
				'dd',
				'li',
				'label',
				'option',
				'legend',
				'button',
				'caption',
				'td',
				'th'
			);
			foreach( $textEls as $el ){
				$orig_els = $orig_doc->getElementsByTagName( $el );
				$final_els = $final_doc->getElementsByTagName( $el );
				$orig_el_n = 0;
				$k = 0;
				if( $orig_els ){
					foreach( $orig_els as $orig_el ){
						$orig_text =  $orig_el->textContent;
						if( is_object( $final_els[$k] ) ){
							$final_text = $final_els[$k]->textContent;
							if( $orig_text !== $final_text ){
								foreach( $starts_ends as $start_end ){
									$mobile->post_content = str_replace( $start_end[0].$orig_text.$start_end[1],$start_end[0].$final_text.$start_end[1],$mobile->post_content );
								}
								++$changes;
							}
							$orig_html = eos_scfm_pro_inner_html( $orig_el );
							$final_html = eos_scfm_pro_inner_html( $final_els[$k] );
							if( $orig_html !== $final_html ){
								foreach( $starts_ends as $start_end ){
									$mobile->post_content = str_replace( $start_end[0].$orig_html.$start_end[1],$start_end[0].$final_html.$start_end[1],$mobile->post_content );
								}
								++$changes;
							}	
						}
						++$k;
					}
				}
			}
		}
	}
	if( $changes > 0 ){
		wp_update_post( $mobile,true );						  
	}
}

//It returns the element inner HTML
function eos_scfm_pro_inner_html( $element ){
	if( !is_object( $element ) ) return;
    $innerHTML = ''; 
    $children  = $element->childNodes;
	if( $children ){
		foreach( $children as $child ){ 
			$innerHTML .= $element->ownerDocument->saveHTML( $child );
		}
	}
    return $innerHTML; 
}

add_action( 'admin_notices','eos_scfm_warn_desktop_change' );
//It warns the user about a desktop version change inviting to change also the mobile version
function eos_scfm_warn_desktop_change(){
	$transient = get_transient( 'eos_scfm_desktop_changed' );
	if( $transient ){
		$message = '' !== $transient['message'] ? $transient['message'] : sprintf( esc_html__( 'You have changed the content of %s. Remember to change also the related %smobile version.%s','eos-scfm' ),$transient['title'],'<a href="'.get_edit_post_link( $transient['id'] ).'">','</a>' );
	?>
	<div class="notice notice-warning is-dismissible"><p><strong><?php echo $message; ?></strong></p></div>
	<?php
	}
}