<?php
/*
Plugin Name: Specific Content for Mobile Version
Description: It allows you to create specific content for the mobile version.
Author: Jose Mortellaro
Author URI: https://josemortellaro.com/
Text Domain: eos-scfm
Domain Path: /languages/
Version: 0.1.1
*/
/*  This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
*/
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if( is_admin() ){
	define( 'EOS_SCFM_PLUGIN_URL', untrailingslashit( plugins_url( '', __FILE__ ) ) );
	define( 'EOS_SCFM_PLUGIN_DIR',untrailingslashit( dirname( __FILE__ ) ) );
	define( 'EOS_SCFM_PLUGIN_BASE_NAME',untrailingslashit( plugin_basename( __FILE__ ) ) );
	require EOS_SCFM_PLUGIN_DIR.'/admin/scfm-admin.php';
}
else{
	add_action( 'template_redirect','eos_scfm_post_content_replacement' );
}

//It replaces the post content with the mobile version
function eos_scfm_post_content_replacement(){
	global $post;
	if( !is_singular() || !is_object( $post ) || !wp_is_mobile() ) return;
	$mobile_post_id = eos_scfm_related_mobile_id( $post-> ID );
	if( $mobile_post_id > 0 ){	
		$mobile_post = get_post( $mobile_post_id );
		$post->ID = $mobile_post_id;
		$post->post_content = $mobile_post->post_content;
	}
}

if( wp_is_mobile() ){
	add_filter( 'option_page_on_front','eos_scfm_mobile_front_page',0,1 );
	add_filter( 'option_page_for_posts','eos_scfm_mobile_page_for_posts',0,1 );
}
//It replace the front page id with the mobile front page id.
function eos_scfm_mobile_front_page( $id ){
	$mobile_id = get_option( 'page_on_front_mobile' );
	if( $mobile_id ){
		add_filter( 'get_post_status','eos_scfm_filter_post_status' );
		return $mobile_id;
	}
	return $id;
}

//It returns the publish post status if homepage mobile
function eos_scfm_filter_post_status(  $post_status ){
	return 'publish';
}
//It replace the front page id with the mobile front page id.
function eos_scfm_mobile_page_for_posts( $id ){
	$mobile_id = get_option( 'page_for_posts_mobile' );
	if( $mobile_id ){
		add_filter( 'get_post_status','eos_scfm_filter_post_status' );
		return $mobile_id;
	}
	return $id;
}
add_filter( 'private_title_format', 'eos_scfm_remove_private_title' );
//If mobile it returns only the title portion as defined by %s, not the additional private prefix
function eos_scfm_remove_private_title( $title ) {
	global $post;
	if( is_object( $post ) ){
		$desktop_post_id = eos_scfm_related_mobile_id( $post->ID );
		if( $desktop_post_id > 0 ){	
			// 'Private: ' as added in core
			return "%s";
		}
	}
	return $title;
}

//It returns the post ID related to the desktop version given the original post ID
function eos_scfm_related_desktop_id( $post_id ){
	$desktop_id = wp_cache_get( 'scfm_desktop_id_'.$post_id );
	if( $desktop_id ){
		return $desktop_id;
	}
	else{
		$desktop_id = absint( get_post_meta( $post_id,'eos_scfm_desktop_post_id',true ) );
		wp_cache_set( 'scfm_desktop_id_'.$post_id,$desktop_id );
	}
	return $desktop_id;
}

//It returns the post ID related to the mobile version given the original post ID
function eos_scfm_related_mobile_id( $post_id ){
	$mobile_id = wp_cache_get( 'scfm_mobile_id_'.$post_id );
	if( $mobile_id ){
		return $mobile_id;
	}
	else{
		$mobile_id = absint( get_post_meta( $post_id,'eos_scfm_mobile_post_id',true ) );
		wp_cache_set( 'scfm_mobile_id_'.$post_id,$mobile_id );
	}
	return $mobile_id;
}

//It returns all post IDs of mobile versions
function eos_scfm_get_mobile_ids() {
	$ids = array();
	$query_args = array(
		'post_type'      => eos_scfm_post_types(),
		'fields'         => 'ids',
		'no_found_rows'  => true,
		'posts_per_page' => -1,
		'meta_query'     => array(
			array(
				'key'   => 'eos_scfm_desktop_post_id',
				'value'   => array(''),
				'compare' => 'NOT IN'
			),
		)
	);
	$query = new WP_Query( $query_args );
	if ( $query->posts ) {
		foreach ( $query->posts as $key => $post_id ) {
			$ids[] = $post_id;
		}
	}
	return $ids;
}	

//Integration with WooCommerce
add_filter( 'woocommerce_get_shop_page_id','eos_scfm_woo_shop_id_filter' );
//It replaces the shop ID with the ID related to the mobile version if any
function eos_scfm_woo_shop_id_filter( $id ){
	if( wp_is_mobile() ){
		$mobile_post_id = eos_scfm_related_mobile_id( $id );
		if( $mobile_post_id > 0 ){
			return $mobile_post_id;
		}
	}
	return $id;
}





// Our filter callback function
function eos_scfm_default_post_types( $post_types ){
    return $post_types;
}
add_filter( 'eos_scfm_post_types','eos_scfm_default_post_types',10,1 );


//We give the possibility to external plugins to add support for more post types
function eos_scfm_post_types(){
	return apply_filters( 'eos_scfm_post_types',array( 'page','post' ) );
}