<?php
/**
 * @package 	WordPress
 * @subpackage 	Be Clean
 * @version		1.0.2
 * 
 * Main Theme Functions File
 * Created by CMSMasters
 * 
 */




/*** START EDIT THEME PARAMETERS HERE ***/

// Theme Settings System Fonts List
if (!function_exists('be_clean_system_fonts_list')) {
	function be_clean_system_fonts_list() {
		$fonts = array( 
			"Arial, Helvetica, 'Nimbus Sans L', sans-serif" => 'Arial', 
			"Calibri, 'AppleGothic', 'MgOpen Modata', sans-serif" => 'Calibri', 
			"'Trebuchet MS', Helvetica, Garuda, sans-serif" => 'Trebuchet MS', 
			"'Comic Sans MS', Monaco, 'TSCu_Comic', cursive" => 'Comic Sans MS', 
			"Georgia, Times, 'Century Schoolbook L', serif" => 'Georgia', 
			"Verdana, Geneva, 'DejaVu Sans', sans-serif" => 'Verdana', 
			"Tahoma, Geneva, Kalimati, sans-serif" => 'Tahoma', 
			"'Lucida Sans Unicode', 'Lucida Grande', Garuda, sans-serif" => 'Lucida Sans', 
			"'Times New Roman', Times, 'Nimbus Roman No9 L', serif" => 'Times New Roman', 
			"'Courier New', Courier, 'Nimbus Mono L', monospace" => 'Courier New', 
		);
		
		
		return $fonts;
	}
}



// Theme Settings Google Fonts List
if (!function_exists('be_clean_get_google_fonts_list')) {
	function be_clean_get_google_fonts_list() {
		$fonts = array( 
			'' => esc_html__('None', 'be-clean'), 
			'Titillium+Web:300,300italic,400,400italic,600,600italic,700,700italic' => 'Titillium Web', 
			'Roboto:300,300italic,400,400italic,500,500italic,700,700italic' => 'Roboto', 
			'Roboto+Condensed:400,400italic,700,700italic' => 'Roboto Condensed', 
			'Open+Sans:300,300italic,400,400italic,600,600italic,700,700italic' => 'Open Sans', 
			'Open+Sans+Condensed:300,300italic,700' => 'Open Sans Condensed', 
			'Droid+Sans:400,700' => 'Droid Sans', 
			'Droid+Serif:400,400italic,700,700italic' => 'Droid Serif', 
			'PT+Sans:400,400italic,700,700italic' => 'PT Sans', 
			'PT+Sans+Caption:400,700' => 'PT Sans Caption', 
			'PT+Sans+Narrow:400,700' => 'PT Sans Narrow', 
			'PT+Serif:400,400italic,700,700italic' => 'PT Serif', 
			'Ubuntu:400,400italic,700,700italic' => 'Ubuntu', 
			'Ubuntu+Condensed' => 'Ubuntu Condensed', 
			'Headland+One' => 'Headland One', 
			'Source+Sans+Pro:300,300italic,400,400italic,700,700italic' => 'Source Sans Pro', 
			'Lato:400,400italic,700,700italic' => 'Lato', 
			'Cuprum:400,400italic,700,700italic' => 'Cuprum', 
			'Oswald:300,400,700' => 'Oswald', 
			'Yanone+Kaffeesatz:300,400,700' => 'Yanone Kaffeesatz', 
			'Lobster' => 'Lobster', 
			'Lobster+Two:400,400italic,700,700italic' => 'Lobster Two', 
			'Questrial' => 'Questrial', 
			'Raleway:300,400,500,600,700' => 'Raleway', 
			'Dosis:300,400,500,700' => 'Dosis', 
			'Cutive+Mono' => 'Cutive Mono', 
			'Quicksand:300,400,700' => 'Quicksand', 
			'Montserrat:400,700' => 'Montserrat', 
			'Cookie' => 'Cookie', 
		);
		
		
		return $fonts;
	}
}



// Theme Settings Text Transforms List
if (!function_exists('be_clean_text_transform_list')) {
	function be_clean_text_transform_list() {
		$list = array( 
			'none' => esc_html__('none', 'be-clean'), 
			'uppercase' => esc_html__('uppercase', 'be-clean'), 
			'lowercase' => esc_html__('lowercase', 'be-clean'), 
			'capitalize' => esc_html__('capitalize', 'be-clean'), 
		);
		
		
		return $list;
	}
}



// Theme Settings Text Decorations List
if (!function_exists('be_clean_text_decoration_list')) {
	function be_clean_text_decoration_list() {
		$list = array( 
			'none' => esc_html__('none', 'be-clean'), 
			'underline' => esc_html__('underline', 'be-clean'), 
			'overline' => esc_html__('overline', 'be-clean'), 
			'line-through' => esc_html__('line-through', 'be-clean'), 
		);
		
		
		return $list;
	}
}



// Theme Settings Custom Color Schemes
if (!function_exists('be_clean_custom_color_schemes_list')) {
	function be_clean_custom_color_schemes_list() {
		$list = array( 
			'first' => esc_html__('Custom 1', 'be-clean'), 
			'second' => esc_html__('Custom 2', 'be-clean'), 
			'third' => esc_html__('Custom 3', 'be-clean') 
		);
		
		
		return $list;
	}
}



/*** STOP EDIT THEME PARAMETERS HERE ***/



// Theme Plugin Support Constants
if (!defined('CMSMASTERS_CONTENT_COMPOSER') && class_exists('Cmsmasters_Content_Composer')) {
	define('CMSMASTERS_CONTENT_COMPOSER', true);
} elseif (!defined('CMSMASTERS_CONTENT_COMPOSER')) {
	define('CMSMASTERS_CONTENT_COMPOSER', false);
}

if (!defined('CMSMASTERS_WOOCOMMERCE') && class_exists('woocommerce')) {
	define('CMSMASTERS_WOOCOMMERCE', true);
} elseif (!defined('CMSMASTERS_WOOCOMMERCE')) {
	define('CMSMASTERS_WOOCOMMERCE', false);
}

if (!defined('CMSMASTERS_EVENTS_CALENDAR') && class_exists('Tribe__Events__Main')) {
	define('CMSMASTERS_EVENTS_CALENDAR', false);
} elseif (!defined('CMSMASTERS_EVENTS_CALENDAR')) {
	define('CMSMASTERS_EVENTS_CALENDAR', false);
}

if (!defined('CMSMASTERS_PAYPALDONATIONS') && class_exists('PayPalDonations')) {
	define('CMSMASTERS_PAYPALDONATIONS', true);
} elseif (!defined('CMSMASTERS_PAYPALDONATIONS')) {
	define('CMSMASTERS_PAYPALDONATIONS', false);
}

if (!defined('CMSMASTERS_DONATIONS') && class_exists('Cmsmasters_Donations')) {
	define('CMSMASTERS_DONATIONS', false);
} elseif (!defined('CMSMASTERS_DONATIONS')) {
	define('CMSMASTERS_DONATIONS', false);
}

if (!defined('CMSMASTERS_TIMETABLE') && function_exists('timetable_events_init')) {
	define('CMSMASTERS_TIMETABLE', false);
} elseif (!defined('CMSMASTERS_TIMETABLE')) {
	define('CMSMASTERS_TIMETABLE', false);
}


// Theme Colored Categories Constant
if (!defined('CMSMASTERS_COLORED_CATEGORIES')) {
	define('CMSMASTERS_COLORED_CATEGORIES', true);
}

// Theme Projects Compatible
if (!defined('CMSMASTERS_PROJECT_COMPATIBLE')) {
	define('CMSMASTERS_PROJECT_COMPATIBLE', true);
}

// Theme Profiles Compatible
if (!defined('CMSMASTERS_PROFILE_COMPATIBLE')) {
	define('CMSMASTERS_PROFILE_COMPATIBLE', true);
}



// Theme Image Thumbnails Size
if (!function_exists('be_clean_get_image_thumbnail_list')) {
	function be_clean_get_image_thumbnail_list() {
		$list = array( 
			'cmsmasters-small-thumb' => array( 
				'width' => 		60, 
				'height' => 	60, 
				'crop' => 		true 
			), 
			'cmsmasters-square-thumb' => array( 
				'width' => 		300, 
				'height' => 	300, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Square', 'be-clean') 
			), 
			'cmsmasters-blog-masonry-thumb' => array( 
				'width' => 		580, 
				'height' => 	375, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Masonry Blog', 'be-clean') 
			), 
			'cmsmasters-project-thumb' => array( 
				'width' => 		580, 
				'height' => 	390, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Project', 'be-clean') 
			), 
			'cmsmasters-project-masonry-thumb' => array( 
				'width' => 		580, 
				'height' => 	9999, 
				'title' => 		esc_attr__('Masonry Project', 'be-clean') 
			), 
			'post-thumbnail' => array( 
				'width' => 		860, 
				'height' => 	480, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Featured', 'be-clean') 
			), 
			'cmsmasters-masonry-thumb' => array( 
				'width' => 		860, 
				'height' => 	9999, 
				'title' => 		esc_attr__('Masonry', 'be-clean') 
			), 
			'cmsmasters-full-thumb' => array( 
				'width' => 		1160, 
				'height' => 	750, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Full', 'be-clean') 
			), 
			'cmsmasters-project-full-thumb' => array( 
				'width' => 		1160, 
				'height' => 	648, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Project Full', 'be-clean') 
			), 
			'cmsmasters-full-masonry-thumb' => array( 
				'width' => 		1160, 
				'height' => 	9999, 
				'title' => 		esc_attr__('Masonry Full', 'be-clean') 
			) 
		);
		
		
		if (CMSMASTERS_EVENTS_CALENDAR) {
			$list['cmsmasters-event-thumb'] = array( 
				'width' => 		580, 
				'height' => 	380, 
				'crop' => 		true, 
				'title' => 		esc_attr__('Event', 'be-clean') 
			);
		}
		
		
		return $list;
	}
}



// Theme Settings All Color Schemes List
if (!function_exists('be_clean_all_color_schemes_list')) {
	function be_clean_all_color_schemes_list() {
		$list = array( 
			'default' => 		esc_html__('Default', 'be-clean'), 
			'header' => 		esc_html__('Header', 'be-clean'), 
			'navigation' => 	esc_html__('Navigation', 'be-clean'), 
			'header_top' => 	esc_html__('Header Top', 'be-clean'), 
			'footer' => 		esc_html__('Footer', 'be-clean') 
		);
		
		
		$out = array_merge($list, be_clean_custom_color_schemes_list());
		
		
		return apply_filters('cmsmasters_all_color_schemes_list_filter', $out);
	}
}



// Theme Settings Color Schemes Default Colors
if (!function_exists('be_clean_color_schemes_defaults')) {
	function be_clean_color_schemes_defaults() {
		$list = array( 
			'default' => array( // content default color scheme
				'color' => 		'#696b6f', 
				'link' => 		'#5ebed6', 
				'hover' => 		'#888a8e', 
				'heading' => 	'#373a42', 
				'bg' => 		'#ffffff', 
				'alternate' => 	'#fcfcfc', 
				'border' => 	'#e7e7e7' 
			), 
			'header' => array( // Header color scheme
				'mid_color' => 		'#696b6f', 
				'mid_link' => 		'#5ebed6', 
				'mid_hover' => 		'#888a8e', 
				'mid_bg' => 		'#ffffff', 
				'mid_bg_scroll' => 	'#ffffff', 
				'mid_border' => 	'#e7e7e7', 
				'bot_color' => 		'#696b6f', 
				'bot_link' => 		'#5ebed6', 
				'bot_hover' => 		'#888a8e', 
				'bot_bg' => 		'#ffffff', 
				'bot_bg_scroll' => 	'#ffffff', 
				'bot_border' => 	'#e7e7e7' 
			), 
			'navigation' => array( // Navigation color scheme
				'title_link' => 			'#373a42', 
				'title_link_hover' => 		'#5ebed6', 
				'title_link_current' => 	'#5ebed6', 
				'title_link_subtitle' => 	'#888a8e', 
				'title_link_bg' => 			'rgba(255,255,255,0)', 
				'title_link_bg_hover' => 	'rgba(255,255,255,0)', 
				'title_link_bg_current' => 	'rgba(255,255,255,0)', 
				'title_link_border' => 		'rgba(255,255,255,0)', 
				'dropdown_text' => 			'#696b6f', 
				'dropdown_bg' => 			'#ffffff', 
				'dropdown_border' => 		'#e7e7e7', 
				'dropdown_link' => 			'#373a42', 
				'dropdown_link_hover' => 	'#5ebed6', 
				'dropdown_link_subtitle' => '#888a8e', 
				'dropdown_link_highlight' => 'rgba(255,255,255,0)', 
				'dropdown_link_border' => 	'rgba(255,255,255,0)' 
			), 
			'header_top' => array( // Header Top color scheme
				'color' => 					'#ffffff', 
				'link' => 					'#ffffff', 
				'hover' => 					'rgba(255,255,255,0.6)', 
				'bg' => 					'#5ebed6', 
				'border' => 				'rgba(255,255,255,0)', 
				'title_link' => 			'#ffffff', 
				'title_link_hover' => 		'rgba(255,255,255,0.6)', 
				'title_link_bg' => 			'rgba(255,255,255,0)', 
				'title_link_bg_hover' => 	'rgba(255,255,255,0)', 
				'title_link_border' => 		'rgba(255,255,255,0)', 
				'dropdown_bg' => 			'#ffffff', 
				'dropdown_border' => 		'rgba(255,255,255,0)', 
				'dropdown_link' => 			'#373a42', 
				'dropdown_link_hover' => 	'#5ebed6', 
				'dropdown_link_highlight' => 'rgba(255,255,255,0)', 
				'dropdown_link_border' => 	'rgba(255,255,255,0)' 
			), 
			'footer' => array( // Footer color scheme
				'color' => 		'#ffffff', 
				'link' => 		'#ffffff', 
				'hover' => 		'rgba(255,255,255,0.6)', 
				'heading' => 	'#ffffff', 
				'bg' => 		'#5ebed6', 
				'alternate' => 	'rgba(255,255,255,0)', 
				'border' => 	'rgba(255,255,255,0.25)' 
			), 
			'first' => array( // custom color scheme 1
				'color' => 		'#373a42', 
				'link' => 		'#5ebed6', 
				'hover' => 		'#888a8e', 
				'heading' => 	'#373a42', 
				'bg' => 		'#ffffff', 
				'alternate' => 	'#fcfcfc', 
				'border' => 	'#e7e7e7' 
			), 
			'second' => array( // custom color scheme 2
				'color' => 		'#696b6f', 
				'link' => 		'#5ebed6', 
				'hover' => 		'#888a8e', 
				'heading' => 	'#373a42', 
				'bg' => 		'#ffffff', 
				'alternate' => 	'#fcfcfc', 
				'border' => 	'#e7e7e7' 
			), 
			'third' => array( // custom color scheme 3
				'color' => 		'#696b6f', 
				'link' => 		'#5ebed6', 
				'hover' => 		'#888a8e', 
				'heading' => 	'#373a42', 
				'bg' => 		'#ffffff', 
				'alternate' => 	'#fcfcfc', 
				'border' => 	'#e7e7e7' 
			) 
		);
		
		
		return $list;
	}
}



// CMSMasters Framework Directories Constants
if (!defined('CMSMASTERS_FRAMEWORK')) {
	define('CMSMASTERS_FRAMEWORK', 'framework');
}

if (!defined('CMSMASTERS_ADMIN')) {
	define('CMSMASTERS_ADMIN', CMSMASTERS_FRAMEWORK . '/admin');
}

if (!defined('CMSMASTERS_SETTINGS')) {
	define('CMSMASTERS_SETTINGS', CMSMASTERS_ADMIN . '/settings');
}

if (!defined('CMSMASTERS_OPTIONS')) {
	define('CMSMASTERS_OPTIONS', CMSMASTERS_ADMIN . '/options');
}

if (!defined('CMSMASTERS_ADMIN_INC')) {
	define('CMSMASTERS_ADMIN_INC', CMSMASTERS_ADMIN . '/inc');
}

if (!defined('CMSMASTERS_CLASS')) {
	define('CMSMASTERS_CLASS', CMSMASTERS_FRAMEWORK . '/class');
}

if (!defined('CMSMASTERS_FUNCTION')) {
	define('CMSMASTERS_FUNCTION', CMSMASTERS_FRAMEWORK . '/function');
}


if (!defined('CMSMASTERS_COMPOSER')) {
	define('CMSMASTERS_COMPOSER', 'cmsmasters-c-c');
}



// Load Framework Parts
locate_template(CMSMASTERS_ADMIN_INC . '/config-functions.php', true);

locate_template(CMSMASTERS_FUNCTION . '/theme-functions.php', true);

locate_template(CMSMASTERS_SETTINGS . '/cmsmasters-theme-settings.php', true);

locate_template(CMSMASTERS_OPTIONS . '/cmsmasters-theme-options.php', true);

locate_template(CMSMASTERS_ADMIN_INC . '/admin-scripts.php', true);

locate_template(CMSMASTERS_ADMIN_INC . '/plugin-activator.php', true);

locate_template(CMSMASTERS_CLASS . '/likes-posttype.php', true);

locate_template(CMSMASTERS_CLASS . '/twitteroauth.php', true);

locate_template(CMSMASTERS_CLASS . '/widgets.php', true);

locate_template(CMSMASTERS_FUNCTION . '/breadcrumbs.php', true);

locate_template(CMSMASTERS_FUNCTION . '/likes.php', true);

locate_template(CMSMASTERS_FUNCTION . '/pagination.php', true);

locate_template(CMSMASTERS_FUNCTION . '/single-comment.php', true);

locate_template(CMSMASTERS_FUNCTION . '/theme-fonts.php', true);

locate_template(CMSMASTERS_FUNCTION . '/theme-colors-primary.php', true);

locate_template(CMSMASTERS_FUNCTION . '/theme-colors-secondary.php', true);

locate_template(CMSMASTERS_FUNCTION . '/template-functions.php', true);

locate_template(CMSMASTERS_FUNCTION . '/template-functions-post.php', true);

locate_template(CMSMASTERS_FUNCTION . '/template-functions-project.php', true);

locate_template(CMSMASTERS_FUNCTION . '/template-functions-profile.php', true);

locate_template(CMSMASTERS_FUNCTION . '/template-functions-shortcodes.php', true);

locate_template(CMSMASTERS_FUNCTION . '/template-functions-widgets.php', true);


// Theme Colored Categories Functions
if (CMSMASTERS_COLORED_CATEGORIES) {
	locate_template(CMSMASTERS_FUNCTION . '/theme-colored-categories.php', true);
}


if (class_exists('Cmsmasters_Content_Composer')) {
	locate_template(CMSMASTERS_COMPOSER . '/filters/cmsmasters-c-c-atts-filters.php', true);
}


// CMSMASTERS Donations functions
if (CMSMASTERS_DONATIONS) {
	locate_template('cmsmasters-donations/function/template-functions-donation.php', true);
}

// Woocommerce functions
if (CMSMASTERS_WOOCOMMERCE) {
	locate_template('woocommerce/cmsmasters-woo-functions.php', true);
}

// Events functions
if (CMSMASTERS_EVENTS_CALENDAR) {
	locate_template('tribe-events/cmsmasters-events-functions.php', true);
}



// Load Theme Local File
if (!function_exists('be_clean_load_theme_textdomain')) {
	function be_clean_load_theme_textdomain() {
		load_theme_textdomain('be-clean', get_template_directory() . '/' . CMSMASTERS_FRAMEWORK . '/languages');
	}
}

// Load Theme Local File Action
if (!has_action('after_setup_theme', 'be_clean_load_theme_textdomain')) {
	add_action('after_setup_theme', 'be_clean_load_theme_textdomain');
}




// Framework Activation & Data Import
if (!function_exists('be_clean_theme_activation')) {
	function be_clean_theme_activation() {
		if (get_option('cmsmasters_active_theme') != CMSMASTERS_SHORTNAME) {
			add_option('cmsmasters_active_theme', CMSMASTERS_SHORTNAME, '', 'yes');
			
			
			be_clean_add_global_options();
			
			
			be_clean_regenerate_styles();
			
			
			be_clean_add_global_icons();
			
			
			
			wp_redirect(esc_url(admin_url('admin.php?page=cmsmasters-settings&upgraded=true')));
		}
	}
}

add_action('after_switch_theme', 'be_clean_theme_activation');



// Framework Deactivation
if (!function_exists('be_clean_theme_deactivation')) {
	function be_clean_theme_deactivation() {
		delete_option('cmsmasters_active_theme');
	}
}

// Framework Deactivation Action
if (!has_action('switch_theme', 'be_clean_theme_deactivation')) {
	add_action('switch_theme', 'be_clean_theme_deactivation');
}

