<?php

if ( post_password_required() ) {
	return;
}
?>
<?php 
?>
<div id="comments" class="comments-area">

	<?php if ( have_comments() ) : ?>
		<h4>
			<?php echo number_format_i18n( get_comments_number())." Comments";?>
		</h4>
		<p class="mad_bottom3"><?php echo esc_html__('See what other people say about this article.','helpmate');?></p>
		<div class="comment_section">
		<ul class="commentlist">
			<?php
				wp_list_comments( 'reply_text=Reply&style=ul&short_ping=true&avatar_size=68&callback=helpmate_comment_body_template&max_depth=5');
			?>
		</ul>
		</div>
		<?php helpmate_comment_nav(); ?>
	
	<?php endif; ?>

	<?php
		if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="no-comments"><?php echo esc_html__( 'Comments are closed.', 'helpmate' ); ?></p>
	<?php endif; ?>

	<div class="comment-form">
		<?php 

		$commenter = wp_get_current_commenter();
		$req = get_option( 'require_name_email' );
		$aria_req = ( $req ? " aria-required='true'" : '' );
		$comment_login='';
		if ( !function_exists('is_user_logged_in') ){
			if ( is_user_logged_in() ) {$comment_login="comment-field-login";}
		}
		
		$comment_args = array( 
			'class_form' => 'form_type_1',
			'comment_field' => '<div class="control-group '.$comment_login.' ">' .
		       		'<label class="control-label">'.esc_html__('Comment','helpmate').( $req ? '*' : '' ) .': </label><div class="controls"><textarea id="comment" class="required" name="comment" cols="45" rows="4" aria-required="true"></textarea></div></div>' .
		   		'',
			'fields' => apply_filters( 'comment_form_default_fields', array(
			    'author' => '<div class="control-group"><label class="control-label">'.esc_html__('Name','helpmate').
			                ( $req ? '*' : '' ) .
			         	': </label><div class="controls"><input id="author" class="required" name="author" type="text" value="' .
			                esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' /></div></div>' .
			     	'',
			    'email'  => '<div class="control-group"><label class="control-label">'.esc_html__('Email','helpmate') .( $req ? '*' : '' ) .
			          	': </label><div class="controls"><input id="email" class="required email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' /></div></div>' .
					'',
			    'url'    => '<div class="control-group"><label class="control-label">'.esc_html__('Website:','helpmate').
			          	'</label><div class="controls"><input id="url" name="url" type="text" value="' . esc_attr(  $commenter['comment_author_url'] ) . '" size="30"' . $aria_req . ' /></div></div>' ) ),

			'title_reply'  => esc_html__( 'Leave a Comment','helpmate' ),
			'cancel_reply_link' => esc_html__('Cancel reply','helpmate'),		    
		   	'logged_in_as' => '',
		   	'class_submit' => 'hidden',
		    'comment_notes_before' => '<p class="mad_bottom">'.esc_html__('All fields with * are required.','helpmate').'</p>',
		    'label_submit'		=> 'submit',
		    'comment_notes_after' => '<button type="submit" class="button type1"><span><span>'.esc_html__('Submit','helpmate').'</span><span>'.esc_html__('Submit','helpmate').'</span></span></button>',
		);
		?>

		<?php comment_form($comment_args); ?>
	<?php
	?> 
	</div>
                <script type="text/javascript">
                    jQuery(document).ready(function($) {
                        $('#commentform').validate();
                    })
                </script>

</div>
