<?php
$helpmate_settings = helpmate_check_theme_options();
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="profile" href="http://gmpg.org/xfn/11" />
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
    <?php if (!empty($helpmate_settings['favicon'])): ?>
        <link rel="shortcut icon" href="<?php echo esc_url(str_replace(array('http:', 'https:'), '', $helpmate_settings['favicon']['url'])); ?>" type="image/x-icon" />
    <?php endif; ?>
    <?php wp_head(); ?>
</head>
<body class="home page_coming_soon mad_main">
<div id="primary" class="site-content mad_coming_soon">
    <div id="content" role="main">
    	<div class="menu_holder_with_bg var2 ">
			<a class="logo" href="<?php echo esc_url(home_url('/')); ?>" rel="home">
				<?php
                    if ($helpmate_settings['logo'] && $helpmate_settings['logo']['url']):
                        echo '<img class="" src="' . esc_url(str_replace(array('http:', 'https:'), '', $helpmate_settings['logo']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '" />';
                    else:
                        bloginfo('name');
                    endif;
                ?>
			</a>
		</div>
    	<div class="mad_section">
    		<div class="container">	
				<div class="row">  
					<div class="col-md-12 col-sm-12 col-xs-12 coming-soon-container">
						<div class="align_center">
							<?php if(isset($helpmate_settings['under-contr-content']) && $helpmate_settings['under-contr-content'] != ''):?>
								<?php echo wpautop(html_entity_decode($helpmate_settings['under-contr-content']));?>

							<?php else:?>
								<h2><?php echo esc_html__('Currently we are under construction','helpmate');?></h2>
								<p class="mad_bottom"><?php echo esc_html__('We will be back in:','helpmate');?></p>
							<?php endif;?>		
							<?php if($helpmate_settings['under-display-countdown'] == 1):?>
								<?php if(isset($helpmate_settings['under-end-date']) && $helpmate_settings['under-end-date'] != ''):?>
									<div id="countdown" data-date="<?php echo esc_attr($helpmate_settings['under-end-date']);?> 00:00:00"></div>
								<?php endif;?>
							<?php endif;?>
						</div>
					</div>
				</div>
			</div>
		</div>
		<div class="mad_section_bg1">
			<div class="container">	
	          	<div class="row">
		            <div class="col-md-6 col-sm-6 col-xs-12">
		              <h4><?php echo esc_html__('Notify Me','helpmate');?></h4>
						<?php 
							$form_shortcode = isset($helpmate_settings['comming_form']) ? $helpmate_settings['comming_form'] :"";   
					        if($form_shortcode != ""){
					          echo do_shortcode(''.$form_shortcode.'');
					        }
					    ?> 
		            </div>
		            <div class="col-md-6 col-sm-6 col-xs-12">
		              	<h4><?php echo esc_html__('Stay Connected','helpmate');?></h4>
		                  <?php if ($helpmate_settings['list-link-social']): ?>
		                    <div class="social_icon_list">
		                        <ul>
		                            <?php if (!empty($helpmate_settings['social-facebook'])): ?>
		                                <li><a href="<?php echo esc_url($helpmate_settings['social-facebook']) ?>" class="soc_icon icon_facebook"></a></li>
		                            <?php endif; ?>
		                            <?php if (!empty($helpmate_settings['social-twitter'])): ?>
		                                <li><a href="<?php echo esc_url($helpmate_settings['social-twitter']) ?>" class="soc_icon icon_twitter"></a></li>
		                            <?php endif; ?>
		                            <?php if (!empty($helpmate_settings['social-rss'])): ?>
		                                <li><a href="<?php echo esc_url($helpmate_settings['social-rss']) ?>" class="soc_icon icon_rss"></a></li>
		                            <?php endif; ?>
		                            <?php if (!empty($helpmate_settings['social-gplus'])): ?>
		                                <li><a href="<?php echo esc_url($helpmate_settings['social-gplus']) ?>" class="soc_icon icon_gplus"></a></li>
		                            <?php endif; ?> 
		                            <?php if (!empty($helpmate_settings['social-vimeo'])): ?>
		                                <li><a href="<?php echo esc_url($helpmate_settings['social-vimeo']) ?>" class="soc_icon icon_vimeo"></a></li>
		                            <?php endif; ?>
		                            <?php if (!empty($helpmate_settings['social-behance'])): ?>
		                                <li><a href="<?php echo esc_url($helpmate_settings['social-behance']) ?>" class="soc_icon icon_behance"></a></li>
		                            <?php endif; ?> 
		                            <?php if (!empty($helpmate_settings['social-flickr'])): ?>
		                                <li><a href="<?php echo esc_url($helpmate_settings['social-flickr']) ?>" class="soc_icon icon_flickr"></a></li>
		                            <?php endif; ?>
		                            <?php if (!empty($helpmate_settings['social-yahoo'])): ?>
		                                <li><a href="<?php echo esc_url($helpmate_settings['social-yahoo']) ?>" class="soc_icon icon_yahoo"></a></li>
		                            <?php endif; ?>                            
		                        </ul>
		                    </div>
		            	<?php endif; ?>
		            </div>
	       		 </div>
	        </div>
	    </div>
	    <?php if ($helpmate_settings['footer-copyright']) : ?>
			<div class="bottom-footer">
				<div class="container">			
					<p><?php echo force_balance_tags(esc_html($helpmate_settings['footer-copyright'])); ?></p>			
				</div>
			</div>
		<?php endif;?>
    </div><!-- #content -->
</div><!-- #primary -->
</body>
<?php wp_footer(); ?>
</html>