<?php 
    $helpmate_settings = helpmate_check_theme_options();
    $post_layout = isset($helpmate_settings['post-layout-version']) ? $helpmate_settings['post-layout-version'] :'';
    if (is_category()){
        $category = get_category( get_query_var( 'cat' ) );
        $cat_id = $category->cat_ID;
        if(get_metadata('category', $cat_id, 'blog_layout', true) != 'default'){
            $post_layout = get_metadata('category', $cat_id, 'blog_layout', true);
        }
    }
    $gallery = get_post_meta(get_the_ID(), 'images_gallery', true);
    $helpmate_skin = get_post_meta(get_the_ID(),'skin',true);
    $current_page = get_query_var('paged') ? intval(get_query_var('paged')) : 1;
?>
<?php if($post_layout == 'grid'):?>
    <?php $i=0; // counter?>
        <?php while (have_posts()) : the_post(); 
            if($i%2==0) { 
                echo '<div class="row">';
            }
        ?>
            <div class="col-sm-6">
            <?php helpmate_get_blog_content($post);?>
            </div>
            <?php $i++;
                if($i%2==0) { 
                    echo '</div>';
                } ?>
        <?php endwhile; ?>
            <?php
                if($i%2!=0) {
                    echo '</div>';
                }
            ?>
        <?php if ($wp_query->max_num_pages > 1) : ?>
        <div class="pagination_list clearfix">
            <?php helpmate_pagination();?>
            <ul class="f_right">
                <li class="pagination_button_prev"><?php previous_posts_link( esc_html__('Previous','helpmate') ); ?></li>
                <li class="pagination_button_next"><?php next_posts_link(esc_html__('Next','helpmate')); ?></li>
            </ul>
        </div>
        <?php endif;?>
<?php elseif($post_layout == 'masonry'):?>
    <div class="row">
        <div class="tabs_sort">
            <div class="isotope post_wrapper_ajax two_collumn clearfix" data-isotope-options='{"itemSelector" : ".item","layoutMode" : "masonry","transitionDuration":"0.7s","masonry" : {"columnWidth":".item"}}'>
            <?php while (have_posts()) : the_post(); ?>
                <div class="item">
                    <div class="post_news">
                        <div class="post_item">
                            <div class="blog-main">   
                                <?php helpmate_get_post_media();?>
                                <div class="post_body">
                                    <div class="post_meta"><?php echo esc_html__('On','helpmate');?> <?php echo get_the_time('M d, Y'); ?></div>
                                    <a class="post_title_block" href="<?php the_permalink(); ?>"><h4><?php the_title(); ?></h4>
                                        <?php  if ( is_sticky() && is_home() && ! is_paged() ):?>
                                            <span class="sticky_post"><?php echo esc_html__('Featured', 'helpmate')?></span>
                                        <?php endif;?>                                      
                                    </a>
                                    <?php if (!has_excerpt()) : ?>                            
                                        <?php the_excerpt(); ?> 
                                    <?php else:?>
                                        <?php
                                        echo '<div class="entry-content">';
                                        the_content();
                                        wp_link_pages( array(
                                            'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'helpmate' ) . '</span>',
                                            'after'       => '</div>',
                                            'link_before' => '<span>',
                                            'link_after'  => '</span>',
                                            'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'helpmate' ) . ' </span>%',
                                            'separator'   => '<span class="screen-reader-text">, </span>',
                                        ) );
                                        echo '</div>';
                                        ?>
                                    <?php endif; ?>
                                    <div class="post_social">
                                      <div class="post_social_item clearfix">
                                        <div class="post_social_autor">
                                            <?php $author_id= $post->post_author;?>
                                            <span><?php echo esc_html__('By:','helpmate');?> </span><a href="<?php echo esc_url(get_edit_user_link( $author_id )); ?>"><?php the_author_meta( 'nickname' , $author_id ); ?></a>
                                        </div>
                                        <div class="post_social_event">
                                          <a href="<?php comments_link(); ?>" class="social_comment"><span>
                                          <?php comments_number( '0', '1', '%' )?></span></a>
                                        </div>
                                      </div>
                                      <div class="post_social_item clearfix">
                                        <div class="post_social_autor">
                                          <span><?php echo esc_html__('In:','helpmate');?> </span><?php echo get_the_category_list(', '); ?>
                                        </div>
                                        <div class="post_social_event">
                                          <?php  if(function_exists('helpmate_getPostLikeLink')) {
                                            echo helpmate_getPostLikeLink( get_the_ID() );
                                            }
                                            ?>
                                        </div>
                                      </div>
                                    </div>
                                    <a href="<?php the_permalink(); ?>" class="button type1"><span><span><?php echo esc_html__('Read More', 'helpmate'); ?></span><span><?php echo esc_html__('Read More', 'helpmate'); ?></span></span></a>
                                </div>


                            </div>
                        </div>
                    </div> 
                </div>
            <?php endwhile; ?>
            </div>
            <?php if ($wp_query->max_num_pages > 1) : ?>
                <div class="align_center">
                    <a id="load_more" class="helpmate_ajax_load_more button type1" data-paged="<?php echo esc_attr($current_page) ?>" data-totalpage="<?php echo esc_attr($wp_query->max_num_pages) ?>"><span><span><?php esc_html_e( 'Load More', 'helpmate' );?></span><span><?php esc_html_e( 'Load More', 'helpmate' );?></span></span></a>
                </div>
            <?php endif;?>
        </div>  
    </div>            
<?php else:?>
    <?php while (have_posts()) : the_post(); ?>
        <?php helpmate_get_blog_content($post);?>
    <?php endwhile; ?>
    <?php if ($wp_query->max_num_pages > 1) : ?>
    <div class="pagination_list clearfix">
        <?php helpmate_pagination();?>
        <ul class="f_right">
            <li class="pagination_button_prev"><?php previous_posts_link( esc_html__('Previous','helpmate') ); ?></li>
            <li class="pagination_button_next"><?php next_posts_link(esc_html__('Next','helpmate')); ?></li>
        </ul>
    </div>
    <?php endif;?>
<?php endif;?>
<?php 
function helpmate_get_blog_content($post){
    ?>
    <div class="post_news">
        <div class="post_item">
            <div class="blog-main">   
                <?php helpmate_get_post_media();?>
                <div class="post_body">
                    <div class="post_meta"><?php echo esc_html__('On','helpmate');?> <?php echo get_the_time('M d, Y'); ?></div>
                    <a class="post_title_block" href="<?php the_permalink(); ?>"><h4><?php the_title(); ?></h4>
                            <?php  if ( is_sticky() && is_home() && ! is_paged() ):?>
                                <span class="sticky_post"><?php echo esc_html__('Featured', 'helpmate')?></span>
                            <?php endif;?>                      
                    </a>
                    <?php the_excerpt(); ?>
                    <?php 
                        wp_link_pages( array(
                            'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'helpmate' ) . '</span>',
                            'after'       => '</div>',
                            'link_before' => '<span>',
                            'link_after'  => '</span>',
                            'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'helpmate' ) . ' </span>%',
                            'separator'   => '<span class="screen-reader-text">, </span>',
                        ) );
                    ?>
                    <div class="post_social">
                      <div class="post_social_item clearfix">
                        <div class="post_social_autor">
                            <?php $author_id= $post->post_author;?>
                            <span><?php echo esc_html__('By:','helpmate');?> </span><a href="<?php echo esc_url(get_edit_user_link( $author_id )); ?>"><?php the_author_meta( 'nickname' , $author_id ); ?></a>
                        </div>
                        <div class="post_social_event">
                          <a href="<?php comments_link(); ?>" class="social_comment"><span>
                          <?php comments_number( '0', '1', '%' )?></span></a>
                        </div>
                      </div>
                      <div class="post_social_item clearfix">
                        <div class="post_social_autor">
                          <span><?php echo esc_html__('In:','helpmate');?> </span><?php echo get_the_category_list(', '); ?>
                        </div>
                        <div class="post_social_event">
                          <?php  if(function_exists('helpmate_getPostLikeLink')) {
                            echo helpmate_getPostLikeLink( get_the_ID() );
                            }
                            ?>
                        </div>
                      </div>
                    </div>
                </div>
                <a href="<?php the_permalink(); ?>" class="button type1"><span><span><?php echo esc_html__('Read More', 'helpmate'); ?></span><span><?php echo esc_html__('Read More', 'helpmate'); ?></span></span></a>

            </div>
        </div>
    </div>   
    <?php
}