<?php 
$helpmate_settings = helpmate_check_theme_options();
$current_page = get_query_var('paged') ? intval(get_query_var('paged')) : 1;
$classes = '';
switch ( $helpmate_settings['gallery-cols'] ) {
    case '1':
        $classes = ' ';
        break;
    case '2':
        $classes = 'col-sm-6';
        break;
    default:
        $classes = 'col-sm-4';
        break;
}
$count_item = 0;
?>
<div class="mad_blog mad_portfolio classic_gallery">
	<?php while (have_posts()) : the_post(); ?>
	<?php 
		$author = get_the_author();
		$image_url = wp_get_attachment_url( get_post_thumbnail_id() );
	?>
	<?php if($helpmate_settings['gallery-cols'] != '1') :?>
		<?php 
			$count_item++;
			if ( $count_item == 1 ) echo '<div class="post_news"><div class="row">';
            if ( ($count_item-1) % $helpmate_settings['gallery-cols'] == 0 && $count_item > $helpmate_settings['gallery-cols'] ) echo '<div class="post_news"><div class="row">';
                if ( $helpmate_settings['gallery-cols'] == '3' ){
                    echo '<div class="col-sm-4">';
                }else{
                    echo '<div class="col-sm-6">';
                }
                ?>
                	<div class="post_item">
                  		<?php if ( has_post_thumbnail() ) : ?>
		                  <figure>
		                    <div class="post_image plus_link">
		                      		<?php 
				                    $attachment_id = get_post_thumbnail_id();
				                    $attachment_2_column = helpmate_get_attachment($attachment_id, 'helpmate_portfolio_2_column');
				                    $attachment_3_column = helpmate_get_attachment($attachment_id, 'helpmate_portfolio_3_column'); 
				                    ?>
				                    <?php if ( $helpmate_settings['gallery-cols'] == '2' ) :?>
				                    <img class="img-responsive" width="<?php echo esc_attr($attachment_2_column['width']) ?>" height="<?php echo esc_attr($attachment_2_column['height']) ?>" src="<?php echo esc_url($attachment_2_column['src']) ?>" alt="<?php echo esc_attr($attachment_2_column['alt']) ?>" />
				                    <?php else :?>
				                    <img class="img-responsive" width="<?php echo esc_attr($attachment_3_column['width']) ?>" height="<?php echo esc_attr($attachment_3_column['height']) ?>" src="<?php echo esc_url($attachment_3_column['src']) ?>" alt="<?php echo esc_attr($attachment_3_column['alt']) ?>" />
		                      		<?php endif;?>
		                      <div class="curtain two_items">
		                        <a href="<?php echo esc_url($image_url);?>" class="gallery" rel="category"></a>
		                        <a href="<?php the_permalink();?>" class="link" rel="category"></a>
		                      </div> 
		                    </div>
		                  </figure>
		                <?php endif;?>  
		                  <div class="post_body">
		                    <a href="<?php the_permalink();?>"><h4><?php the_title();?></h4></a>
		                    <div class="post_social">
		                      <div class="post_social_item clearfix">
		                        <div class="post_social_autor">
		                          <span><?php esc_html_e( 'By:', 'helpmate' );?> </span><a href="<?php echo esc_url(get_edit_user_link( $post->post_author )); ?>"><?php echo esc_html($author);?></a>
		                        </div>
		                        <div class="post_social_event">
		                          <?php comments_popup_link('<span>'.esc_html__('0', 'helpmate').'</span>', '<span>'.esc_html__('1', 'helpmate').'</span>', '<span>'.esc_html__('%', 'helpmate').'</span>', 'social_comment'); ?>
		                        </div>
		                      </div>
		                      <div class="post_social_item clearfix">
		                        <div class="post_social_autor">
		                          <span><?php esc_html_e( 'In:', 'helpmate' );?> </span><?php echo get_the_term_list( $post->ID, 'gallery_cat', '', ', ', '' );?>
		                        </div>
		                      </div>
		                    </div>
		                    <?php the_content();?>
		                  </div>
		                  <a href="<?php the_permalink(); ?>" class="button type1"><span><span><?php esc_html_e( 'Read More', 'helpmate' );?></span><span><?php esc_html_e( 'Read More', 'helpmate' );?></span></span></a>
			        <a href="<?php the_permalink(); ?>" class="button type1"><span><span><?php esc_html_e( 'View Project', 'helpmate' );?></span><span><?php esc_html_e( 'View Project', 'helpmate' );?></span></span></a>

		            </div>
                <?php
                echo '</div>';
            if ( $count_item == $helpmate_settings['gallery-cols'] ) echo '</div></div>';
            if ( $count_item % $helpmate_settings['gallery-cols'] == 0 && $count_item > $helpmate_settings['gallery-cols'] ) echo '</div></div>';
		?>
	<?php else :?>
	<div class="post_news mad_list_view">            
		<div class="row">
		  <div class="col-sm-8">
		  	<?php if ( has_post_thumbnail() ) : ?>
		    <figure>
		      <div class="post_image plus_link">
		        	<?php 
                    $attachment_id = get_post_thumbnail_id();
                    $attachment_1_column = helpmate_get_attachment($attachment_id, 'helpmate_portfolio_1_column');
                    ?>
		        	<img class="img-responsive" width="<?php echo esc_attr($attachment_1_column['width']) ?>" height="<?php echo esc_attr($attachment_1_column['height']) ?>" src="<?php echo esc_url($attachment_1_column['src']) ?>" alt="<?php echo esc_attr($attachment_1_column['alt']) ?>" />
		        <div class="curtain two_items">	
		          <a href="<?php echo esc_url($image_url);?>" class="gallery" rel="category"></a>
		          <a href="<?php the_permalink();?>" class="link" rel="category"></a>
		        </div> 
		      </div>
		    </figure>
			<?php endif;?>
		  </div>
		  <div class="col-sm-4">
		    <div class="post_item">
		        
		      <div class="post_body">
		        <a href="<?php the_permalink();?>"><h4><?php the_title();?></h4></a>
		        <div class="post_social">
		          <div class="post_social_item clearfix">
		            <div class="post_social_autor">
		              <span><?php esc_html_e( 'By:', 'helpmate' );?> </span><a href="<?php echo esc_url(get_edit_user_link( $post->post_author )); ?>"><?php echo esc_html($author);?></a>
		            </div>
		            <div class="post_social_event">
		              <?php comments_popup_link('<span>'.esc_html__('0', 'helpmate').'</span>', '<span>'.esc_html__('1', 'helpmate').'</span>', '<span>'.esc_html__('%', 'helpmate').'</span>', 'social_comment'); ?>
		            </div>
		          </div>
		          <div class="post_social_item clearfix">
		            <div class="post_social_autor">
		              <span><?php esc_html_e( 'In:', 'helpmate' );?> </span><?php echo get_the_term_list($post->ID,'gallery_cat', '', ', ' ); ?>
		            </div>
		          </div>
		        </div>
		        <?php the_content();?>
		      </div>
		      <a href="<?php the_permalink(); ?>" class="button type1"><span><span><?php esc_html_e( 'Read More', 'helpmate' );?></span><span><?php esc_html_e( 'Read More', 'helpmate' );?></span></span></a>
			  <a href="<?php the_permalink(); ?>" class="button type1"><span><span><?php esc_html_e( 'View Project', 'helpmate' );?></span><span><?php esc_html_e( 'View Project', 'helpmate' );?></span></span></a>
		    </div>
		  </div>

		</div><!--end row -->
	</div>
	<?php endif;?>
	<?php endwhile;?>
	<?php if ( $count_item % $helpmate_settings['gallery-cols'] != 0 ) echo '</div>'; ?>
</div>
<?php if(isset($helpmate_settings['gallery-archive-pagination-type']) && $helpmate_settings['gallery-archive-pagination-type'] =='loadmore'):?>
	<?php if ($wp_query->max_num_pages > 1) : ?>
    <div class="align_center space-top-45">
      <a class="portfolio_ajax_load_more button type1 load-more" data-paged="<?php echo esc_attr($current_page) ?>" data-totalpage="<?php echo esc_attr($wp_query->max_num_pages) ?>"><span><span><?php esc_html_e( 'Load More', 'helpmate' );?></span><span><?php esc_html_e( 'Load More', 'helpmate' );?></span></span></a>
    </div> 
     <?php endif;?>
<?php else:?>
	<div class="pagination_list clearfix col-md-12">
		<?php helpmate_pagination(); ?>
		<ul class="f_right">
		  <li class="pagination_button_prev"><?php previous_posts_link( esc_html__('Previous','helpmate') ); ?></li>
		  <li class="pagination_button_next"><?php next_posts_link(esc_html__('Next','helpmate')); ?></li>
		</ul>
	</div> 
<?php endif;?>
