<?php 
$helpmate_settings = helpmate_check_theme_options();
$current_page = get_query_var('paged') ? intval(get_query_var('paged')) : 1;
$taxonomy_names = get_object_taxonomies( 'gallery' );

if(is_tax('gallery_cat')){
	$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) ); // get current term
	$children = get_term_children($term->term_id, get_query_var('taxonomy')); // get children
	if(($term->parent==0 && sizeof($children)>0)) {

		if ( is_array( $taxonomy_names ) && count( $taxonomy_names ) > 0  && in_array( 'gallery_cat', $taxonomy_names ) ) {
		    $terms = get_terms( 'gallery_cat', array(
		        'hide_empty'        => false,
		        'parent'			=> $term->term_id,
		        ) );
		}

	}if(($term->parent==0 && sizeof($children)==0)) {

		if ( is_array( $taxonomy_names ) && count( $taxonomy_names ) > 0  && in_array( 'gallery_cat', $taxonomy_names ) ) {
		    $terms = get_terms( 'gallery_cat', array(
		        'hide_empty'        => false,
		        'parent'			=> 0,
		        ) );
		}

	}elseif(($term->parent!=0) && (sizeof($children)==0)) {
		$terms ="";
		// has parent, no child
	}

}else{
	if ( is_array( $taxonomy_names ) && count( $taxonomy_names ) > 0  && in_array( 'gallery_cat', $taxonomy_names ) ) {
	    $terms = get_terms( 'gallery_cat', array(
	        'hide_empty'        => false,
	        'parent' => 0,
	        ) );
	}
}
?>
	<div class="tabs_sort post_area var2 type2 mad_bottom3">
		<?php if (is_array( $terms ) && count( $terms ) > 0 ) : ?>
		  <div id="options">
		    <div id="filters" class="button-group js-radio-button-group">
		      <button class="is-checked" data-filter="*"><?php esc_html_e( 'All', 'helpmate' );?></button>
		      <?php foreach ( $terms as $term ) : ?>	
		      <button data-filter=".<?php echo esc_attr($term->slug); ?>"><?php echo esc_html($term->name); ?></button>
		      <?php endforeach;?>  
		    </div>
		  </div>
		<?php endif;?>  

	  <div class="isotope three_collumn clearfix gallery-entries-wrap" data-isotope-options='{"itemSelector" : ".item","layoutMode" : "masonry","transitionDuration":"0.7s","masonry" : {"columnWidth":".item"}}'>
	    <?php while (have_posts()) : the_post(); ?>
	    <?php 
	    	$post_term_arr = get_the_terms( get_the_ID(), 'gallery_cat' );
            $post_term_filters = '';
            $post_term_names = '';

            if (is_array($post_term_arr) || is_object($post_term_arr)){
	            foreach ( $post_term_arr as $post_term ) {

	                $post_term_filters .= $post_term->slug . ' ';
	                $post_term_names .= $post_term->name . ', ';
	                if($post_term->parent!=0){
	                	$parent_term = get_term( $post_term->parent,'gallery_cat' );
	                	$post_term_filters .= $parent_term->slug . ' ';
						
	                }
	            }
	        }

            $post_term_filters = trim( $post_term_filters );
            $post_term_names = substr( $post_term_names, 0, -2 );
            $author = get_the_author();
	    ?>
	    <div class="item <?php echo esc_attr($post_term_filters);?>">
	      <div class="item_holder">
	      	<?php 
            if( class_exists('Dynamic_Featured_Image') ):
            global $dynamic_featured_image;
            global $post;
            $featured_images = $dynamic_featured_image->get_featured_images( $post->ID );

                if ( $featured_images ): ?>
                        <?php foreach( $featured_images as $images ): ?>
                            <figure class="item_img">
                                <img src="<?php echo esc_url($images['full']) ?>" alt="gallery">
                            </figure>
                        <?php endforeach; ?>
                <?php
                endif;
            else :
                if ( has_post_thumbnail() ) : ?>
	        	<figure class="item_img"><?php the_post_thumbnail();?></figure>
	    		<?php endif;
            endif;
            ?>
	        <div class="caption_block">
	          <div class="item_desc">
	            <div class="item_desc_inner post_news">
	              <h4><?php the_title();?></h4>
	              <div class="post_social">
	                <div class="post_social_item clearfix">
	                  <div class="post_social_autor">
	                    <span><?php esc_html_e( 'By:', 'helpmate' );?> </span><?php echo esc_html($author);?>
	                  </div>
	                  <div class="post_social_event">
                    	<?php  if(function_exists('helpmate_getPostLikeLink')) {
                                    echo helpmate_getPostLikeLink( get_the_ID() );
                        } ?>
	                  </div>
	                </div>
	                <div class="post_social_item clearfix">
	                  <div class="post_social_autor">
	                     <span><?php esc_html_e( 'In:', 'helpmate' );?> </span><?php echo get_the_term_list($post->ID,'gallery_cat', '', ', ' ); ?>
	                  </div>
	                </div>
	              </div>
	              <div class="social_icon_list">
	                <ul>
	                  <li>
	                  	<?php $image_url = wp_get_attachment_url( get_post_thumbnail_id() );?>
	                    <div class="curtain">
	                      <a href="<?php echo esc_url($image_url);?>" class="soc_icon gallery fancybox" rel="category"></a>
	                    </div>

	                  </li>
	                  <li>

	                    <a href="<?php the_permalink();?>" class="soc_icon icon-link"></a>

	                  </li>
	                </ul>
	              </div>
	            </div>
	          </div>
	        </div>
	        
	      </div>

	    </div>  
	    <?php endwhile;?>      
	  </div>
		<?php if(isset($helpmate_settings['gallery-archive-pagination-type']) && $helpmate_settings['gallery-archive-pagination-type'] =='loadmore'):?>
			<?php if ($wp_query->max_num_pages > 1) : ?>
		    <div class="align_center">
		      <a class="portfolio_ajax_load_more button type1 load-more" data-paged="<?php echo esc_attr($current_page) ?>" data-totalpage="<?php echo esc_attr($wp_query->max_num_pages) ?>"><span><span><?php esc_html_e( 'Load More', 'helpmate' );?></span><span><?php esc_html_e( 'Load More', 'helpmate' );?></span></span></a>
		    </div> 
		     <?php endif;?>
		<?php else:?>
			<div class="pagination_list clearfix col-md-12">
				<?php helpmate_pagination(); ?>
				<ul class="f_right">
				  <li class="pagination_button_prev"><?php previous_posts_link( esc_html__('Previous','helpmate') ); ?></li>
				  <li class="pagination_button_next"><?php next_posts_link(esc_html__('Next','helpmate')); ?></li>
				</ul>
			</div> 
		<?php endif;?>	  
	  
	</div>	
