<?php
$theme = wp_get_theme();
define('helpmate_version', $theme->get('Version'));
define('helpmate_lib', get_template_directory() . '/inc');
define('helpmate_admin', helpmate_lib . '/admin');
define('helpmate_plugins', helpmate_lib . '/plugins');
define('helpmate_functions', helpmate_lib . '/functions');
define('helpmate_metaboxes', helpmate_functions . '/metaboxes');
define('helpmate_css', get_template_directory_uri() . '/css');
define('helpmate_js', get_template_directory_uri() . '/js');

require_once(helpmate_admin . '/functions.php');
require_once(helpmate_functions . '/functions.php');
require_once(helpmate_metaboxes . '/functions.php');
require_once(helpmate_plugins . '/functions.php');
// Set up the content width value based on the theme's design and stylesheet.
if (!isset($content_width)) {
    $content_width = 1140;
}

function helpmate_remove_redux_framework_notification() {
    if ( class_exists('ReduxFrameworkPlugin') ) {
        remove_filter( 'plugin_row_meta', array( ReduxFrameworkPlugin::get_instance(), 'plugin_metalinks'), null, 2 );
        remove_action('admin_notices', array( ReduxFrameworkPlugin::get_instance(), 'admin_notices' ) );    
    }
}
add_action('init', 'helpmate_remove_redux_framework_notification');
if (!function_exists('helpmate_setup')) {

    function helpmate_setup() {
        load_theme_textdomain('helpmate', get_template_directory() . '/languages');
        add_editor_style( array( 'style.css', 'style_rtl.css' ) );
        add_theme_support( 'title-tag' );
        add_theme_support( 'post-formats', array(
            'image', 'video', 'audio', 'quote', 'link', 'gallery',
        ) );
        add_theme_support('automatic-feed-links');
        // register menus
        register_nav_menus( array(
            'primary' => (esc_html__('Primary Menu', 'helpmate')),
            'header_top_menu' => esc_html__('Header Top Menu', 'helpmate'),
            'list' => esc_html__('List Menu', 'helpmate'),
            'footer_top_menu' => esc_html__('Footer Top Menu', 'helpmate'),
        ));
        add_theme_support( 'custom-header' );
        add_theme_support( 'custom-background' );
        add_theme_support( 'post-thumbnails' ); 
        add_image_size('helpmate_portfolio_grid', 360, 269, true);
        add_image_size('helpmate_portfolio_1_column', 750, 426, true);
        add_image_size('helpmate_portfolio_2_column', 555, 376, true);
        add_image_size('helpmate_portfolio_widget', 262, 244, true);  
        add_image_size('helpmate_blog_slider', 263, 256, true);  
        add_image_size('helpmate_gallery', 470, 358, true);   
        add_image_size('helpmate_blog_3_column', 628, 329, true); 
        add_image_size('helpmate_blog', 1140, 568, true); 
        add_image_size('helpmate_blog_slider', 263, 256, true); 
        add_image_size('helpmate_gallery_slider', 640, 343, true);

    }

}
add_action('after_setup_theme', 'helpmate_setup');

add_action('admin_enqueue_scripts', 'helpmate_admin_scripts_css');
function helpmate_admin_scripts_css() {
    wp_enqueue_style('helpmate_admin_css', helpmate_css . '/admin.css', false);
}
add_action('admin_enqueue_scripts', 'helpmate_admin_scripts_js');
function helpmate_admin_scripts_js() {
    wp_register_script('helpmate_admin_js', helpmate_js . '/un-minify/admin.js', array('common', 'jquery', 'media-upload', 'thickbox'), helpmate_version, true);
    wp_enqueue_script('helpmate_admin_js');
}
function helpmate_scripts_styles() {
    //Load font icon css
    global $helpmate_settings;
    $helpmate_cus_font = helpmate_get_meta_value('cus_font');
    $font_size = (helpmate_get_meta_value('font_size') != '') ? helpmate_get_meta_value('font_size').'px' : $helpmate_settings['general-font']['font-size'];
    $line_height = (helpmate_get_meta_value('line_height') != '') ? helpmate_get_meta_value('line_height').'px' : $helpmate_settings['general-font']['line-height'];
    $helpmate_custom_css ='';
    //Custom font
    if (isset($helpmate_cus_font) && $helpmate_cus_font != 'default' ) :
        ?>
        <?php 
            $helpmate_custom_css .= "
            body{
                font: {$font_size}/{$line_height} '{$helpmate_cus_font}',sans-serif !important;
            }";
        ?>        
    <?php endif;  
    //Background for header type 1
    if(!is_front_page() && isset($helpmate_settings['breadcrumbs-bg']) && $helpmate_settings['breadcrumbs-bg']['background-image'] !=''):
        $helpmate_breadcrumbs_bg = $helpmate_settings['breadcrumbs-bg']['background-image'];
        $helpmate_breadcrumbs_image = is_ssl() ? str_replace( 'http://', 'https://', $helpmate_breadcrumbs_bg ) : $helpmate_breadcrumbs_bg;
        $helpmate_custom_css .= "
            .header-v1 .menu_holder{
                background-image: url({$helpmate_breadcrumbs_image});
                background-repeat: {$helpmate_settings['breadcrumbs-bg']['background-repeat']};
                background-position: {$helpmate_settings['breadcrumbs-bg']['background-position']};
                background-size: {$helpmate_settings['breadcrumbs-bg']['background-size']};
                background-attachment: {$helpmate_settings['breadcrumbs-bg']['background-attachment']};
            }
        ";
    endif; 
    //Background for header type 2
    if(!is_front_page() && isset($helpmate_settings['breadcrumbs-bg2']) && $helpmate_settings['breadcrumbs-bg2']['background-image'] !=''):
        $helpmate_breadcrumbs_bg2 = $helpmate_settings['breadcrumbs-bg2']['background-image'];
        $helpmate_breadcrumbs_image2 = is_ssl() ? str_replace( 'http://', 'https://', $helpmate_breadcrumbs_bg2 ) : $helpmate_breadcrumbs_bg2;
        $helpmate_custom_css .= "
            .header-v2.show_breadcumb .menu_holder{
                background-image: url({$helpmate_breadcrumbs_image2});
                background-repeat: {$helpmate_settings['breadcrumbs-bg2']['background-repeat']};
                background-position: {$helpmate_settings['breadcrumbs-bg2']['background-position']};
                background-size: {$helpmate_settings['breadcrumbs-bg2']['background-size']};
                background-attachment: {$helpmate_settings['breadcrumbs-bg2']['background-attachment']};
            }
        ";
    endif; 
    //Update theme option style
    $helpmate_opt_css ='';
    if (isset($helpmate_settings['enable_header_style']) && $helpmate_settings['enable_header_style']){
    /** 
    1. Header styling
    */
        $header6_top_bg = isset($helpmate_settings['header6_top_bg'])? $helpmate_settings['header6_top_bg']: '#fff';
        $header6_top_text_color = $helpmate_settings['header6_top_text_color'];
        $header6_menu_bg = isset($helpmate_settings['header6_menu_bg'])?$helpmate_settings['header6_menu_bg']: '#5080bf';
        $header6_menu_text_color = $helpmate_settings['header6_menu_text_color'];
        $header6_top_social_color = $helpmate_settings['header6_top_social_color'];
        $header6_info_text_color = isset($header6_info_text_color['header6_info_text_color'])?$header6_info_text_color['header6_info_text_color']: '#555';
        $header1_menu_text_color = $helpmate_settings['header1_menu_text_color'];
        $header1_top_text_color = $helpmate_settings['header1_top_text_color'];
        $header1_top_bg = $helpmate_settings['header1_top_bg'];
        $header2_info_text_color = isset($helpmate_settings['header2_info_text_color'])?$helpmate_settings['header2_info_text_color']: '#a1a1a1';
        $header3_top_bg = isset($helpmate_settings['header3_top_bg'])? $helpmate_settings['header3_top_bg']: '#fafafa';
        $header3_top_border = isset($helpmate_settings['header3_top_border'])? $helpmate_settings['header3_top_border']: '#ececec';  
        $header3_menu_text_color = isset($helpmate_settings['header3_menu_text_color'])? $helpmate_settings['header3_menu_text_color']: '#224687'; 
        $header3_menu_icon_color = isset($helpmate_settings['header3_menu_icon_color'])? $helpmate_settings['header3_menu_icon_color']: '#e7e7e7';      
        $header4_menu_text_color = isset($helpmate_settings['header4_menu_text_color'])? $helpmate_settings['header4_menu_text_color']: '#262729';    
        $header4_menu_bg = isset($helpmate_settings['header4_menu_bg'])? $helpmate_settings['header4_menu_bg']: 'rgba(255, 255, 255, 0.8)'; 
        $header5_menu_text_color = isset($helpmate_settings['header5_menu_text_color'])? $helpmate_settings['header5_menu_text_color']: '#3b3b3b';        

        $helpmate_opt_css .= '.header-v6 .header_top{background:'.$header6_top_bg.'; }.header-v6 .header_top .header_top_list ul li a{color:'.$header6_top_text_color.'}.header-v6 .header_top .header_top_list ul li:not(:last-child) a:after{background: '.$header6_top_text_color.'}.header-v6 .menu_holder .menu_wrap{background'.$header6_menu_bg.'}.header-v6 .main_navigation > ul > li > a, .header-v6 .menu_holder .search_button{color:'.$header6_menu_text_color.'}.header-v6 .bottom_header .info_block .info_block_item .info_text{color:'.$header6_info_text_color.'}.header-v6 .social_icon_list.var3 ul li a.soc_icon,.header-v3 .header_top .header_contact_list > ul > li .social_icon_list ul li a{color:'.$header6_top_social_color.'}.header-v6 .main_navigation > ul > li > a:before{background:'.$header6_menu_text_color.'}';

        $helpmate_opt_css .= '.main_navigation > ul > li > a,.main_navigation > ul > li > a:before,.shopping_button .shop_button, .search_button,.myaccount_button_wrap a{color: '.$header1_menu_text_color.'}.main_navigation > ul > li > a:before,.header-v2 .main_navigation > ul > li > a:before{background:'.$header1_menu_text_color.'}.header-v1 .header_top{background:'.$header1_top_bg.';color:'.$header1_top_text_color.'}.header-v2 .header_top .header_contact_list li p{color:'.$header2_info_text_color.'}.header-v3 .header_top{background:'.$header3_top_bg.';border-color:'.$header3_top_border.'}.header-v3 .header_top .header_contact_list > ul > li{border-right-color:'.$header3_top_border.'}.header-v3 .header_top .header_contact_list > ul > li:first-child{border-left-color:'.$header3_top_border.'}.header-v3 .main_navigation > ul > li > a{color:'.$header3_menu_text_color.'}.header-v3 .main_navigation > ul > li > a:before{background:'.$header3_menu_text_color.'}.header-v3 .search_button, .header-v3 .shopping_button .shop_button,.header-v3 .myaccount_button_wrap a{color:'.$header3_menu_icon_color.'}.header-v4 .main_navigation > ul > li > a, .header-v4 .menu_holder .search_button{color:'.$header4_menu_text_color.'}.header-v4 .main_navigation > ul > li > a:before{background:'.$header4_menu_text_color.'}.header-v4 .menu_holder .menu_wrap .menu_bg{background:'.$header4_menu_bg.'}.header-v5 .main_navigation > ul > li > a, .header-v5 .menu_holder .bottom_header .search-holder .search_button,.header-v5 .myaccount_button_wrap a, .header-v5 .menu_holder .bottom_header .search-holder .shop_button{color:'.$header5_menu_text_color.'}.header-v5 .main_navigation > ul > li > a:before{background:'.$header5_menu_text_color.'}';
    }
    //End theme option style    
    wp_enqueue_style('helpmate-font', get_template_directory_uri() . '/css/fontello/fontello.css?ver=' . helpmate_version);
    wp_enqueue_style('prettyphoto', get_template_directory_uri() . '/css/prettyPhoto.css?ver=' . helpmate_version);
    wp_enqueue_style('fancybox', get_template_directory_uri() . '/css/fancybox/jquery.fancybox.css?ver=' . helpmate_version);
    wp_enqueue_style('audioplayer', get_template_directory_uri() . '/css/audioplayer.css?ver=' . helpmate_version);
    if (is_rtl()) {
        //Load plugins RTL css
        wp_enqueue_style('helpmate-plugins-rtl', get_template_directory_uri() . '/css/plugins_rtl.css?ver=' . helpmate_version);
        //Load theme RTL css
        wp_enqueue_style('helpmate-theme-rtl', get_template_directory_uri() . '/css/theme_rtl.css?ver=' . helpmate_version);
        wp_add_inline_style( 'helpmate-theme', $helpmate_custom_css );
    }
    else{
        //Load plugins css
        wp_enqueue_style('helpmate-plugins', get_template_directory_uri() . '/css/plugins.css?ver=' . helpmate_version);
        //Load theme css
        wp_enqueue_style('helpmate-theme', get_template_directory_uri() . '/css/theme.css?ver=' . helpmate_version);
        wp_add_inline_style( 'helpmate-theme', $helpmate_custom_css );
    }
    wp_enqueue_style('helpmate-skin', helpmate_css . '/config/skin.css?ver=' . helpmate_version);
    wp_add_inline_style( 'helpmate-skin', $helpmate_opt_css );
    // Loads our main stylesheet.
    wp_enqueue_style('helpmate-style', get_stylesheet_uri());
    // Load Google Fonts
    $gfont = array('Hind','Roboto','Palanquin','Oxygen','Playfair+Display','Martel','Shadows+Into+Light');
    if (isset($helpmate_settings['general-font']['google']) && $helpmate_settings['general-font']['google']) {
        $font = urlencode($helpmate_settings['general-font']['font-family']);
        if (!in_array($font, $gfont))
            $gfont[] = $font;
    }
    $font_family = '';
    foreach ($gfont as $font)
        $font_family .= $font . ':300,300italic,400,400italic,500,600,600italic,700,700italic,800,900,800italic%7C';

    if ($font_family) {
        wp_register_style( 'helpmate-google-fonts', "//fonts.googleapis.com/css?family=" . $font_family . "&amp;subset=latin,greek-ext,cyrillic,latin-ext,greek,cyrillic-ext,vietnamese" );
        wp_enqueue_style( 'helpmate-google-fonts' );
    }
}
add_action('wp_enqueue_scripts', 'helpmate_scripts_styles');

//Disable all woocommerce styles
add_filter('woocommerce_enqueue_styles', '__return_false');

function helpmate_scripts_js() {
    global $helpmate_settings, $wp_query;
    if ( is_singular() && get_option( 'thread_comments' ) ) {
        wp_enqueue_script( 'comment-reply' );
    }
    $header_sticky_mobile = isset($helpmate_settings['header-sticky-mobile'])? $helpmate_settings['header-sticky-mobile'] : '';
    // Loads our main js.
    wp_enqueue_script('bootstrap', get_template_directory_uri() . '/js/bootstrap.min.js', array('jquery'), helpmate_version, true);
    
    wp_enqueue_script('tabs', get_template_directory_uri() . '/js/jquery-ui.min.js', array(), helpmate_version, true);    
    wp_enqueue_script('imagesloaded', get_template_directory_uri() . '/js/imagesloaded.pkgd.min.js', array(), helpmate_version, true);
    wp_enqueue_script('isotope', get_template_directory_uri() . '/js/isotope.pkgd.min.js', array(), helpmate_version, true);
    wp_enqueue_script('owlcarousel', get_template_directory_uri() . '/js/owl.carousel.min.js', array(), helpmate_version, true);
    wp_enqueue_script('fancybox', get_template_directory_uri() . '/js/jquery.fancybox.pack.js', array(), helpmate_version, true);   
    wp_enqueue_script('jquery-cookie', get_template_directory_uri() . '/js/jquery.cookie.js', array(), helpmate_version, true);     
    wp_enqueue_script('time-circles', get_template_directory_uri() . '/js/un-minify/jquery.countdown.min.js', array(), helpmate_version, true);
    wp_enqueue_script('scrollreveal', get_template_directory_uri() . '/js/un-minify/scrollReveal.js', array(), helpmate_version, true);
    wp_enqueue_script('elevate-zoom', get_template_directory_uri() . '/js/un-minify/jquery.elevatezoom.js', array('jquery'), helpmate_version, true);
    wp_enqueue_script('validate', get_template_directory_uri() . '/js/jquery.validate.min.js', array('jquery'), helpmate_version);
    wp_enqueue_script('audioplayer', get_template_directory_uri() . '/js/un-minify/audioplayer.js', array('jquery'), helpmate_version);
    wp_enqueue_script('loader', get_template_directory_uri() . '/js/un-minify/jquery.queryloader2.min.js', array('jquery'), helpmate_version);
    wp_enqueue_script('helpmate-plugins', get_template_directory_uri() . '/js/un-minify/plugins.js', array('jquery'), helpmate_version);
    wp_enqueue_script('helpmate-script', get_template_directory_uri() . '/js/un-minify/functions.js', array(), helpmate_version, true);
    if (isset($helpmate_settings['js-code'])){
        wp_add_inline_script( 'helpmate-script', $helpmate_settings['js-code'] ); 
    }   
    wp_localize_script('helpmate-script', 'helpmate_params', array(
        'ajax_url' => esc_js(admin_url( 'admin-ajax.php' )),
        'ajax_loader_url' => esc_js(str_replace(array('http:', 'https'), array('', ''), helpmate_css . '/images/ajax-loader.gif')),
        'ajax_cart_added_msg' => esc_html__('A product has been added to cart.', 'helpmate'),
        'header_sticky' => $helpmate_settings['header-sticky'],
        'header_sticky_mobile' => $header_sticky_mobile
    ));
}
add_action('wp_enqueue_scripts', 'helpmate_scripts_js');
function helpmate_override_mce_options($initArray) {
    $opts = '*[*]';
    $initArray['valid_elements'] = $opts;
    $initArray['extended_valid_elements'] = $opts;
    return $initArray;
} 
add_filter('tiny_mce_before_init', 'helpmate_override_mce_options'); 

function helpmate_get_current_url($echo = true) {
    global $wp;
    if($echo) {
        echo home_url(add_query_arg(array(),$wp->request));
    } else {
        return home_url(add_query_arg(array(),$wp->request));
    }
}

if (class_exists( 'YITH_WOOCOMPARE' ) ){
    function helpmate_compare_page_title($sep = '', $display = true, $title = '') {
        if($title != '') {
            return esc_attr($title);
        }
    }
    add_filter( 'wp_title', 'helpmate_compare_page_title', 100, 3 );
}
//Defer parsing of JavaScript
if (!(is_admin() )) {
    function helpmate_defer_parsing_of_js ( $url ) {
        if ( FALSE === strpos( $url, '.js' ) ) return $url;
        if ( strpos( $url, 'jquery.js' ) ) return $url;
        // return "$url' defer ";
        return "$url' defer onload='";
    }
    add_filter( 'clean_url', 'helpmate_defer_parsing_of_js', 11, 1 );
}