<?php $helpmate_settings = helpmate_check_theme_options(); ?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11" />
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>" />
    <?php if ( ! function_exists( 'has_site_icon' ) || ! has_site_icon() ) :?>
        <?php if (!empty($helpmate_settings['favicon'])): ?>
            <link rel="shortcut icon" href="<?php echo esc_url(str_replace(array('http:', 'https:'), '', $helpmate_settings['favicon']['url'])); ?>" type="image/x-icon" />
        <?php endif; ?>
    <?php endif;?>    
    <?php wp_head(); ?>
</head>
<?php
$helpmate_sidebar_pos = helpmate_get_sidebar_position();
$helpmate_sidebar = helpmate_get_sidebar();
$helpmate_layout = helpmate_get_layout();
$helpmate_header_type = helpmate_get_header_type();
$wrapper ='';
$header_absolute = '';
if(is_404()){
    $helpmate_layout ='wide';
 }

$helpmate_breadcrumbs = helpmate_get_meta_value('breadcrumbs', true);
$page_title = helpmate_get_meta_value('page_title', true);
if (( is_front_page() && is_home()) || is_front_page() ) {
    $helpmate_breadcrumbs = false;
    $page_title = false;
}
$en_breadcumb = ($helpmate_breadcrumbs || $page_title) ? 'show_breadcumb' : '';
?>
<body <?php body_class(); ?>>
	<div class="loader"></div>
	<div id="wrapper" class="wrapper_container site">
        <a id="advanced-menu-hide" href="#"></a>
        <nav class="mobile-advanced" id="mobile-advanced">
            <?php           
                $before_items_wrap = '';      
                $after_item_wrap = '';
                if (has_nav_menu('primary')) {
                    wp_nav_menu(array(
                        'theme_location' => 'primary',
                        'menu_class' => 'clearfix',
                        'items_wrap' => $before_items_wrap . '<ul id="%1$s" class="%2$s">%3$s</ul>' . $after_item_wrap,
                        'walker' => new helpmate_Primary_Walker_Nav_Menu()
                            )
                    );
            }?>
        </nav>
        <?php if (helpmate_get_meta_value('show_header', true)) : ?>
            <header id="masthead" class="header header-v<?php echo esc_attr($helpmate_header_type); ?> <?php echo esc_attr($en_breadcumb);?>">
                <?php get_template_part('headers/header_' . $helpmate_header_type); ?>
            </header><!-- #masthead -->
        <?php endif; ?>
        <?php 
        $single_layout = get_post_meta(get_the_ID(), 'single_layout', true); 
        $image_banner = get_post_meta(get_the_ID(), 'image_banner', true); 
        if($single_layout == 'full_banner' && is_singular('gallery')){
        echo '<figure class="mad_bottom full-banner"><img src="'.esc_url($image_banner).'" alt="gallery-banner"></figure>';
        }
        ?>
        <div id="main" class="wrapper <?php if($helpmate_layout == 'wide'){echo 'wide';}?> <?php if($single_layout == 'full_banner' && is_singular('gallery')){echo 'gallery_full_banner';}?>">
        <?php if($helpmate_layout == 'fullwidth') :?>
            <div class="container">
                <div class="row">   
        
                <?php endif;?>
        