<?php
$helpmate_settings = helpmate_check_theme_options();
?>
<?php if($helpmate_settings['header-top']) :?>
<div class="header_top">
    <div class="container">
        <div class="row">
            <div class="col-xs-7">
                <?php if (!empty($helpmate_settings['header-contact-phonenumber'])): ?>
                    <div class="call_us">
                        <div class="number">
                          <?php echo esc_html__('Call us now:','helpmate');?> <br>  
                          <b> <a href="callto:<?php echo esc_url($helpmate_settings['header-contact-phonenumber']) ?>"><?php echo esc_html($helpmate_settings['header-contact-phonenumber']) ?></a></b>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
            <div class="col-xs-5">
            <?php if (1 == $helpmate_settings['header-social']): ?>
                <div class="align_right">
                    <div class="social_icon_list var2">
                        <ul>
                            <?php if (!empty($helpmate_settings['social-facebook'])): ?>
                                <li><a href="<?php echo esc_url($helpmate_settings['social-facebook']) ?>" class="soc_icon icon_facebook"></a></li>
                            <?php endif; ?>
                            <?php if (!empty($helpmate_settings['social-twitter'])): ?>
                                <li><a href="<?php echo esc_url($helpmate_settings['social-twitter']) ?>" class="soc_icon icon_twitter"></a></li>
                            <?php endif; ?>
                            <?php if (!empty($helpmate_settings['social-mail'])): ?>
                                <li><a href="<?php echo esc_url($helpmate_settings['social-mail']) ?>" class="soc_icon icon_mail"></a></li>
                            <?php endif; ?>
                            <?php if (!empty($helpmate_settings['social-instagram'])): ?>
                                <li><a href="<?php echo esc_url($helpmate_settings['social-instagram']) ?>" class="soc_icon icon_instagram"></a></li>
                            <?php endif; ?> 
                        </ul>
                    </div>
                </div>
            <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php endif;?>
<?php
    $breadcrumbs_bg_class = "";
    $breadcrumb_bg = helpmate_get_meta_value('breadcrumb_bg', true);
    if ($helpmate_settings['breadcrumbs-bg'] && $breadcrumb_bg):
        $breadcrumbs_bg_class = 'menu_holder_with_bg';
    endif;
?>
<div class="menu_holder">        
    <div class="menu_wrap">
        <div class="container">
            <div class="menu_bg">
                <?php if (is_front_page()) : ?>
                <h1 class="logo">
                <?php endif ; ?>            
                <a href="<?php echo esc_url(home_url('/')); ?>" rel="home" class="logo">
                    <?php
                    if ($helpmate_settings['logo4'] && $helpmate_settings['logo4']['url']){
                        echo '<img class="" src="' . esc_url(str_replace(array('http:', 'https:'), '', $helpmate_settings['logo4']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '" />';
                    }
                    else if ($helpmate_settings['logo'] && $helpmate_settings['logo']['url']){
                        echo '<img class="" src="' . esc_url(str_replace(array('http:', 'https:'), '', $helpmate_settings['logo']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '" />';
                    }
                    else{
                        bloginfo('name');
                    }
                    ?>
                </a>
                <?php if (is_front_page()) : ?>
                </h1>
                <?php endif ; ?>                 
                <div class="nav_item">
                    <button id="responsive-nav-button" class="responsive-nav-button"></button>
                    <?php           
                    $before_items_wrap = '<nav class="main_navigation">';      
                    $after_item_wrap = '</nav>';
                    if (has_nav_menu('primary')) {
                        wp_nav_menu(array(
                            'theme_location' => 'primary',
                            'menu_class' => 'clearfix',
                            'items_wrap' => $before_items_wrap . '<ul id="%1$s" class="%2$s">%3$s</ul>' . $after_item_wrap,
                            'walker' => new helpmate_Primary_Walker_Nav_Menu()
                                )
                        );
                    }?>
                </div>
                <?php 
                $wishlist = false;
                if (class_exists('YITH_WCWL')) {
                    $wishlist = true;
                }
                $myaccount_page_id = get_option('woocommerce_myaccount_page_id');
                $logout_url = wp_logout_url(get_permalink($myaccount_page_id));
                if (get_option('woocommerce_force_ssl_checkout') == 'yes') {
                    $logout_url = str_replace('http:', 'https:', $logout_url);
                }
                if ($helpmate_settings['header-search'] || $helpmate_settings['header-myaccount4']) :?>
                <div class="search-holder">
                    <div class="search_box">            
                            <?php $helpmate_search_template = helpmate_get_search_form(); ?> 
                                <div class="serch_button_wrap">
                                    <?php echo wp_kses($helpmate_search_template,array(
                                        'form'=>array(
                                            'role' => array(),
                                            'method'=> array(),
                                            'class'=> array(),
                                            'action'=>array(),
                                            'id'=>array(),
                                            ),
                                        'input' => array(
                                            'type' => array(),
                                            'name'=> array(),
                                            'class'=> array(),
                                            'title'=>array(),
                                            'id'=>array(), 
                                            'value'=> array(), 
                                            'placeholder'=>array(),                          
                                            ),
                                        'button' => array(
                                            'type' => array(),
                                            'name'=> array(),
                                            'class'=> array(),
                                            'title'=>array(),
                                            'id'=>array(),                            
                                            ),                        
                                        'div'=>array(
                                            'class'=> array(),
                                            ),
                                        'h5'=>array(
                                            'class'=> array(),
                                            ),
                                        'a'=>array(
                                            'class'=> array(),
                                            'href'=>array(),
                                            ),
                                        )); ?>
                                </div>  
                            <?php if ($helpmate_settings['header-myaccount4']) :?>
                                <div class="myaccount_button_wrap">
                                    <a href="#" aria-expanded="false" aria-haspopup="true" data-toggle="dropdown">
                                        <i class="fa fa-user"></i>
                                    </a>
                                    <div class="dib header-profile dropdown-menu">
                                        <ul>
                                            <li><a href="<?php echo esc_url(get_permalink($myaccount_page_id)); ?>"><?php echo esc_html__('My Account', 'helpmate') ?></a></li>
                                            <?php if ($wishlist): ?>
                                                <li><a class="update-wishlist" href="<?php echo YITH_WCWL()->get_wishlist_url(); ?>"><?php echo esc_html__('Wishlist', 'helpmate') ?> <span>(<?php echo yith_wcwl_count_products(); ?>)</span></a></li>
                                            <?php endif; ?>
                                            <?php if (!is_user_logged_in()): ?>
                                                <li><a href="<?php echo esc_url(get_permalink($myaccount_page_id)); ?>"><?php echo esc_html__('Login / Register', 'helpmate') ?></a></li>
                                            <?php else: ?>
                                                <li><a href="<?php echo esc_url($logout_url) ?>"><?php echo esc_html__('Logout', 'helpmate') ?></a></li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php endif;?>            
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <?php get_template_part('breadcrumb'); ?>
</div>