<?php
$helpmate_settings = helpmate_check_theme_options();
?>
<?php if($helpmate_settings['header-top']) :?>
<div class="header_top">
    <div class="container">
        <div class="row">
            <div class="col-md-6 col-sm-12">
              <?php if (isset($helpmate_settings['header-top-link']) && $helpmate_settings['header-top-link']) :?>       
                  <div class="header_top_list">
                   <?php
                    if (has_nav_menu('header_top_menu')) {
                        wp_nav_menu(array(
                            'theme_location' => 'header_top_menu',
                            'walker' => new Helpmate_Primary_Walker_Nav_Menu()
                                )
                        );
                    }
                    ?>
                  </div>
              <?php endif; ?>
            </div>

            <div class="col-md-6 col-sm-12">
            
            <?php if (1 == $helpmate_settings['header-social']): ?>
              <div class="social_icon_list var3">
                <ul>
                    <?php if (!empty($helpmate_settings['social-facebook'])): ?>
                        <li><a href="<?php echo esc_url($helpmate_settings['social-facebook']) ?>" class="soc_icon icon_facebook"></a></li>
                    <?php endif; ?>
                    <?php if (!empty($helpmate_settings['social-twitter'])): ?>
                        <li><a href="<?php echo esc_url($helpmate_settings['social-twitter']) ?>" class="soc_icon icon_twitter"></a></li>
                    <?php endif; ?>
                    <?php if (!empty($helpmate_settings['social-mail'])): ?>
                        <li><a href="<?php echo esc_url($helpmate_settings['social-mail']) ?>" class="soc_icon icon_mail"></a></li>
                    <?php endif; ?>
                    <?php if (!empty($helpmate_settings['social-instagram'])): ?>
                        <li><a href="<?php echo esc_url($helpmate_settings['social-instagram']) ?>" class="soc_icon icon_instagram"></a></li>
                    <?php endif; ?> 
                </ul>
              </div>
             <?php endif; ?> 
            </div>

        </div>
    </div>
</div>
<?php endif;?>
<div class="bottom_header">
    <div class="container">
        <div class="row">
            <div class="col-md-4">
                <?php if (is_front_page()) : ?>
                <h1 class="header-logo">
                <?php endif ; ?>            
                <a href="<?php echo esc_url(home_url('/')); ?>" rel="home" class="logo">
                    <?php
                    if ($helpmate_settings['logo6'] && $helpmate_settings['logo6']['url']){
                        echo '<img class="" src="' . esc_url(str_replace(array('http:', 'https:'), '', $helpmate_settings['logo6']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '" />';
                    }
                    else if ($helpmate_settings['logo'] && $helpmate_settings['logo']['url']){
                        echo '<img class="" src="' . esc_url(str_replace(array('http:', 'https:'), '', $helpmate_settings['logo']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '" />';
                    }
                    else{
                        bloginfo('name');
                    }
                    ?>
                </a> 
                <?php if (is_front_page()) : ?>
                </h1>
                <?php endif ; ?>                           
            </div>

            <div class="col-md-8">
                <div class="info_block">
                    <?php if (!empty($helpmate_settings['header-contact-phonenumber6'])): ?>
                        <div class="info_block_item">
                          <div class="info_icon icon_phone"></div>
                          <div class="info_text">
                            <?php echo esc_html__('Free Line For You ','helpmate');?><br>
                            <b> <a href="callto:<?php echo esc_url($helpmate_settings['header-contact-phonenumber6']) ?>"><?php echo esc_html($helpmate_settings['header-contact-phonenumber6']) ?></a></b>
                          </div>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($helpmate_settings['header-contact-email6'])): ?>
                    <div class="info_block_item">
                        <div class="info_icon icon_mail"></div>
                        <div class="info_text">
                            <?php echo esc_html__('Email Us ','helpmate');?><br>
                            <b><a href="mailto:<?php echo esc_url($helpmate_settings['header-contact-email6']) ?>"><?php echo esc_html($helpmate_settings['header-contact-email6']) ?></a></b>
                        </div>
                    </div>
                    <?php endif; ?>
                    <?php if (!empty($helpmate_settings['header-contact-time6'])): ?>
                    <div class="info_block_item">
                      <div class="info_icon icon_back_time"></div>
                      <div class="info_text">
                        <?php echo esc_html__('Working Hours ','helpmate');?><br>
                        <b><?php echo esc_html($helpmate_settings['header-contact-time6']) ?></b>
                      </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
          </div>

        </div>

      </div>
<?php
    $breadcrumbs_bg_class = "";
    $breadcrumb_bg = helpmate_get_meta_value('breadcrumb_bg', true);
    if ($helpmate_settings['breadcrumbs-bg'] && $breadcrumb_bg):
        $breadcrumbs_bg_class = 'menu_holder_with_bg';
    endif;
    $hide_quote='';
    if (isset($helpmate_settings['header-quote']) && !$helpmate_settings['header-quote']){
        $hide_quote = 'hide_quote_link';
    }
?>

<div class="menu_holder <?php echo esc_attr($hide_quote);?>">        
    <div class="menu_wrap">
        <div class="container">
            <div class="clearfix relative">
                <div class="nav_item">
                    <button id="responsive-nav-button" class="responsive-nav-button"></button>
                    <?php           
                    $before_items_wrap = '<nav class="main_navigation">';      
                    $after_item_wrap = '</nav>';
                    if (has_nav_menu('primary')) {
                        wp_nav_menu(array(
                            'theme_location' => 'primary',
                            'menu_class' => 'clearfix',
                            'items_wrap' => $before_items_wrap . '<ul id="%1$s" class="%2$s">%3$s</ul>' . $after_item_wrap,
                            'walker' => new helpmate_Primary_Walker_Nav_Menu()
                                )
                        );
                    }?>
                </div>
                     <?php if(isset($helpmate_settings['header-quote-link']) && $helpmate_settings['header-quote-link'] != ''):?>
                        <a href="<?php echo esc_url($helpmate_settings['header-quote-link']);?>" class="free_quote"><?php echo esc_html__('Get a Free Quote','helpmate');?></a>
                    <?php else: ?>
                        <a href="#" class="free_quote"><?php echo esc_html__('Get a Free Quote','helpmate');?></a>
                    <?php endif; ?>
            </div>
        </div>
    </div>
    <?php get_template_part('breadcrumb'); ?>
</div>