<?php

if (!class_exists('ReduxFramework') && file_exists(helpmate_admin . '/ReduxCore/framework.php')) {
    require_once( helpmate_admin . '/ReduxCore/framework.php' );
}

require_once( helpmate_admin . '/settings/settings.php' );
require_once( helpmate_admin . '/settings/save_settings.php' );

function helpmate_check_theme_options() {
    // check default options
    global $helpmate_settings;
    if(!get_option('helpmate_settings')) {
        ob_start();
        include(helpmate_plugins . '/theme_options.php');
        $options = ob_get_clean();
        $helpmate_default_settings = json_decode($options, true);
        if (is_array($helpmate_default_settings) || is_object($helpmate_default_settings))
        {
            foreach ($helpmate_default_settings as $key => $value) {
                if (is_array($value)) {
                    foreach ($value as $key1 => $value1) {
                        if (!isset($helpmate_settings[$key][$key1]) || !$helpmate_settings[$key][$key1]) {
                            $helpmate_settings[$key][$key1] = $helpmate_default_settings[$key][$key1];
                        }
                    }
                } else {
                    if (!isset($helpmate_settings[$key])) {
                        $helpmate_settings[$key] = $helpmate_default_settings[$key];
                    }
                }
            }
        }
    }

    return $helpmate_settings;
}

if(!class_exists('ReduxFramework')) {
    helpmate_check_theme_options();
}
//get theme demo options
function helpmate_theme_types() {
    return array(
        '1' => esc_html__("Demo 1", 'helpmate'),
        '2' => esc_html__("Demo 2", 'helpmate'),
        '3' => esc_html__("Demo 3", 'helpmate'),
        '4' => esc_html__("Demo 4", 'helpmate'),
        '5' => esc_html__("Demo 5", 'helpmate'),
        '6' => esc_html__("Demo 6", 'helpmate')
    );
}
//get theme layout options
function helpmate_layouts() {
    return array(
        'default' => esc_html__('Default Layout', 'helpmate'),
        'wide' => esc_html__('Wide', 'helpmate'),
        'fullwidth' => esc_html__('Full width', 'helpmate')
    );
}
function helpmate_main_layouts() {
    return array(
        'default' => esc_html__('Default', 'helpmate'),
        'mad_main' => esc_html__('Main Layout 1', 'helpmate'),
        'mad_main2' => esc_html__('Main Layout 2', 'helpmate'),
        'mad_main3' => esc_html__('Main Layout 3', 'helpmate'),
        'mad_main4' => esc_html__('Main Layout 4', 'helpmate'),
        'mad_main5' => esc_html__('Main Layout 5', 'helpmate'),
        'mad_main6' => esc_html__('Main Layout 6', 'helpmate'),
    );
}
//helpmate popup
function helpmate_popup_layouts() {
    return array(
        'default' => esc_html__('Default Popup', 'helpmate'),
        '1' => esc_html__("Popup 1", 'helpmate'),
        '2' => esc_html__("Popup 2", 'helpmate'),
        '3' => esc_html__("Popup 3", 'helpmate'),
        '4' => esc_html__("Popup 4", 'helpmate'),
        '5' => esc_html__("Popup 5", 'helpmate'),
        '6' => esc_html__("Popup 6", 'helpmate')
    );
}
//get theme sidebar position options
function helpmate_sidebar_position() {
    return array(
        'default' => esc_html__('Default Position', 'helpmate'),
        'left-sidebar' => esc_html__('Left', 'helpmate'),
        'right-sidebar' => esc_html__('Right', 'helpmate'),
        'none' => esc_html__('None', 'helpmate')
    );
}
function helpmate_rev_sliders_in_array(){
    if (class_exists('RevSlider')) {
        $theslider     = new RevSlider();
        $arrSliders = $theslider->getArrSliders();
        $arrA     = array();
        $arrT     = array();
        foreach($arrSliders as $slider){
            $arrA[]     = $slider->getAlias();
            $arrT[]     = $slider->getTitle();
        }
        if($arrA && $arrT){
            $result = array_combine($arrA, $arrT);
        }
        else
        {
            $result = false;
        }
        return $result;
    }
}
function helpmate_header_types() {
    return array(
        'default' => esc_html__('Default Header', 'helpmate'),
        '1' => esc_html__('Header Type 1', 'helpmate'),
        '2' => esc_html__('Header Type 2', 'helpmate'),
        '3' => esc_html__('Header Type 3', 'helpmate'),
        '4' => esc_html__('Header Type 4', 'helpmate'),
        '5' => esc_html__('Header Type 5', 'helpmate'),
        '6' => esc_html__('Header Type 6', 'helpmate'),
    );
}

function helpmate_footer_types() {
    return array(
        'default' => esc_html__('Default Footer', 'helpmate'),
        '1' => esc_html__('Footer Type 1', 'helpmate'),
        '2' => esc_html__('Footer Type 2', 'helpmate'),
        '3' => esc_html__('Footer Type 3', 'helpmate'),
        '4' => esc_html__('Footer Type 4', 'helpmate'),
        '5' => esc_html__('Footer Type 5', 'helpmate'),
        '6' => esc_html__('Footer Type 6', 'helpmate'),
    );
}
function helpmate_product_columns() {
    return array(
        "2" => esc_html__("2", 'helpmate'),
        "3" => esc_html__("3", 'helpmate'),
        "4" => esc_html__("4", 'helpmate'),
    );
}
function helpmate_product_type() {
    return array(
        "only-grid" => esc_html__("Only Grid", 'helpmate'),
        "only-list" => esc_html__("Only List", 'helpmate'),
        "grid-default" => esc_html__("Grid (default) / List", 'helpmate'),
        "list-default" => esc_html__("List (default) / Grid", 'helpmate'),
    );
}
function helpmate_page_blog_layouts(){
    return array(
        "classic" => esc_html__("Classic", 'helpmate'),
        "grid" => esc_html__("Grid", 'helpmate'),
        "masonry" => esc_html__("Masonry", 'helpmate'),
    );
}
function helpmate_blog_columns() {
    return array(
        "1" => esc_html__("1", 'helpmate'),
        "2" => esc_html__("2", 'helpmate'),
    );
}
function helpmate_gallery_columns() {
    return array(
        "1" => esc_html__("1", 'helpmate'),
        "2" => esc_html__("2", 'helpmate'),
        "3" => esc_html__("3", 'helpmate'),
    );
}
function helpmate_page_gallery_layouts(){
    return array(
        "masonry" => esc_html__("Sorttable Masonry", 'helpmate'),
        "classic" => esc_html__("Classic", 'helpmate'),
        "grid" => esc_html__("Sorttable Grid", 'helpmate'),
    );
}
function helpmate_gallery_single_layout() {
    return array(
        "list_image" => esc_html__("List image", 'helpmate'),
        "full_image" => esc_html__("Full image", 'helpmate'),
        "full_banner" => esc_html__("Full Banner", 'helpmate'),
    );
}
function helpmate_get_block_name(){
    $block_options = array();
    $args = array(
        'numberposts'       => -1,
        'post_type'         => 'block',
        'post_status'       => 'publish',
    );
    $posts = get_posts($args);
    foreach( $posts as $_post ){
        $block_options[$_post->ID] = $_post->post_title;

    }
    return $block_options;
}