<?php

/**
 * Helpmate Settings Options
 */
if (!class_exists('Framework_Helpmate_Settings')) {

    class Framework_Helpmate_Settings {

        public $ReduxFramework;

        public function __construct() {

            if (!class_exists('ReduxFramework')) {
                return;
            }

            // This is needed. Bah WordPress bugs.  ;)
            if (true == Redux_Helpers::isTheme(__FILE__)) {
                $this->initSettings();
            } else {
                add_action('plugins_loaded', array($this, 'initSettings'), 10);
            }
        }

        public function initSettings() {
            $this->ReduxFramework = new ReduxFramework($this->helpmate_get_setting_sections(), $this->helpmate_get_setting_arguments());
        }

        public function helpmate_get_setting_sections() {
            $page_layout = helpmate_layouts();
            $sidebar_positions = helpmate_sidebar_position();
            $block_name = helpmate_get_block_name();
            $page_main_layout = helpmate_main_layouts();
            unset($page_layout['default']);
            unset($sidebar_positions['default']);
            $sections = array(
                array(
                    'icon' => 'el-icon-dashboard',
                    'icon_class' => 'icon',
                    'title' => esc_html__('General', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => '1',
                            'type' => 'info',
                            'desc' => esc_html__('Layout default', 'helpmate')
                        ),
                        array(
                            'id' => 'layout',
                            'type' => 'button_set',
                            'title' => esc_html__('Layout', 'helpmate'),
                            'options' => $page_layout,
                            'default' => 'fullwidth'
                        ),
                        array(
                            'id' => 'sidebar-position',
                            'type' => 'button_set',
                            'title' => esc_html__('Sidebar Position', 'helpmate'),
                            'options' => $sidebar_positions,
                            'default' => 'none'
                        ),
                        array(
                            'id' => 'sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Sidebar', 'helpmate'),
                            'required' => array('sidebar-position', 'equals', array(
                                    'left-sidebar',
                                    'right-sidebar'
                                )),
                            'data' => 'sidebars',
                            'default' => 'general-sidebar'
                        ),
                        array(
                            'id' => '1',
                            'type' => 'info',
                            'desc' => esc_html__('Logo, Icon', 'helpmate')
                        ),
                        array(
                            'id' => 'logo',
                            'type' => 'media',
                            'url' => true,
                            'readonly' => false,
                            'title' => esc_html__('Logo', 'helpmate'),
                            'default' => array(
                                'url' => get_template_directory_uri() . '/images/logo.png',
                                'height' => 60,
                                'wide' => 200
                            )
                        ),
                        array(
                            'id'=>'banner_block_general',
                            'type' => 'select',
                            'title' => esc_html__('Bottom Content', 'helpmate'),
                            'options' => $block_name,
                            'desc' => esc_html__('Choose a block to display at the bottom of pages. You can create a block in Static Block/Add New.', 'helpmate')
                        ),                        
                        array(
                            'id' => 'favicon',
                            'type' => 'media',
                            'url' => true,
                            'readonly' => false,
                            'title' => esc_html__('Favicon', 'helpmate'),
                            'default' => array(
                                'url' => get_template_directory_uri() . '/images/favicon.ico'
                            )
                        ),
                        array(
                            'id' => 'js-code',
                            'type' => 'ace_editor',
                            'title' => esc_html__('JS Code', 'helpmate'),
                            'subtitle' => esc_html__('Paste your JS code here.', 'helpmate'),
                            'mode' => 'javascript',
                            'theme' => 'chrome',
                            'default' => "jQuery(document).ready(function(){});"
                        )
                    )
                ),
                array(
                    'icon' => 'el-icon-css',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Skin', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'compile-css',
                            'type' => 'switch',
                            'title' => esc_html__('Compile CSS', 'helpmate'),
                            'default' => false
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('General', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'general-bg',
                            'type' => 'background',
                            'title' => esc_html__('General Background', 'helpmate'),
                            'default' => array(
                                'background-color' => '#fff',
                                'background-image' => '',
                                'background-size' => 'inherit',
                                'background-repeat' => 'no-repeat',
                                'background-position' => 'center center',
                                'background-attachment' => 'inherit'
                            ),
                            'transparent'   => true,
                        ),
                        array(
                            'id' => 'general-font',
                            'type' => 'typography',
                            'title' => esc_html__('General Font', 'helpmate'),
                            'google' => true,
                            'subsets' => false,
                            'font-style' => false,
                            'text-align' => false,
                            'default' => array(
                                'color' => "#696969",
                                'google' => true,
                                'font-weight' => '400',
                                'font-family' => 'Poppins',
                                'font-size' => '14px',
                                'line-height' => '21px'
                            ),
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Main layout', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'main_layout',
                            'type' => 'select',
                            'title' => esc_html__('Main Layout', 'helpmate'),
                            'options' => $page_main_layout,
                            'default' => 'mad_main'
                        ),
                        array(
                            'id' => 'primary-color',
                            'type' => 'color',
                            'title' => esc_html__('Primary color', 'helpmate'),
                            'default' => '#b92127',
                            'validate' => 'color',
                            'transparent' => false,
                            'required' => array('main_layout', 'equals', array(
                                'mad_main',
                            )),                            
                        ),
                        array(
                            'id' => 'highlight-color',
                            'type' => 'color',
                            'title' => esc_html__('Highlight color', 'helpmate'),
                            'default' => '#2965b0',
                            'validate' => 'color',
                            'description' => esc_html__('change links color when hover/active.', 'helpmate'),
                            'transparent' => false,
                            'required' => array('main_layout', 'equals', array(
                                'mad_main',
                            )),                            
                        ),
                        array(
                            'id' => 'primary-color2',
                            'type' => 'color',
                            'title' => esc_html__('Primary color', 'helpmate'),
                            'default' => '#de5b92',
                            'validate' => 'color',
                            'transparent' => false,
                            'required' => array('main_layout', 'equals', array(
                                'mad_main2',
                            )),                            
                        ),
                        array(
                            'id' => 'highlight-color2',
                            'type' => 'color',
                            'title' => esc_html__('Highlight color', 'helpmate'),
                            'default' => '#27a63d',
                            'validate' => 'color',
                            'description' => esc_html__('change links color when hover/active.', 'helpmate'),
                            'transparent' => false,
                            'required' => array('main_layout', 'equals', array(
                                'mad_main2',
                            )),                            
                        ),
                        array(
                            'id' => 'primary-color3',
                            'type' => 'color',
                            'title' => esc_html__('Primary color', 'helpmate'),
                            'default' => '#2abfd4',
                            'validate' => 'color',
                            'transparent' => false,
                            'required' => array('main_layout', 'equals', array(
                                'mad_main3',
                            )),                            
                        ),
                        array(
                            'id' => 'highlight-color3',
                            'type' => 'color',
                            'title' => esc_html__('Highlight color', 'helpmate'),
                            'default' => '#224687',
                            'validate' => 'color',
                            'description' => esc_html__('change links color when hover/active.', 'helpmate'),
                            'transparent' => false,
                            'required' => array('main_layout', 'equals', array(
                                'mad_main3',
                            )),                            
                        ),
                        array(
                            'id' => 'primary-color4',
                            'type' => 'color',
                            'title' => esc_html__('Primary color', 'helpmate'),
                            'default' => '#82c213',
                            'validate' => 'color',
                            'transparent' => false,
                            'required' => array('main_layout', 'equals', array(
                                'mad_main4',
                            )),                            
                        ),
                        array(
                            'id' => 'highlight-color4',
                            'type' => 'color',
                            'title' => esc_html__('Highlight color', 'helpmate'),
                            'default' => '#2c95ff',
                            'validate' => 'color',
                            'description' => esc_html__('change links color when hover/active.', 'helpmate'),
                            'transparent' => false,
                            'required' => array('main_layout', 'equals', array(
                                'mad_main4',
                            )),                            
                        ),
                        array(
                            'id' => 'primary-color5',
                            'type' => 'color',
                            'title' => esc_html__('Primary color', 'helpmate'),
                            'default' => '#f4bc16',
                            'validate' => 'color',
                            'transparent' => false,
                            'required' => array('main_layout', 'equals', array(
                                'mad_main5',
                            )),                            
                        ),
                        array(
                            'id' => 'highlight-color5',
                            'type' => 'color',
                            'title' => esc_html__('Highlight color', 'helpmate'),
                            'default' => '#666666',
                            'validate' => 'color',
                            'description' => esc_html__('change links color when hover/active.', 'helpmate'),
                            'transparent' => false,
                            'required' => array('main_layout', 'equals', array(
                                'mad_main5',
                            )),                            
                        ),
                        array(
                            'id' => 'primary-color6',
                            'type' => 'color',
                            'title' => esc_html__('Primary color', 'helpmate'),
                            'default' => '#5080bf',
                            'validate' => 'color',
                            'transparent' => false,
                            'required' => array('main_layout', 'equals', array(
                                'mad_main6',
                            )),                            
                        ),
                        array(
                            'id' => 'highlight-color6',
                            'type' => 'color',
                            'title' => esc_html__('Highlight color', 'helpmate'),
                            'default' => '#ec3238',
                            'validate' => 'color',
                            'description' => esc_html__('change links color when hover/active.', 'helpmate'),
                            'transparent' => false,
                            'required' => array('main_layout', 'equals', array(
                                'mad_main6',
                            )),                            
                        )                                                                                                                        
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Header', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'enable_header_style',
                            'type' => 'switch',
                            'title' => esc_html__('Enable custom header styling', 'helpmate'),
                            'default' => false,
                            'subtitle'  => esc_html__('Turn on to take effect custom header styling', 'helpmate'),
                        ),                        
                        array( 
                            'id'       => 'header-style',
                            'type'     => 'select',
                            'title'    => esc_html__('Select header type', 'helpmate'),
                            'subtitle' => esc_html__('Select header type to update header styling', 'helpmate'),
                            'options' => array(
                                '1' => esc_html__('Header Type 1', 'helpmate'),
                                '2' => esc_html__('Header Type 2', 'helpmate'),
                                '3' => esc_html__('Header Type 3', 'helpmate'),
                                '4' => esc_html__('Header Type 4', 'helpmate'),
                                '5' => esc_html__('Header Type 5', 'helpmate'),
                                '6' => esc_html__('Header Type 6', 'helpmate'),
                            ),
                            'default' => '6'
                        ),                    
                        array(
                            'id' => 'header-bg',
                            'type' => 'color',
                            'title' => esc_html__('Header background color', 'helpmate'),
                            'default' => 'transparent',
                            'validate' => 'color',
                            'transparent' => true,
                            'required' => array('header-style', 'equals', array(
                                    '3','1','2','5','6',
                                )),                             
                        ),
                    //Header 6                         
                        array(
                            'id'        => 'header6_top_bg',
                            'type'      => 'color',
                            'title'     => esc_html__('Header Top Background Color', 'helpmate'),
                            'subtitle'  => esc_html__('Header Top Background Color (default: #fff).', 'helpmate'),
                            'default'   => '#fff',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '6',
                                )),                            
                        ),  
                        array(
                            'id'        => 'header6_top_text_color',
                            'type'      => 'color',
                            'title'     => esc_html__('Header Top Text Color', 'helpmate'),
                            'subtitle'  => esc_html__('Header Top Text Color (default: #222).', 'helpmate'),
                            'default'   => '#222',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '6',
                                )),                            
                        ),
                        array(
                            'id'        => 'header6_top_social_color',
                            'type'      => 'color',
                            'title'     => esc_html__('Header Top Social Color', 'helpmate'),
                            'subtitle'  => esc_html__('Header Top Social Color (default: #bababa).', 'helpmate'),
                            'default'   => '#bababa',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '6',
                                    '3'
                                )),                            
                        ),  
                        array(
                            'id'        => 'header6_info_text_color',
                            'type'      => 'color',
                            'title'     => esc_html__('Header Info Text Color', 'helpmate'),
                            'subtitle'  => esc_html__('Header Info Text Color (default: #555).', 'helpmate'),
                            'default'   => '#555',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '6',
                                )),                            
                        ),                                                                                               
                        array(
                            'id'        => 'header6_menu_bg',
                            'type'      => 'color',
                            'title'     => esc_html__('Main Navigation Background Color', 'helpmate'),
                            'subtitle'  => esc_html__('Main Navigation Background Color (default: #5080bf).', 'helpmate'),
                            'default'   => '#5080bf',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '6',
                                )),                            
                        ),  
                        array(
                            'id'        => 'header6_menu_text_color',
                            'type'      => 'color',
                            'title'     => esc_html__('Menu text color', 'helpmate'),
                            'subtitle'  => esc_html__('Menu text color (default: #fff).', 'helpmate'),
                            'default'   => '#fff',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '6',
                                )),                            
                        ), 
                    //Header 1
                        array(
                            'id'        => 'header1_top_bg',
                            'type'      => 'color',
                            'title'     => esc_html__('Header Top Background Color', 'helpmate'),
                            'subtitle'  => esc_html__('Header Top Background Color (default: #fff).', 'helpmate'),
                            'default'   => '#fff',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '1',
                                )),                            
                        ),  
                        array(
                            'id'        => 'header1_top_text_color',
                            'type'      => 'color',
                            'title'     => esc_html__('Header Top Text Color', 'helpmate'),
                            'subtitle'  => esc_html__('Header Top Text Color (default: #696969).', 'helpmate'),
                            'default'   => '#696969',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '1',
                                )),                            
                        ), 
                        array(
                            'id'        => 'header1_menu_text_color',
                            'type'      => 'color',
                            'title'     => esc_html__('Menu text color', 'helpmate'),
                            'subtitle'  => esc_html__('Menu text color (default: #fff).', 'helpmate'),
                            'default'   => '#fff',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '1',
                                    '2'
                                )),                            
                        ), 
                    //Header-v2
                        array(
                            'id'        => 'header2_info_text_color',
                            'type'      => 'color',
                            'title'     => esc_html__('Menu info text color', 'helpmate'),
                            'subtitle'  => esc_html__('Menu info text color (default: #a1a1a1).', 'helpmate'),
                            'default'   => '#a1a1a1',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '2'
                                )),                            
                        ),                         
                        
                    //Header-v3
                        array(
                            'id'        => 'header3_top_bg',
                            'type'      => 'color',
                            'title'     => esc_html__('Header Top Background Color', 'helpmate'),
                            'subtitle'  => esc_html__('Header Top Background Color (default: #fafafa).', 'helpmate'),
                            'default'   => '#fafafa',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '3',
                                )),                            
                        ),
                        array(
                            'id'        => 'header3_top_border',
                            'type'      => 'color',
                            'title'     => esc_html__('Header Top Border Color', 'helpmate'),
                            'subtitle'  => esc_html__('Header Top Border Color (default: #ececec ).', 'helpmate'),
                            'default'   => '#ececec ',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '3',
                                )),                            
                        ),                           
                        array(
                            'id'        => 'header3_menu_text_color',
                            'type'      => 'color',
                            'title'     => esc_html__('Menu text color', 'helpmate'),
                            'subtitle'  => esc_html__('Menu text color (default: #224687).', 'helpmate'),
                            'default'   => '#224687',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '3',
                                )),                            
                        ), 
                        array(
                            'id'        => 'header3_menu_icon_color',
                            'type'      => 'color',
                            'title'     => esc_html__('Menu icon color', 'helpmate'),
                            'subtitle'  => esc_html__('Menu icon color (default: #e7e7e7).', 'helpmate'),
                            'default'   => '#e7e7e7',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '3',
                                )),                            
                        ),                                                                        
                    //Header-v4
                        array(
                            'id'        => 'header4_menu_text_color',
                            'type'      => 'color',
                            'title'     => esc_html__('Menu text color', 'helpmate'),
                            'subtitle'  => esc_html__('Menu text color (default: #262729).', 'helpmate'),
                            'default'   => '#262729',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '4',
                                )),                            
                        ),  
                        array(
                            'id'        => 'header4_menu_bg',
                            'type'      => 'color',
                            'title'     => esc_html__('Main Navigation Background Color', 'helpmate'),
                            'subtitle'  => esc_html__('Main Navigation Background Color (default: rgba(255, 255, 255, 0.8)).', 'helpmate'),
                            'default'   => 'rgba(255, 255, 255, 0.8)',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '4',
                                )),                            
                        ),   

                    //Header-v5
                        array(
                            'id'        => 'header5_menu_text_color',
                            'type'      => 'color',
                            'title'     => esc_html__('Menu text color', 'helpmate'),
                            'subtitle'  => esc_html__('Menu text color (default: #3b3b3b).', 'helpmate'),
                            'default'   => '#3b3b3b',
                            'validate'  => 'color',
                            'required' => array('header-style', 'equals', array(
                                    '5',
                                )),                            
                        ),                        
                    //End Header styling                                                                                 
                    )
                ),

                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Breadcrumbs', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'breadcrumbs-bg',
                            'type' => 'background',
                            'title' => esc_html__('Background', 'helpmate'),
                            'background-color' => false,
                            'default' => array(
                                'background-color' => '#fff',
                                'background-image' => get_template_directory_uri() . '/images/bg-breadcrumb.jpg',
                                'background-size' => 'cover',
                                'background-repeat' => 'no-repeat',
                                'background-position' => 'center center',
                                'background-attachment' => 'inherit'
                            ),
                        ),
                        array(
                            'id' => 'breadcrumbs-bg2',
                            'type' => 'background',
                            'title' => esc_html__('[Header 2] Breadcrumb background', 'helpmate'),
                            'background-color' => false,
                            'default' => array(
                                'background-color' => '#fff',
                                'background-image' => get_template_directory_uri() . '/images/inner_bg_top.jpg',
                                'background-size' => 'cover',
                                'background-repeat' => 'no-repeat',
                                'background-position' => 'center center',
                                'background-attachment' => 'inherit'
                            ),
                        ),
                        array(
                            'id' => 'header4-bg',
                            'type' => 'background',
                            'title' => esc_html__('[Header 4] Background', 'helpmate'),
                            'background-color' => false,
                            'default' => array(
                                'background-color' => '#fff',
                                'background-image' => get_template_directory_uri() . '/images/header_4_bg.jpg',
                                'background-size' => 'cover',
                                'background-repeat' => 'no-repeat',
                                'background-position' => 'center center',
                                'background-attachment' => 'inherit'
                            ),
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Typography', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'h1-font',
                            'type' => 'typography',
                            'title' => esc_html__('H1 Font', 'helpmate'),
                            'google' => true,
                            'subsets' => false,
                            'font-style' => false,
                            'text-align' => false,
                            'font-weight' => false,
                            'line-height' => false,
                            'default' => array(
                                'color' => "#333",
                                'google' => true,
                                'font-family' => 'inherit',
                                'font-size' => '40px',
                            ),
                        ),
                        array(
                            'id' => 'h2-font',
                            'type' => 'typography',
                            'title' => esc_html__('H2 Font', 'helpmate'),
                            'google' => true,
                            'subsets' => false,
                            'font-style' => false,
                            'text-align' => false,
                            'font-weight' => false,
                            'line-height' => false,
                            'default' => array(
                                'color' => "#333",
                                'google' => true,
                                'font-family' => 'inherit',
                                'font-size' => '40px',
                            ),
                        ),
                        array(
                            'id' => 'h3-font',
                            'type' => 'typography',
                            'title' => esc_html__('H3 Font', 'helpmate'),
                            'google' => true,
                            'subsets' => false,
                            'font-style' => false,
                            'text-align' => false,
                            'font-weight' => false,
                            'line-height' => false,
                            'default' => array(
                                'color' => "#333",
                                'google' => true,
                                'font-family' => 'inherit',
                                'font-size' => '30px',
                            ),
                        ),
                        array(
                            'id' => 'h4-font',
                            'type' => 'typography',
                            'title' => esc_html__('H4 Font', 'helpmate'),
                            'google' => true,
                            'subsets' => false,
                            'font-style' => false,
                            'text-align' => false,
                            'font-weight' => false,
                            'line-height' => false,
                            'default' => array(
                                'color' => "#333",
                                'google' => true,
                                'font-family' => 'inherit',
                                'font-size' => '24px',
                            ),
                        ),
                        array(
                            'id' => 'h5-font',
                            'type' => 'typography',
                            'title' => esc_html__('H5 Font', 'helpmate'),
                            'google' => true,
                            'subsets' => false,
                            'font-style' => false,
                            'text-align' => false,
                            'font-weight' => false,
                            'line-height' => false,
                            'default' => array(
                                'color' => "#333",
                                'google' => true,
                                'font-family' => 'inherit',
                                'font-size' => '16px',
                            ),
                        ),
                        array(
                            'id' => 'h6-font',
                            'type' => 'typography',
                            'title' => esc_html__('H6 Font', 'helpmate'),
                            'google' => true,
                            'subsets' => false,
                            'font-style' => false,
                            'text-align' => false,
                            'font-weight' => false,
                            'line-height' => false,
                            'default' => array(
                                'color' => "#333",
                                'google' => true,
                                'font-family' => 'inherit',
                                'font-size' => '14px',
                            ),
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Custom', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'custom-css-code',
                            'type' => 'ace_editor',
                            'title' => esc_html__('CSS', 'helpmate'),
                            'subtitle' => esc_html__('Enter CSS code here.', 'helpmate'),
                            'mode' => 'css',
                            'theme' => 'monokai',
                            'default' => ""
                        ),
                    )
                ),
                $this->helpmate_add_header_section_options(),
                array(
                    'icon' => 'el-icon-website',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Footer', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'footer-type',
                            'type' => 'image_select',
                            'title' => esc_html__('Footer Type', 'helpmate'),
                            'options' => $this->helpmate_footer_types(),
                            'default' => '1'
                        ),

                        array(
                            'id' => "footer-copyright",
                            'type' => 'textarea',
                            'title' => esc_html__('Copyright', 'helpmate'),
                            'default' => '&copy;'.esc_html__('2016 Helpmate - Made With Pasion!','helpmate'),
                        ),
                    )
                ),
                array(
                    'icon' => 'el-icon-website',
                    'icon_class' => 'icon',
                    'title' => esc_html__('404 page','helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'hide-footer',
                            'type' => 'switch',
                            'title' => esc_html__('Display footer', 'helpmate'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),
                    )
                ),
                array(
                    'icon' => 'el-icon-brush',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Blog & Single Blog', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => '1',
                            'type' => 'info',
                            'desc' => esc_html__('Blog layout default', 'helpmate')
                        ),
                        array(
                            'id' => 'post-layout',
                            'type' => 'button_set',
                            'title' => esc_html__('Layout', 'helpmate'),
                            'options' => $page_layout,
                            'default' => 'fullwidth'
                        ),
                        array(
                            'id' => 'post-sidebar-position',
                            'type' => 'button_set',
                            'title' => esc_html__('Sidebar Position', 'helpmate'),
                            'options' => $sidebar_positions,
                            'default' => 'right-sidebar'
                        ),
                        array(
                            'id' => 'post-sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Sidebar', 'helpmate'),
                            'required' => array('post-sidebar-position', 'equals', array(
                                    'left-sidebar',
                                    'right-sidebar'
                                )),
                            'data' => 'sidebars',
                            'default' => 'blog-sidebar'
                        ),
                        array(
                            'id' => 'blog-title',
                            'type' => 'text',
                            'title' => esc_html__('Page Title', 'helpmate'),
                            'default' => 'Blog'
                        ),
                        array(
                            'id' => '1',
                            'type' => 'info',
                            'desc' => esc_html__('Blog archive', 'helpmate')
                        ),                        
                        array(
                            'id' => 'post-layout-version',
                            'type' => 'button_set',
                            'title' => esc_html__('Page layout', 'helpmate'),
                            'options' => helpmate_page_blog_layouts(),
                            'default' => 'classic'
                        ),                      
                    )
                ),
                array(
                    'icon' => 'el-icon-file',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Gallery', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => '2',
                            'type' => 'info',
                            'desc' => esc_html__('Gallery Archive Page', 'helpmate')
                        ),
                        array(
                            'id' => 'gallery-layout',
                            'type' => 'button_set',
                            'title' => esc_html__('Layout', 'helpmate'),
                            'options' => $page_layout,
                            'default' => 'fullwidth'
                        ),
                        array(
                            'id' => 'gallery-sidebar-position',
                            'type' => 'button_set',
                            'title' => esc_html__('Sidebar Position', 'helpmate'),
                            'options' => $sidebar_positions,
                            'default' => 'none'
                        ),
                        array(
                            'id' => 'gallery-sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Sidebar', 'helpmate'),
                            'required' => array('gallery-sidebar-position', 'equals', array(
                                    'left-sidebar',
                                    'right-sidebar'
                                )),
                            'data' => 'sidebars',
                            'default' => 'gallery-sidebar'
                        ),
                        array(
                            'id' => 'gallery-layout-version',
                            'type' => 'button_set',
                            'title' => esc_html__('Gallery page layout', 'helpmate'),
                            'options' => helpmate_page_gallery_layouts(),
                            'default' => 'grid'
                        ),
                        array(
                            'id' => 'gallery-cols',
                            'type' => 'button_set',
                            'title' => esc_html__('Gallery Columns', 'helpmate'),
                            'required' => array('gallery-layout-version', 'equals', array(
                                    'classic'
                                )),
                            'options' => helpmate_gallery_columns(),
                            'default' => '3',
                        ),
                        array(
                            'id' => 'gallery-archive-pagination-type',
                            'type' => 'button_set',
                            'title' => esc_html__('Pagination type', 'helpmate'),
                            'options' => array('loadmore' => esc_html__('Load more', 'helpmate'), 'nav' => esc_html__('Navigation', 'helpmate')),
                            'default' => 'loadmore'
                        ),
                    )
                ),
                array(
                    'icon' => 'el-icon-shopping-cart',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Shop', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'product-wishlist',
                            'type' => 'switch',
                            'title' => esc_html__('Show wishlist', 'helpmate'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate')
                        ),
                        array(
                            'id' => 'product_label',
                            'type' => 'switch',
                            'title' => esc_html__('Show product sale flash', 'helpmate'),
                            'desc' => esc_html__('Show/hide product sale flash', 'helpmate'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),
                        array(
                            'id' => 'product_price',
                            'type' => 'switch',
                            'title' => esc_html__('Show product price', 'helpmate'),
                            'desc' => esc_html__('Show/hide product price', 'helpmate'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),
                        array(
                            'id' => 'product_add_cart',
                            'type' => 'switch',
                            'title' => esc_html__('Show product "Add to Cart" button', 'helpmate'),
                            'desc' => esc_html__('Show/hide product "Add to Cart" button', 'helpmate'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),                        
                        array(
                            'id' => '1',
                            'type' => 'info',
                            'desc' => esc_html__('Product listing', 'helpmate')
                        ),
                        array(
                            'id' => 'shop-layout',
                            'type' => 'button_set',
                            'title' => esc_html__('Layout', 'helpmate'),
                            'options' => $page_layout,
                            'default' => 'fullwidth'
                        ),
                        array(
                            'id' => 'shop-sidebar-position',
                            'type' => 'button_set',
                            'title' => esc_html__('Sidebar Position', 'helpmate'),
                            'options' => $sidebar_positions,
                            'default' => 'right-sidebar'
                        ),
                        array(
                            'id' => 'shop-sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Sidebar', 'helpmate'),
                            'required' => array('shop-sidebar-position', 'equals', array(
                                    'left-sidebar',
                                    'right-sidebar'
                                )),
                            'data' => 'sidebars',
                            'default' => 'shop-sidebar'
                        ),
                        array(
                            'id' => 'category-item',
                            'type' => 'text',
                            'title' => esc_html__('Products per Page', 'helpmate'),
                            'desc' => esc_html__('Comma separated list of product counts.', 'helpmate'),
                            'default' => '12,24,36'
                        ),

                        array(
                            'id' => '1',
                            'type' => 'info',
                            'desc' => esc_html__('Single Product', 'helpmate')
                        ),
                        array(
                            'id' => 'single-product-layout',
                            'type' => 'button_set',
                            'title' => esc_html__('Layout', 'helpmate'),
                            'options' => $page_layout,
                            'default' => 'fullwidth'
                        ),
                        array(
                            'id' => 'single-product-sidebar-position',
                            'type' => 'button_set',
                            'title' => esc_html__('Sidebar Position', 'helpmate'),
                            'options' => $sidebar_positions,
                            'default' => 'right-sidebar'
                        ),
                        array(
                            'id' => 'single-product-sidebar',
                            'type' => 'select',
                            'title' => esc_html__('Select Sidebar', 'helpmate'),
                            'required' => array('single-product-sidebar-position', 'equals', array(
                                    'left-sidebar',
                                    'right-sidebar'
                                )),
                            'data' => 'sidebars',
                            'default' => 'single-product-sidebar'
                        ),
                        array(
                            'id' => 'single_product_share',
                            'type' => 'switch',
                            'title' => esc_html__('Show share and wishlist link in single product display', 'helpmate'),
                            'desc' => esc_html__('Show/hide wishlist and share link', 'helpmate'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),
                        array(
                            'id' => 'banner_product',
                            'type' => 'media',
                            'url' => true,
                            'readonly' => false,
                            'title' => esc_html__('Banner bottom', 'helpmate'),
                            'default' => array(
                                'url' => get_template_directory_uri() . '/images/banner_product.jpg',
                            )
                        ),

                    )
                ),
                array(
                    'icon' => 'el-icon-cog',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Comming soon', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'under-contr-mode',
                            'type' => 'switch',
                            'title' => esc_html__('Activate comming soon mode', 'helpmate'),
                            'default' => false,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),
                        array(
                            'id' => "under-contr-content",
                            'type' => 'editor',
                            'title' => esc_html__('Content', 'helpmate'),
                            'default' => wp_kses(__('
                                    <h2>Currently we are under construction</h2>
                                    <p>We will be back in:</p>', 'helpmate'),array(
                                        'h2' => array(),
                                        'p' => array(),
                                    ))
                        ),
                        array(
                            'id' => '1',
                            'type' => 'info',
                            'desc' => esc_html__('Countdown Timer', 'helpmate')
                        ),
                        array(
                            'id' => 'under-display-countdown',
                            'type' => 'switch',
                            'title' => esc_html__('Display countdown timer', 'helpmate'),
                            'default' => false,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),
                        array(
                            'id' => "under-end-date",
                            'type' => 'date',
                            'title' => esc_html__('End date', 'helpmate'),
                            'default' => '',
                            'required' => array('under-display-countdown', 'equals', true),
                        ),
                        array(
                            'id' => 'list-link-social',
                            'type' => 'switch',
                            'title' => esc_html__('Show social list link', 'helpmate'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),
                        array(
                            'id' => 'under-mail',
                            'type' => 'switch',
                            'title' => esc_html__('Display subcribe form', 'helpmate'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),
                        array(
                            'id' => 'comming_form',
                            'type' => 'textarea',
                            'title' => esc_html__('Subcribe form shortcode', 'helpmate'),
                            'default' => '[mc4wp_form id="36"]',
                            'desc' => esc_html__('Get mailchimp form shortcode in MailChimp For WP > Forms > Get Shortcode','helpmate'), 
                            'required' => array('under-mail', 'equals', true),                           
                        ),
                    )
                ),
                array(
                    'icon' => 'el el-network',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Social', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => '1',
                            'type' => 'info',
                            'desc' => esc_html__('If the Url empty, the social icon will not display.', 'helpmate')
                        ),
                         array(
                            'id' => 'social-twitter',
                            'type' => 'text',
                            'title' => esc_html__('Twitter', 'helpmate'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'helpmate')
                        ),
                        array(
                            'id' => 'social-instagram',
                            'type' => 'text',
                            'title' => esc_html__('Instagram', 'helpmate'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'helpmate')
                        ),
                        array(
                            'id' => 'social-facebook',
                            'type' => 'text',
                            'title' => esc_html__('Facebook', 'helpmate'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'helpmate')
                        ),
                        array(
                            'id' => 'social-mail',
                            'type' => 'text',
                            'title' => esc_html__('Mail', 'helpmate'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'helpmate')
                        ),
                        array(
                            'id' => 'social-rss',
                            'type' => 'text',
                            'title' => esc_html__('RSS', 'helpmate'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'helpmate')
                        ),
                        array(
                            'id' => 'social-google',
                            'type' => 'text',
                            'title' => esc_html__('Googleplus', 'helpmate'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'helpmate')
                        ),
                        array(
                            'id' => 'social-vimeo',
                            'type' => 'text',
                            'title' => esc_html__('Vimeo', 'helpmate'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'helpmate')
                        ),
                        array(
                            'id' => 'social-behance',
                            'type' => 'text',
                            'title' => esc_html__('Behance', 'helpmate'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'helpmate')
                        ),
                        array(
                            'id' => 'social-flickr',
                            'type' => 'text',
                            'title' => esc_html__('Flickr', 'helpmate'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'helpmate')
                        ),
                        array(
                            'id' => 'social-yahoo',
                            'type' => 'text',
                            'title' => esc_html__('Yahoo', 'helpmate'),
                            'default' => '#',
                            'placeholder' => esc_html__('http://', 'helpmate')
                        ),
                    )
                ),
                array(
                    'icon' => 'el el-icon-book',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Side Tabbed Panel', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => '1',
                            'type' => 'info',
                            'desc' => esc_html__('Config Side Tabbeb Panel', 'helpmate')
                        ),                        
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Facebook', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'side-facebook',
                            'type' => 'switch',
                            'title' => esc_html__('Show Facebook', 'helpmate'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),   
                        array(
                            'id' => 'link_url_facebook',
                            'type' => 'text',
                            'title' => esc_html__('Link Page Facebook', 'helpmate'),
                            'required' => array('side-facebook', 'equals', true),
                            'placeholder' => esc_html__('https://facebook.com/...', 'helpmate'),
                            'default' => esc_html__('https://facebook.com/Envato', 'helpmate'),
                        ), 
                        array(
                            'id' => 'show_stream',
                            'type' => 'switch',
                            'title' => esc_html__('Show Stream', 'helpmate'),
                            'default' => true,
                            'required' => array('side-facebook', 'equals', true),
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),   
                        array(
                            'id' => 'show_face',
                            'type' => 'switch',
                            'title' => esc_html__('Show Face', 'helpmate'),
                            'default' => true,
                            'required' => array('side-facebook', 'equals', true),
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),   
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Twitter', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'side-twitter',
                            'type' => 'switch',
                            'title' => esc_html__('Show Twitter', 'helpmate'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Contact', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'side-contact',
                            'type' => 'switch',
                            'title' => esc_html__('Show Contact', 'helpmate'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),
                        array(
                            'id' => 'form_contact',
                            'type' => 'textarea',
                            'title' => esc_html__('Contact form shortcode', 'helpmate'),
                            'default' => '',
                            'desc' => esc_html__('Get contact form shortcode in Contact > Contact Forms','helpmate'),                            
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Google Map', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'side-map',
                            'type' => 'switch',
                            'title' => esc_html__('Show Google Map', 'helpmate'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),
                        array(
                            'id' => 'store-contact-location',
                            'type' => 'text',
                            'title' => esc_html__('Location', 'helpmate'),
                            'default' => esc_html__('8901 Marmora Road, Glasgow, D04 89GR.', 'helpmate'),
                            'placeholder' => esc_html__('8901 Marmora Road, Glasgow, D04 89GR.', 'helpmate'),                      
                        ),
                        array(
                            'id' => 'store-contact-phonenumber',
                            'type' => 'text',
                            'title' => esc_html__('Phone number', 'helpmate'),
                            'default' => esc_html__('800-559-65-80', 'helpmate'),
                        ),
                        array(
                            'id' => 'store-contact-email',
                            'type' => 'text',
                            'title' => esc_html__('Email', 'helpmate'),
                            'default' => esc_html__('info@companyname.com', 'helpmate'),
                            'placeholder' => esc_html__('info@companyname.com', 'helpmate'),
                        ),
                        array(
                            'id' => 'store-contact-time',
                            'type' => 'text',
                            'title' => esc_html__('Working time', 'helpmate'),
                            'default' => esc_html__('Monday - Friday: 08.00-20.00 Saturday: 09.00-15.00 Sunday: closed', 'helpmate'),
                            'placeholder' => esc_html__('Monday - Friday: 08.00-20.00 Saturday: 09.00-15.00 Sunday: closed', 'helpmate'),
                        ),
                        array(
                            'id' => "iframe-google-map",
                            'type' => 'textarea',
                            'title' => esc_html__('Iframe Google Map', 'helpmate'),
                            'default' => '<iframe width="100%" height="220" style="border:0"
src="https://www.google.com/maps/embed/v1/place?q=place_id:ChIJOwg_06VPwokRYv534QaPC8g&key=AIzaSyCBaTK82YAuTrQ9BwJcfE3ez2DoIvlApzU" allowfullscreen></iframe>',
                            'desc' => esc_html__('Get Iframe In Website https://developers.google.com/maps/documentation/embed/start', 'helpmate')
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Instagram', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'side-instagram',
                            'type' => 'switch',
                            'title' => esc_html__('Show Instagram', 'helpmate'),
                            'default' => true,
                            'on' => esc_html__('Yes', 'helpmate'),
                            'off' => esc_html__('No', 'helpmate'),
                        ),
                        array(
                            'id' => "iframe-instagram",
                            'type' => 'textarea',
                            'title' => esc_html__('Iframe Instagram', 'helpmate'),
                            'default' => '<iframe src="http://instaembedder.com/gallery-v2.php?username=arrowpress&width=55&cols=4&rows=4&margin=2&color=gray&image_border=8&frame_color=white&" frameborder="0" width="100%" height="262" ></iframe>',
                            'desc' => esc_html__('Get Iframe In Website http://widgets.websta.me/widgets or http://widgets.websta.me/', 'helpmate')
                        ),
                    )
                ),
				array(
                    'icon' => 'el-icon-file',
                    'icon_class' => 'icon',
                    'title' => esc_html__('Popup', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => '1',
                            'type' => 'info',
                            'desc' => esc_html__('Config Popup For Page', 'helpmate')
                        ),      
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Popup 1', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'popup-title',
                            'type' => 'text',
                            'title' => esc_html__('Popup Title', 'helpmate'), 
                            'default' => esc_html__('GOT A CLOGGED DRAIN?', 'helpmate')
                        ),
                        array(
                            'id' => 'popup-description',
                            'type' => 'textarea',
                            'title' => esc_html__('Popup Description', 'helpmate'),
                            'default' => esc_html__('We&rsquo;ll clear it for $99. Guaranteed.', 'helpmate')
                        ),
                        array(
                            'id' => 'popup-time',
                            'type' => 'text',
                            'title' => esc_html__('Popup Time', 'helpmate'),
                            'default' => esc_html__('(Expires July 31, 2015)', 'helpmate')
                        ),
                        array(
                            'id' => 'popup-btn',
                            'type' => 'text',
                            'title' => esc_html__('Popup Button', 'helpmate'),
                            'default' => esc_html__('Shop now', 'helpmate')
                        ),
                        array(
                            'id' => 'popup-link',
                            'type' => 'text',
                            'title' => esc_html__('Popup Button Link', 'helpmate'),
                            'default' => esc_html__('#', 'helpmate'),
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Popup 2', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'popup-title-2',
                            'type' => 'text',
                            'title' => esc_html__('Popup Title', 'helpmate'), 
                            'default' => esc_html__('Quick Contact', 'helpmate')
                        ),
                        array(
                            'id' => 'popup-description-2',
                            'type' => 'textarea',
                            'title' => esc_html__('Popup Description', 'helpmate'),
                            'default' => esc_html__('Please fill out the details below and select a service & we will get in touch to arrange your free quote:', 'helpmate')
                        ),
						array(
                            'id' => 'popup-form-2',
                            'type' => 'textarea',
                            'title' => esc_html__('Popup Contact Form', 'helpmate'),
                            'default' => '',
                            'desc' => esc_html__('Get contact form shortcode in Contact > Contact Forms','helpmate'),
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Popup 3', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'popup-title-3',
                            'type' => 'text',
                            'title' => esc_html__('Popup Title', 'helpmate'), 
                            'default' => esc_html__('Save $10 OFF Your First Cleaning!', 'helpmate')
                        ),
                        array(
                            'id' => 'popup-title-32',
                            'type' => 'text',
                            'title' => esc_html__('Popup Title', 'helpmate'), 
                            'default' => esc_html__('Get Your Home Cleaned Today.', 'helpmate'),
                        ),
						array(
                            'id' => 'popup-form-3',
                            'type' => 'textarea',
                            'title' => esc_html__('Popup Contact Form', 'helpmate'),
                            'default' => '',
                            'desc' => esc_html__('Get contact form shortcode in Contact > Contact Forms','helpmate'),
                        ),
                        array(
                            'id' => 'popup-description-3',
                            'type' => 'editor',
                            'title' => esc_html__('Popup Description', 'helpmate'),
                            'default' => wp_kses(__('We will not share your information with anyone. Offer <strong>VALID</strong> for <strong>NEW</strong> customers <strong>ONLY</strong>. <br>Cannot be combined with <strong>ANY OTHER PROMOTIONS OR OFFERS.</strong>', 'helpmate'),array(
                                    'strong' => array(),
                                    'br'    => array(),
                                ))
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Popup 4', 'helpmate'),
                    'fields' => array(
                        array(
                            'id' => 'popup-title-4',
                            'type' => 'text',
                            'title' => esc_html__('Popup Title', 'helpmate'), 
                            'default' => esc_html__('We Offer', 'helpmate')
                        ),
                        array(
                            'id' => 'popup-title-42',
                            'type' => 'text',
                            'title' => esc_html__('Popup Title', 'helpmate'), 
                            'default' => esc_html__('Call Us today to schedule yours.', 'helpmate')
                        ),
                        array(
                            'id' => 'popup-description-4',
                            'type' => 'editor',
                            'title' => esc_html__('Popup Description', 'helpmate'),
                            'default' => wp_kses(__('Free In-House Site Inspections <br>to help you build your dream backyard.', 'helpmate'),array('br'=>array()))
                        ),
                        array(
                            'id' => 'popup-btn-4',
                            'type' => 'text',
                            'title' => esc_html__('Popup Button', 'helpmate'),
                            'default' => esc_html__('Contact Us', 'helpmate')
                        ),
                        array(
                            'id' => 'popup-link-4',
                            'type' => 'text',
                            'title' => esc_html__('Popup Button Link', 'helpmate'),
                            'default' => esc_html__('#', 'helpmate'),
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Popup 5', 'helpmate'),
                    'fields' => array( 
                        array(
                            'id' => 'popup-title-5',
                            'type' => 'editor',
                            'title' => esc_html__('Popup Title', 'helpmate'), 
                            'default' => wp_kses(__('Refer <span>a Friend</span> and You&rsquo;ll Both <span>Get $650</span>', 'helpmate'),array(
                                    'span' => array(),
                                ))
                        ),
                        array(
                            'id' => 'popup-description-5',
                            'type' => 'text',
                            'title' => esc_html__('Popup Description', 'helpmate'),
                            'default' => esc_html__('Everyone wins when you refer your friends & family to HelpMate.', 'helpmate')
                        ),
                        array(
                            'id' => 'popup-btn-5',
                            'type' => 'text',
                            'title' => esc_html__('Popup Button', 'helpmate'),
                            'default' => esc_html__('Learn More', 'helpmate')
                        ),
                        array(
                            'id' => 'popup-link-5',
                            'type' => 'text',
                            'title' => esc_html__('Popup Button Link', 'helpmate'),
                            'default' => esc_html__('#', 'helpmate'),
                        ),
                    )
                ),
                array(
                    'icon_class' => 'icon',
                    'subsection' => true,
                    'title' => esc_html__('Popup 6', 'helpmate'),
                    'fields' => array( 
                        array(
                            'id' => 'popup-title-6',
                            'type' => 'editor',
                            'title' => esc_html__('Popup Title', 'helpmate'), 
                            'default' => wp_kses(__('Refer <span>a Friend</span> and You&rsquo;ll Both <span>Get $650</span>', 'helpmate'),array(
                                    'span' => array(),
                                ))
                        ),
                        array(
                            'id' => 'popup-description-6',
                            'type' => 'text',
                            'title' => esc_html__('Popup Description', 'helpmate'),
                            'default' => esc_html__('Everyone wins when you refer your friends & family to HelpMate.', 'helpmate')
                        ),
                        array(
                            'id' => 'popup-btn-6',
                            'type' => 'text',
                            'title' => esc_html__('Popup Button', 'helpmate'),
                            'default' => esc_html__('Learn More', 'helpmate')
                        ),
                        array(
                            'id' => 'popup-link-6',
                            'type' => 'text',
                            'title' => esc_html__('Popup Button Link', 'helpmate'),
                            'default' => esc_html__('#', 'helpmate'),
                        ),
                    )
                ),
            );
            return $sections;
        }

        protected function helpmate_add_header_section_options() {
            $header = array(
                'icon' => 'el-icon-website',
                'icon_class' => 'icon',
                'title' => esc_html__('Header', 'helpmate'),
                'fields' => array(
                    array(
                        'id' => 'header-type',
                        'type' => 'image_select',
                        'title' => esc_html__('Header Type', 'helpmate'),
                        'options' => $this->helpmate_header_types(),
                        'default' => '6'
                    ),
                    array(
                        'id' => 'logo3',
                        'type' => 'media',
                        'url' => true,
                        'readonly' => false,
                        'title' => esc_html__('Logo header 3', 'helpmate'),
                        'required' => array('header-type', 'equals', 3,),
                        'default' => array(
                            'url' => get_template_directory_uri() . '/images/logo3.png',
                            'height' => 57,
                            'wide' => 227
                        )
                    ),
                    array(
                        'id' => 'logo4',
                        'type' => 'media',
                        'url' => true,
                        'readonly' => false,
                        'title' => esc_html__('Logo header 4', 'helpmate'),
                        'required' => array('header-type', 'equals', 4,),
                        'default' => array(
                            'url' => get_template_directory_uri() . '/images/logo4.png',
                            'height' => 82,
                            'wide' => 277
                        )
                    ),
                    array(
                        'id' => 'logo5',
                        'type' => 'media',
                        'url' => true,
                        'readonly' => false,
                        'title' => esc_html__('Logo header 5', 'helpmate'),
                        'required' => array('header-type', 'equals', 5,),
                        'default' => array(
                            'url' => get_template_directory_uri() . '/images/logo5.png',
                            'height' => 57,
                            'wide' => 227
                        )
                    ),    
                    array(
                        'id' => 'logo6',
                        'type' => 'media',
                        'url' => true,
                        'readonly' => false,
                        'title' => esc_html__('Logo header 6', 'helpmate'),
                        'required' => array('header-type', 'equals', 6,),
                        'default' => array(
                            'url' => get_template_directory_uri() . '/images/logo6.png',
                            'height' => 57,
                            'wide' => 227
                        )
                    ),                                     
                    array(
                        'id' => '1',
                        'type' => 'info',
                        'desc' => esc_html__('Contacts', 'helpmate')
                    ),
                    array(
                        'id' => 'header-top',
                        'type' => 'switch',
                        'title' => esc_html__('Show Header Top', 'helpmate'),
                        'default' => true
                    ),
                    array(
                        'id' => 'header-contact-location',
                        'type' => 'text',
                        'title' => esc_html__('Location', 'helpmate'),
                        'default' => esc_html__('Brooklyn, NY 10036, United States', 'helpmate'),
                        'placeholder' => esc_html__('Location','helpmate'),
                        'required' => array(
                            array('header-type', 'equals', array(
                                '1',
                                '2',
                                '3',
                                '5',
                                )
                            ),
                            array('header-top','equals', true)

                        ),                        
                    ),
                    array(
                        'id' => 'header-contact-phonenumber',
                        'type' => 'text',
                        'title' => esc_html__('Phone number', 'helpmate'),
                        'default' => esc_html__('(+84)1234-5678', 'helpmate'),
                        'placeholder' => esc_html__('Phone number', 'helpmate'),
                        'required' => array(
                            array('header-type', 'equals', array(
                                '1',
                                '2',
                                '3',
                                '4',
                                '5',
                                )
                            ),
                            array('header-top','equals', true)

                        ),    
                    ),
                    array(
                        'id' => 'header-contact-email',
                        'type' => 'text',
                        'title' => esc_html__('Email', 'helpmate'),
                        'default' => esc_html__('contact@contractorsupport.com', 'helpmate'),
                        'placeholder' => esc_html__('Contact Email', 'helpmate'),
                        'required' => array(
                            array('header-type', 'equals', array(
                                '1',
                                '2',
                                '3',
                                '5',
                                )
                            ),
                            array('header-top','equals', true)

                        ),   
                    ),
                    array(
                        'id' => 'header-contact-time',
                        'type' => 'text',
                        'title' => esc_html__('Working time', 'helpmate'),
                        'default' => esc_html__('Mon-Fri: 8:30am - 5:30pm, Sat-Sun: 9:00am - 12:00pm', 'helpmate'),
                        'required' => array(
                            array('header-type', 'equals', array(
                                '1',
                                '2',
                                )
                            ),
                            array('header-top','equals', true)

                        ),   
                        'placeholder' => esc_html__('Working time', 'helpmate'),
                    ),
                    array(
                        'id' => 'header-contact-time3',
                        'type' => 'text',
                        'title' => esc_html__('Working time', 'helpmate'),
                        'default' => esc_html__('Mon-Sat: 8:30am- 5:30pm', 'helpmate'),
                        'required' => array(
                            array('header-type', 'equals', array(
                                '3',
                                )
                            ),
                            array('header-top','equals', true)

                        ),   
                        'placeholder' => esc_html__('Working time', 'helpmate')
                    ),
                    array(
                        'id' => 'header-contact-phonenumber6',
                        'type' => 'text',
                        'title' => esc_html__('Phone number', 'helpmate'),
                        'default' => esc_html__('(+84)1234-5678', 'helpmate'),
                        'placeholder' => esc_html__('Phone number', 'helpmate'),
                        'required' => 
                            array('header-type', 'equals', array(
                                '6',
                                )
                            ),   
                    ),
                    array(
                        'id' => 'header-contact-email6',
                        'type' => 'text',
                        'title' => esc_html__('Email', 'helpmate'),
                        'default' => esc_html__('contact@contractorsupport.com', 'helpmate'),
                        'placeholder' => esc_html__('Contact Email', 'helpmate'),
                        'required' =>
                            array('header-type', 'equals', array(
                                '6',
                                )
                            ),
   
                    ),
                    array(
                        'id' => 'header-contact-time6',
                        'type' => 'text',
                        'title' => esc_html__('Working hours', 'helpmate'),
                        'default' => esc_html__('09:00am - 05:00pm', 'helpmate'),
                        'required' => array(
                            array('header-type', 'equals', array(
                                '6',
                                )
                            ),
                        ),   
                        'placeholder' => esc_html__('Working hours', 'helpmate'),
                    ),                    
                    array(
                        'id' => 'header-minicart',
                        'type' => 'switch',
                        'title' => esc_html__('Show Mini Cart', 'helpmate'),
                        'required' =>
                            array('header-type', 'equals', array(
                                '1',
                                '2',
                                '3',
                                '5',
                                '6',
                                )
                            ),

                        'default' => true
                    ),
                    array(
                        'id' => 'header-myaccount',
                        'type' => 'switch',
                        'title' => esc_html__('Show My Account', 'helpmate'),
                        'required' =>
                            array('header-type', 'equals', array(
                                '1',
                                '2',
                                '3',
                                '5',
                                )
                            ),

                        'default' => true
                    ),
                    array(
                        'id' => 'header-myaccount4',
                        'type' => 'switch',
                        'title' => esc_html__('Show My Account', 'helpmate'),
                        'required' =>
                            array('header-type', 'equals', array(
                                '4',
                                )
                            ),

                        'default' => false
                    ),
                    array(
                        'id' => 'header-quote',
                        'type' => 'switch',
                        'title' => esc_html__('Show free quote block in header', 'helpmate'),
                        'required' => array('header-type', 'equals', array(
                            '6',
                        )),
                        'default' => true
                    ), 
                    array(
                        'id' => 'header-quote-link',
                        'type' => 'text',
                        'title' => esc_html__('Enter link for free quote block', 'helpmate'),
                        'required' => array('header-type', 'equals', array(
                            '6',
                        )),
                        'default' => esc_html__('#', 'helpmate'),
                        'placeholder' => esc_html__('#', 'helpmate'),                       
                    ),   
                    array(
                        'id' => 'header-top-link',
                        'type' => 'switch',
                        'title' => esc_html__('Display header top links', 'helpmate'),
                        'required' => array('header-type', 'equals', array(
                            '6',
                        )),
                        'default' => true
                    ),                                      
                    array(
                        'id' => 'header-search',
                        'type' => 'switch',
                        'title' => esc_html__('Show Search', 'helpmate'),
                        'default' => true
                    ),
                    array(
                        'id' => 'header-social',
                        'type' => 'switch',
                        'title' => esc_html__('Show social links in header', 'helpmate'),
                        'required' => array('header-type', 'equals', array(
                            '3',
                            '4',
                            '6',
                        )),
                        'default' => true
                    ),
                    array(
                        'id' => 'header-sticky',
                        'type' => 'switch',
                        'title' => esc_html__('Enable sticky', 'helpmate'),
                        'default' => true
                    ),   
                    array(
                        'id' => 'header-sticky-mobile',
                        'type' => 'switch',
                        'required' => array('header-sticky', 'equals', 1,),
                        'title' => esc_html__('Enable sticky on mobile ', 'helpmate'),
                        'default' => true
                    ),                
                )
            );
            if (class_exists('WCML_CurrencySwitcher') && class_exists('Woocommerce')) {
                $header['fields'][] = array(
                    'id' => 'header-currency',
                    'type' => 'switch',
                    'title' => esc_html__('Show Currencies Switcher', 'helpmate'),
                    'default' => false
                );
            }
            global $sitepress;
            if (defined('ICL_LANGUAGE_CODE') && isset($sitepress)) {
                $header['fields'][] = array(
                    'id' => 'header-language',
                    'type' => 'switch',
                    'title' => esc_html__('Show Languages Switcher', 'helpmate'),
                    'default' => false
                );
            }
            return $header;
        }

        public function helpmate_get_setting_arguments() {
            $theme = wp_get_theme();
            $args = array(
                // TYPICAL -> Change these values as you need/desire
                'opt_name' => 'helpmate_settings',
                'display_name' => esc_html__('Helpmate', 'helpmate'),
                'display_version' => $theme->get('Version'),
                'menu_type' => 'menu',
                'allow_sub_menu' => true,
                'menu_title' => esc_html__('Helpmate', 'helpmate'),
                'page_title' => esc_html__('Helpmate', 'helpmate'),
                'google_api_key' => '',
                'google_update_weekly' => false,
                'async_typography' => true,
                'admin_bar' => true,
                'admin_bar_icon' => 'dashicons-admin-generic',
                'admin_bar_priority' => 50,
                'global_variable' => '',
                'dev_mode' => false,
                'update_notice' => true,
                'customizer' => true,
                'page_priority' => null,
                'page_parent' => 'themes.php',
                'page_permissions' => 'manage_options',
                'menu_icon' => '',
                'last_tab' => '',
                'page_icon' => 'icon-themes',
                'page_slug' => '',
                'save_defaults' => true,
                'default_show' => false,
                'default_mark' => '',
                'show_import_export' => true,
                'transient_time' => 60 * MINUTE_IN_SECONDS,
                'output' => true,
                'output_tag' => true,
                'database' => '',
                'use_cdn' => true,
                // HINTS
                'hints' => array(
                    'icon' => 'el el-question-sign',
                    'icon_position' => 'right',
                    'icon_color' => 'lightgray',
                    'icon_size' => 'normal',
                    'tip_style' => array(
                        'color' => 'red',
                        'shadow' => true,
                        'rounded' => false,
                        'style' => '',
                    ),
                    'tip_position' => array(
                        'my' => 'top left',
                        'at' => 'bottom right',
                    ),
                    'tip_effect' => array(
                        'show' => array(
                            'effect' => 'slide',
                            'duration' => '500',
                            'event' => 'mouseover',
                        ),
                        'hide' => array(
                            'effect' => 'slide',
                            'duration' => '500',
                            'event' => 'click mouseleave',
                        ),
                    ),
                )
            );
            return $args;
        }

        protected function helpmate_header_types() {
            return array(
                '1' => array('alt' => esc_html__('Header Type 1', 'helpmate'), 'img' => get_template_directory_uri() . '/inc/admin/settings/headers/header-1.jpg'),
                '2' => array('alt' => esc_html__('Header Type 2', 'helpmate'), 'img' => get_template_directory_uri() . '/inc/admin/settings/headers/header-2.jpg'),
                '3' => array('alt' => esc_html__('Header Type 3', 'helpmate'), 'img' => get_template_directory_uri() . '/inc/admin/settings/headers/header-3.jpg'),
                '4' => array('alt' => esc_html__('Header Type 4', 'helpmate'), 'img' => get_template_directory_uri() . '/inc/admin/settings/headers/header-4.jpg'),
                '5' => array('alt' => esc_html__('Header Type 5', 'helpmate'), 'img' => get_template_directory_uri() . '/inc/admin/settings/headers/header-5.jpg'),
                '6' => array('alt' => esc_html__('Header Type 6', 'helpmate'), 'img' => get_template_directory_uri() . '/inc/admin/settings/headers/header-6.jpg'),
            );
        }

        protected function helpmate_footer_types() {
            return array(
                '1' => array('alt' => esc_html__('Footer Type 1', 'helpmate'), 'img' => get_template_directory_uri() . '/inc/admin/settings/footers/footer-1.jpg'),
                '2' => array('alt' => esc_html__('Footer Type 2', 'helpmate'), 'img' => get_template_directory_uri() . '/inc/admin/settings/footers/footer-2.jpg'),
                '3' => array('alt' => esc_html__('Footer Type 3', 'helpmate'), 'img' => get_template_directory_uri() . '/inc/admin/settings/footers/footer-3.jpg'),
                '4' => array('alt' => esc_html__('Footer Type 4', 'helpmate'), 'img' => get_template_directory_uri() . '/inc/admin/settings/footers/footer-4.jpg'),
                '5' => array('alt' => esc_html__('Footer Type 5', 'helpmate'), 'img' => get_template_directory_uri() . '/inc/admin/settings/footers/footer-5.jpg'),
                '6' => array('alt' => esc_html__('Footer Type 6', 'helpmate'), 'img' => get_template_directory_uri() . '/inc/admin/settings/footers/footer-6.jpg'),
            );
        }

    }

    
    function helpmate_get_framework_settings() {
        global $helpmateReduxSettings;
        $helpmateReduxSettings = new Framework_Helpmate_Settings();
        return $helpmateReduxSettings;
    }
    helpmate_get_framework_settings();
}