<?php
require_once(helpmate_functions . '/vc_functions.php');
require_once(helpmate_functions . '/sidebars.php');
require_once(helpmate_functions . '/layout.php');
require_once(helpmate_functions . '/menus.php');
require_once(helpmate_functions . '/gallery_like_count.php');
require_once(helpmate_functions . '/helpmate_popup.php');
if (class_exists('Woocommerce')) {
    require_once(helpmate_functions . '/woocommerce.php');
    require_once(helpmate_functions . '/widgets/helpmate_override_woocommerce.php');
}
require_once(helpmate_functions . '/wpml.php');
require_once(helpmate_functions . '/widgets/helpmate_recent_posts.php');
require_once(helpmate_functions . '/widgets/helpmate_recent_work.php');
require_once(helpmate_functions . '/widgets/helpmate_tabs.php');
require_once(helpmate_functions . '/panel-social/functions.php');
add_filter( 'widget_text', 'do_shortcode', 11);
//search filter
if ( !is_admin() ) {
    function helpmate_searchfilter($query) {
        if ($query->is_search && !is_admin() && $query->get( 'post_type' ) != 'kbe_knowledgebase' && $query->get( 'post_type' ) != 'product') {
        $query->set('post_type',array('post','recipe'));
        }
        return $query;
    }
    add_filter('pre_get_posts','helpmate_searchfilter');
}
//back to top
add_action( 'wp_footer', 'helpmate_back_to_top' );
function helpmate_back_to_top() {
echo '<button class="go-to-top" id="go-to-top"></button>';
}
function helpmate_add_slug_body_class( $classes ) {
    global $post, $helpmate_settings;
    $main_layout = get_post_meta(get_the_ID(),'main_layout', true);
    if($main_layout =="default") {
        $main_layout = isset($helpmate_settings['main_layout']) ? $helpmate_settings['main_layout'] :"";
    } 

    if ( isset( $post ) ) {
    $classes[] = $main_layout;
    }
    if ( isset( $post ) ) {
    $classes[] = $post->post_type . '-' . $post->post_name;
    }
    $mad_elements = '';
    if(( is_front_page() && is_home()) || is_front_page() || is_page('home-1') || is_page('home-2') || is_page('home-3') || is_page('home-4')|| is_page('home-5') || is_page('home-6') || is_page('home')){
       $mad_elements =  '';
    }else{
       $mad_elements =  ' mad_elements';
    }
    $classes[] = $mad_elements;
    return $classes;
}
add_filter( 'body_class', 'helpmate_add_slug_body_class' );

function helpmate_allow_html(){
    return array(
        'form'=>array(
            'role' => array(),
            'method'=> array(),
            'class'=> array(),
            'action'=>array(),
            'id'=>array(),
            ),
        'input' => array(
            'type' => array(),
            'name'=> array(),
            'class'=> array(),
            'title'=>array(),
            'id'=>array(), 
            'value'=> array(), 
            'placeholder'=>array(), 
            'autocomplete' => array(),
            'data-number' => array(),
            'data-keypress' => array(),                        
            ),
        'button' => array(
            'type' => array(),
            'name'=> array(),
            'class'=> array(),
            'title'=>array(),
            'id'=>array(),                            
            ),                        
        'div'=>array(
            'class'=> array(),
            ),
        'h4'=>array(
            'class'=> array(),
            ),
        'a'=>array(
            'class'=> array(),
            'href'=>array(),
            'onclick' => array(),
            'aria-expanded' => array(),
            'aria-haspopup' => array(),
            'data-toggle' => array(),
            ),
        'i' => array(
            'class'=> array(),
        ),
        'p' => array(
            'class'=> array(),
        ), 
        'span' => array(
            'class'=> array(),
            'onclick' => array(),
            'style' => array(),
        ), 
        'strong' => array(
            'class'=> array(),
        ),  
        'ul' => array(
            'class'=> array(),
        ),  
        'li' => array(
            'class'=> array(),
        ), 
        'del' => array(),
        'ins' => array(),

    );
}
function helpmate_set_post_views($postID) {
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    }else{
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
function helpmate_track_post_views ($post_id) {
    if ( !is_single() ) return;
    if ( empty ( $post_id) ) {
        global $post;
        $post_id = $post->ID;    
    }
    helpmate_set_post_views($post_id);
}
add_action( 'wp_head', 'helpmate_track_post_views');
// function to display number of posts.
function helpmate_get_post_views($postID){
    $count_key = 'post_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if($count==''){
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
        return '0';
    }
    return $count;
}
function helpmate_get_attachment( $attachment_id, $size = 'full' ) {
    if (!$attachment_id)
        return false;
    $attachment = get_post( $attachment_id );
    $image = wp_get_attachment_image_src($attachment_id, $size);

    if (!$attachment)
        return false;

    return array(
        'alt' => esc_attr(get_post_meta( $attachment->ID, '_wp_attachment_image_alt', true )),
        'caption' => esc_attr($attachment->post_excerpt),
        'description' => force_balance_tags($attachment->post_content),
        'href' => get_permalink( $attachment->ID ),
        'src' => esc_url($image[0]),
        'title' => esc_attr($attachment->post_title),
        'width' => esc_attr($image[1]),
        'height' => esc_attr($image[2])
    );
}
function helpmate_pagination($max_num_pages = null) {
    global $wp_query, $wp_rewrite;

    $max_num_pages = ($max_num_pages) ? $max_num_pages : $wp_query->max_num_pages;

    // Don't print empty markup if there's only one page.
    if ($max_num_pages < 2) {
        return;
    }

    $paged = get_query_var('paged') ? intval(get_query_var('paged')) : 1;
    $pagenum_link = html_entity_decode(get_pagenum_link());
    $query_args = array();
    $url_parts = explode('?', $pagenum_link);

    if (isset($url_parts[1])) {
        wp_parse_str($url_parts[1], $query_args);
    }

    $pagenum_link = remove_query_arg(array_keys($query_args), $pagenum_link);
    $pagenum_link = trailingslashit($pagenum_link) . '%_%';

    $format = $wp_rewrite->using_index_permalinks() && !strpos($pagenum_link, 'index.php') ? 'index.php/' : '';
    $format .= $wp_rewrite->using_permalinks() ? user_trailingslashit($wp_rewrite->pagination_base . '/%#%', 'paged') : '?paged=%#%';

    // Set up paginated links.
    $links = paginate_links(array(
        'base' => $pagenum_link,
        'format' => $format,
        'total' => $max_num_pages,
        'current' => $paged,
        'end_size' => 1,
        'mid_size' => 1,
        'prev_next' => false,
        'prev_text' => '',
        'next_text' => '',
        'type' => 'list'
            ));

    if ($links) :
        ?>
            <?php echo wp_kses($links,helpmate_allow_html()) ?>        
        <?php
    endif;
}
// Changing excerpt more
function helpmate_excerpt_more($more) {
    return '.';
}
add_filter('excerpt_more', 'helpmate_excerpt_more');
function helpmate_comment_nav() {
    if (get_comment_pages_count() > 1 && get_option('page_comments')) :
        ?>
        <nav class="navigation comment-navigation" role="navigation">
            <div class="comment-nav-links">
        <?php
        if ($prev_link = get_previous_comments_link(__('Older', 'helpmate'))) :
            printf('<div class="comment-nav-previous">%s</div>', $prev_link);
        endif;

        if ($next_link = get_next_comments_link(__('Newer', 'helpmate'))) :
            printf('<div class="comment-nav-next">%s</div>', $next_link);
        endif;
        ?>
            </div>
        </nav>
        <?php
    endif;
}
function helpmate_comment_body_template($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;
    extract($args, EXTR_SKIP);

    if ('div' == $args['style']) {
        $tag = 'div';
        $add_below = 'comment';
    } else {
        $tag = 'li';
        $add_below = 'div-comment';
    }
    ?>
    <<?php echo esc_html($tag) ?> <?php comment_class(empty($args['has_children']) ? 'post_news ' : 'parent post_news' ) ?> id="comment-<?php comment_ID() ?>">
    <?php if ('div' != $args['style']) : ?>
        <div id="div-comment-<?php comment_ID() ?>" class="comment-body">
    <?php endif; ?>
        <div class="review_post comment_level_2">
            <div class="review_item clearfix">
                <figure>    
                <?php if ($args['avatar_size'] != 0) echo get_avatar($comment, $args['avatar_size']); ?>   
                </figure>
                <div class="review_text clearfix">
                    <h6 class="f_left"><?php printf(esc_html__('%s','helpmate'), get_comment_author_link()); ?> - <?php
                    printf(esc_html__('%1$s', 'helpmate'), get_comment_date());
                    ?><?php edit_comment_link(esc_html__('Edit', 'helpmate'), '  ', '');
                    ?></h6>
                     <?php comment_reply_link(array_merge($args, array('reply_text'=>esc_html__('Reply', 'helpmate'),'add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))); ?>
                  </div> 
            </div>
            <?php if ($comment->comment_approved == '0') : ?>
                <em class="comment-awaiting-moderation"><?php echo esc_html__('Your comment is awaiting moderation.', 'helpmate'); ?></em>
                <br />
            <?php endif; ?>
           <?php comment_text(); ?>

        </div>
        <?php if ('div' != $args['style']) : ?>
            </div>
        <?php endif; ?>
                <?php

}
add_filter('comment_reply_link', 'helpmate_reply_link_class');
function helpmate_reply_link_class($class){
    $class = str_replace("class='comment-reply-link", "class='f_right", $class);
    return $class;
}
add_filter('wp_list_categories', 'helpmate_cat_count_span');
function helpmate_cat_count_span($links) {
    $links = str_replace('</a> (', ' (', $links);
    $links = str_replace(')', ')</a>', $links);
    return $links;
}
function helpmate_move_comment_field_to_bottom( $fields ) {
    $comment_field = $fields['comment'];
    unset( $fields['comment'] );
    $fields['comment'] = $comment_field;
    return $fields;
}
add_filter( 'comment_form_fields', 'helpmate_move_comment_field_to_bottom' );
function helpmate_get_post_media(){
    $media_type = get_post_meta(get_the_ID(), 'media_type', true); 
    $gallery = get_post_meta(get_the_ID(), 'images_gallery', true);
    ?> 
    <?php if ( get_post_format() == 'video' ||  get_post_format() == 'audio') : ?>
        <div class="align_center">
            <div class="blog-video">
                <?php $video = get_post_meta(get_the_ID(), 'video_code', true); ?>
                <?php if ($video && $video != ''): ?>
                    <?php if(get_post_format() == 'video'){
                        echo '<div class="iframe_video_container">';
                    }
                    ?>                    
                        <?php if (strpos($video,'iframe') !== false):?>
                            <?php echo wp_kses($video,array(
                              'iframe' => array(
                                'height' => array(),
                                'frameborder' => array(),
                                'style' => array(),
                                'src' => array(),
                                'allowfullscreen' => array(),
                                )
                            )); ?>  
                        <?php else: ?>
                            <iframe src="<?php echo esc_url(is_ssl() ? str_replace( 'http://', 'https://', $video ) : $video); ?> " <?php if(get_post_format() == 'video'){echo 'height="400"';}?>></iframe>
                        <?php endif;?>
                    <?php if(get_post_format() == 'video'){
                        echo '</div>';
                    }
                    ?> 
                <?php endif; ?>
            </div>
        </div>
    <?php elseif(has_post_format('gallery')): ?>
        <?php if (is_array($gallery) && count($gallery) > 1) : ?>
            <div class="carousel_type_4">
                <div class="owl-carousel" data-max-items="1">               
                        <?php
                        $index = 0;
                        foreach ($gallery as $key => $value) :
                            $image_large = wp_get_attachment_image_src($value, 'full');
                            $alt = get_post_meta($value, '_wp_attachment_image_alt', true);
                            echo '  <div> 
                                        <div class="item_wrapper">
                                            <figure class="item_img">
                                                <img src="' . esc_url($image_large[0]) . '" alt="' . esc_attr($alt) . '" />
                                            </figure>
                                        </div>
                                     </div>';
                            $index++;
                        endforeach;
                        ?>
                </div>
            </div>
        <?php else: ?>
            <?php if (has_post_thumbnail()): ?>
                <figure>
                    <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail();?></a>
                </figure>
            <?php endif;?>
        <?php endif; ?>
    <?php elseif(has_post_format('link')):?>
        <?php 
            $link = get_post_meta(get_the_ID(), 'link_code', true); 
            $link_title = get_post_meta(get_the_ID(), 'link_title', true);
        ?>
        <?php if($link && $link != ''):?>
            <figure>
                <a class="post_link" href="<?php echo esc_url(is_ssl() ? str_replace( 'http://', 'https://', $link ) : $link);?>">
                    <div class="icon_link"></div>
                    <?php if($link_title && $link_title != ''):?>
                        <span><?php echo wp_kses($link_title,array());?></span>
                    <?php endif;?> 
                </a>
            </figure>
        <?php endif;?>
    <?php elseif(has_post_format('quote')):?>
        <?php 
            $quote = get_post_meta(get_the_ID(), 'quote_code', true); 
            $quote_author = get_post_meta(get_the_ID(), 'quote_author', true); 
        ?>
        <?php if($quote && $quote != ''):?>
            <figure>
                <div class="quote_section">
                    <blockquote class="var3">
                        <?php echo wp_kses($quote,array());?>
                    </blockquote>
                    <?php if($quote_author && $quote_author != ''):?>
                        <div class="author_info">- <?php echo  wp_kses($quote_author,array());?></div>
                    <?php endif;?> 
                </div>
            </figure>
        <?php endif;?>    
    <?php else: ?>
        <?php if (has_post_thumbnail()): ?>
            <figure>
                <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail();?></a>
            </figure>
        <?php endif;?>
    <?php endif; 
}
function helpmate_maintenance_mode(){
    global $helpmate_settings;
    if(isset($helpmate_settings['under-contr-mode']) && $helpmate_settings['under-contr-mode'] ==1){
        if(!current_user_can('edit_themes') || !is_user_logged_in()){
            wp_die(get_template_part('comming-soon'));
        }
    }
}
add_action('get_header', 'helpmate_maintenance_mode');

function helpmate_get_banner_block(){
    global $post, $helpmate_settings;
    $static = "";  
    if(is_404()){
        $static =  isset($helpmate_settings['banner_block_general'])? $helpmate_settings['banner_block_general'] :"";
    }
    if( !is_404()  && !is_search()  && is_page() && (get_post_meta($post->ID,'block_bottom',true) != 'default')){
        $static = get_post_meta($post->ID,'block_bottom',true) != "" ? get_post_meta($post->ID,'block_bottom',true) :"";
    }else if(isset($helpmate_settings['banner_block_general']) && $helpmate_settings['banner_block_general'] != ''){
        $static = $helpmate_settings['banner_block_general'];
    }
    if($static != ''){      
        $block = get_post($static);
        $post_content = $block->post_content;
        $shortcodes_custom_css = get_post_meta( $static, '_wpb_shortcodes_custom_css', true );
        if ( ! empty( $shortcodes_custom_css ) ) {
            $output = '<style type="text/css" data-type="vc_shortcodes-custom-css">';
            $output .= $shortcodes_custom_css;
            $output .= '</style>';
            echo ($output);
        }
        $hide_static = helpmate_get_meta_value('hide_static', true);
        if (( is_front_page() && is_home()) || is_front_page() ) {
            $hide_static = false;
        }
        if($hide_static){
            echo apply_filters('the_content', get_post_field('post_content', $static));
        }
    }
}
function helpmate_get_fb_share($url) {
    if (class_exists('ReduxFramework')) {
    global $helpmateReduxSettings;

    $reduxFramework = $helpmateReduxSettings->ReduxFramework;
      // $json_string = file_get_contents('http://graph.facebook.com/?ids=' . $url);
    $json_string = $reduxFramework->filesystem->execute( 
        'get_contents', 
        'http://graph.facebook.com/?ids=' . $url
    );
      $json = json_decode($json_string, true);
      if(isset($json[$url]['shares'])){
      return intval( $json[$url]['shares'] );
        }else{
            return 0;
        }
    }else{
        return 0;
    }
}
function helpmate_get_pinterest_share($url) {
    if (class_exists('ReduxFramework')) {
    global $helpmateReduxSettings;

    $reduxFramework = $helpmateReduxSettings->ReduxFramework;
      // $json_string = file_get_contents('http://graph.facebook.com/?ids=' . $url);
    $api = $reduxFramework->filesystem->execute( 
        'get_contents', 
        'http://api.pinterest.com/v1/urls/count.json?callback%20&url=' . $url
    );
    $body = preg_replace( '/^receiveCount\((.*)\)$/', '\\1', $api );
    $count = json_decode( $body );
    return ' '.$count->count;
    }else{
        return 0;
    }
}
function helpmate_get_twitter_share($url) {
    if (class_exists('ReduxFramework')) {
    global $helpmateReduxSettings;

    $reduxFramework = $helpmateReduxSettings->ReduxFramework;
      // $json_string = file_get_contents('http://graph.facebook.com/?ids=' . $url);
    $api = $reduxFramework->filesystem->execute( 
        'get_contents', 
        'http://opensharecount.com/count.json?url=' . $url
    );
    $count = json_decode( $api );
    return ' '.$count->count;
    }
}
function helpmate_update_wishlist_count(){
    if( function_exists( 'YITH_WCWL' ) ){
        wp_send_json( YITH_WCWL()->count_products() );
    }
}
add_action( 'wp_ajax_update_wishlist_count', 'helpmate_update_wishlist_count' );
add_action( 'wp_ajax_nopriv_update_wishlist_count', 'helpmate_update_wishlist_count' );
add_filter( 'wp_calculate_image_srcset_meta', '__return_null' );


?>
