<?php    
//get search template
function helpmate_get_search_form() {
    if(class_exists( 'WooCommerce' )) {
        $template = get_product_search_form(false);
    }
    $output = '';
    ob_start();
    ?>
        <button class="search_button"></button>
        <div class="searchform_wrap">
            <div class="vc_child h_inherit relative">
                <h5><?php echo esc_html__('start typing and press enter to search','helpmate');?></h5>
                <?php if(class_exists( 'WooCommerce' )):?>
                    <?php echo wp_kses($template,array(
                        'form'=>array(
                            'role' => array(),
                            'method'=> array(),
                            'class'=> array(),
                            'action'=>array(),
                            'id'=>array(),
                            ),
                        'input' => array(
                            'type' => array(),
                            'name'=> array(),
                            'class'=> array(),
                            'title'=>array(),
                            'id'=>array(), 
                            'value'=> array(), 
                            'placeholder'=>array(),                          
                            ),
                        'button' => array(
                            'type' => array(),
                            'name'=> array(),
                            'class'=> array(),
                            'title'=>array(),
                            'id'=>array(),                            
                            ),                        
                        'div'=>array(
                            'class'=> array(),
                            ),
                        'h5'=>array(
                            'class'=> array(),
                            ),
                        )); ?>
                <?php else:?>
                    <?php  helpmate_search_form();?>
                <?php endif;?>
            </div>
            <a href="" class="close_search_form"></a>
        </div>
    <?php
    $output .= ob_get_clean();
    return $output;
}
//mini cart template
if ( class_exists( 'WooCommerce' ) ) {
    function helpmate_get_helpmate_minicart_template() {
        $cart_item_count = WC()->cart->cart_contents_count;
        $helpmate_header_type = helpmate_get_header_type();
        $output = '';
        ob_start();
        ?>
            <button class="shop_button"></button>
            <p class="number-product"><?php echo esc_html($cart_item_count); ?></p>   
            <div class="shopping_cart">
                <div class="widget_shopping_cart_content products_list">
                </div>
            </div>
        <?php
        $output .= ob_get_clean();
        return $output;
    }
}
function helpmate_search_form(){
    ?>
    <form role="search" method="get" class="woocommerce-product-search product-search" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
        <input type="search" id="woocommerce-product-search-field" class="search-field" value="<?php echo get_search_query(); ?>" name="s" title="<?php echo esc_attr_x( 'Search for:', 'label', 'helpmate' ); ?>" />
        <button type="submit" class="submit btn-search">
            
        </button>
        <input type="hidden" name="post_type" value="post" />
    </form>
<?php
}
// top link myaccout
function helpmate_myaccount_toplinks() {
    $wishlist = false;
    if(class_exists('YITH_WCWL')) {
        $wishlist = true;
    }
    $myaccount_page_id = get_option( 'woocommerce_myaccount_page_id' ); 
    $logout_url = wp_logout_url('my-account');
    $output = '';
    ob_start();
    ?>
    <ul>
        <li class="dib customlinks">
            <a class="current-open" onclick="toggleFilter(this);" href="javascript:void(0);">
                <i class="fa fa-gear"></i>
            </a>
            <div class="dib header-profile dropdown-menu content-filter">
                    <ul>
                        <li><a href="<?php echo get_permalink( $myaccount_page_id ); ?>"><?php echo esc_html__('My Account', 'helpmate') ?></a></li>
                        <?php if($wishlist): ?>
                        <li><a class="update-wishlist" href="<?php echo YITH_WCWL()->get_wishlist_url(); ?>"><?php echo esc_html__('Wishlist', 'helpmate') ?> <span>(<?php echo yith_wcwl_count_products(); ?>)</span></a></li>
                        <?php endif; ?>
                        <?php if (class_exists( 'YITH_WOOCOMPARE' ) ) :?>
                        <li>
                            <?php
                                helpmate_compare_toplink();
                            ?>
                        </li>
                        <?php endif;?>
                        <?php if ( !is_user_logged_in() ) :?>
                        <li><a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>" title="<?php echo esc_attr__('Login / Register','helpmate'); ?>"><?php echo esc_html__('Login / Register','helpmate'); ?></a></li>
                        <?php else :?>
                        <li><a href="<?php echo esc_url($logout_url); ?>"><?php echo esc_html__('Logout', 'helpmate') ?></a></li>
                        <?php endif; ?>
                    </ul>
            </div>
        </li>
    </ul>    
   <?php
   $output .= ob_get_clean();
    return $output;
}
function helpmate_get_layout() {
    global $wp_query, $helpmate_settings, $helpmate_layout;
    $result = '';
    if (empty($helpmate_layout)) {
        $result = isset($helpmate_settings['layout']) ? $helpmate_settings['layout'] : 'fullwidth';
        if (is_404()) {
            $result = 'fullwidth';
        } else if (is_category()) {
            $result = $helpmate_settings['post-layout'];
        } else if (is_archive()) {
            if (function_exists('is_shop') && is_shop()) {
                $shop_layout = get_post_meta(wc_get_page_id('shop'), 'layout', true);
                $result = !empty($shop_layout) && $shop_layout != 'default' ? $shop_layout : $helpmate_settings['shop-layout'];
            } else {
                if (is_post_type_archive('gallery')) {
                    $result = $helpmate_settings['gallery-layout'];
                } 
                else if(is_post_type_archive('recipe')){
                    $result = $helpmate_settings['recipe-layout']; 
                }
                else if(is_post_type_archive('pressmedia')){
                    $result = $helpmate_settings['pressmedia-layout']; 
                }
                else {
                    $term = get_term_by('slug', get_query_var('term'), get_query_var('taxonomy'));
                    if ($term) {
                        $tax_layout = get_metadata($term->taxonomy, $term->term_id, 'layout', true);
                        switch ($term->taxonomy) {
                            case 'product_cat':
                                if(!empty($tax_layout) && $tax_layout != 'default') {
                                    $result = $tax_layout;
                                } else {
                                    $result = $helpmate_settings['shop-layout'];
                                }
                                break;
                            case 'product_tag':
                                $result = $helpmate_settings['shop-layout'];
                                break;
                            case 'gallery_cat':
                                $result = $helpmate_settings['gallery-layout'];
                                break;
                            case 'recipe_cat':
                                $result = $helpmate_settings['recipe-layout'];
                                break;
                            case 'pressmedia_cat':
                                $result = $helpmate_settings['pressmedia-layout'];
                                break;        
                            case 'gallery':
                                $result = $helpmate_settings['post-layout'];
                                break;
                            default:
                                $result = $helpmate_settings['layout'];
                        }
                    }
                }
            }
        } else {
            if (is_singular()) {
                $single_layout = get_post_meta(get_the_id(), 'layout', true);
                if (!empty($single_layout) && $single_layout != 'default') {
                    $result = $single_layout;
                } else {
                    switch (get_post_type()) {
                        case 'gallery':
                            $result = $helpmate_settings['gallery-layout'];
                            break;
                        case 'recipe':
                            $result = $helpmate_settings['recipe-layout'];
                            break;
                        case 'pressmedia':
                            $result = $helpmate_settings['pressmedia-layout'];
                            break;
                        case 'product':
                            $result = $helpmate_settings['single-product-layout'];
                            break;
                        case 'post':
                            $result = $helpmate_settings['post-layout'];
                            break;
                        default:
                            $result = $helpmate_settings['layout'];
                    }
                }
            } else {
                if (is_home() && !is_front_page()) {
                    $result = $helpmate_settings['post-layout'];
                }
            }
        }
        $helpmate_layout = $result;
    }    
    return $helpmate_layout;
}
//get global sidebar position
function helpmate_get_sidebar_position() {
    $result = '';
    global $wp_query, $helpmate_settings, $helpmate_sidebar_pos;
    if(empty($helpmate_sidebar_pos)){
        $result = isset($helpmate_settings['sidebar-position']) ? $helpmate_settings['sidebar-position'] : 'none';
        if (is_404()) {
            $result = 'none';
        } else if (is_category()) {
            $cat = $wp_query->get_queried_object();
            $cat_sidebar = get_metadata('category', $cat->term_id, 'sidebar_position', true);
            if (!empty($cat_sidebar) && $cat_sidebar != 'default') {
                    $result = $cat_sidebar;
                }
            else{   
                $result = $helpmate_settings['post-sidebar-position'];
            }
        } else if (is_archive()) {
            if (function_exists('is_shop') && is_shop()) {
                $shop_sidebar_position = get_post_meta(wc_get_page_id('shop'), 'sidebar_position', true);
                $result = !empty($shop_sidebar_position) && $shop_sidebar_position != 'default' ? $shop_sidebar_position : $helpmate_settings['shop-sidebar-position'];
            } else {
                if (is_post_type_archive('gallery')) {
                    if(isset($helpmate_settings['gallery-sidebar-position'])){
                        $result = $helpmate_settings['gallery-sidebar-position'];
                    }else{
                        $result = $helpmate_settings['sidebar-position'];
                    }
                }else if(is_post_type_archive('recipe')){
                    if(isset($helpmate_settings['recipe-sidebar-position'])){
                        $result = $helpmate_settings['recipe-sidebar-position'];                        
                    }else{
                        $result = $helpmate_settings['sidebar-position'];
                    }
                }else if(is_post_type_archive('pressmedia')){
                    if(isset($helpmate_settings['press-sidebar-position'])){
                        $result = $helpmate_settings['press-sidebar-position'];                        
                    }else{
                        $result = $helpmate_settings['sidebar-position'];
                    }
                }
                else {
                    $term = get_term_by('slug', get_query_var('term'), get_query_var('taxonomy'));
                    if ($term) {
                        $tax_sidebar_pos = get_metadata($term->taxonomy, $term->term_id, 'sidebar_position', true);
                        switch ($term->taxonomy) {
                            case 'product_cat':
                                if(!empty($tax_sidebar_pos) && $tax_sidebar_pos != 'default') {
                                    $result = $tax_sidebar_pos;
                                } else {
                                    $result = $helpmate_settings['shop-sidebar-position'];
                                }
                                break;
                            case 'product_tag':
                                $result = $helpmate_settings['shop-sidebar-position'];
                                break;
                            case 'gallery_cat':
                                $result = $helpmate_settings['gallery-sidebar-position'];
                                break;
                            case 'recipe_cat':
                                $result = $helpmate_settings['recipe-sidebar-position'];
                                break;
                            case 'pressmedia_cat':
                                $result = $helpmate_settings['press-sidebar-position'];
                                break;
                            case 'recipe_tag':
                                $result = $helpmate_settings['recipe-sidebar-position'];
                                break;
                            case 'category':
                                if(!empty($tax_sidebar_pos) && $tax_sidebar_pos != 'default') {
                                    $result = $tax_sidebar_pos;
                                } else {
                                    $result = $helpmate_settings['post-sidebar-position'];
                                }
                                break;
                            case 'tag':
                                    $result = $helpmate_settings['post-sidebar-position'];
                                break; 
                            default:
                                $result = $helpmate_settings['sidebar-position'];
                        }
                    }
                }
            }
        } else {
            if (is_singular()) {
                $single_sidebar_position = get_post_meta(get_the_id(), 'sidebar_position', true);
                if (!empty($single_sidebar_position) && $single_sidebar_position != 'default') {
                    $result = $single_sidebar_position;
                } else {
                    switch (get_post_type()) {
                        case 'gallery':
                            $result = $helpmate_settings['gallery-sidebar-position'];
                            break;
                        case 'product':
                            $prd_sidebar_pos = get_post_meta(get_the_id(), 'sidebar_position', true);
                            if(!empty($prd_sidebar_pos) && $prd_sidebar_pos != 'default') {
                                $result = $prd_sidebar_pos;
                            } else {
                                $result = $helpmate_settings['single-product-sidebar-position'];
                            }
                            break;
                        case 'recipe':
                            if(isset($helpmate_settings['recipe-sidebar-position'])){
                                $result = $helpmate_settings['recipe-sidebar-position'];
                            }else{
                                $result = $helpmate_settings['sidebar-position'];
                            }
                            break;
                        case 'pressmedia':
                            if(isset($helpmate_settings['press-sidebar-position'])){
                                $result = $helpmate_settings['press-sidebar-position'];
                            }else{
                                $result = $helpmate_settings['sidebar-position'];
                            }
                            break;    
                        case 'post':
                            $result = $helpmate_settings['post-sidebar-position'];
                            break;
                        default:
                            $result = $helpmate_settings['sidebar-position'];
                    }
                }
            } else {
                if (is_home() && !is_front_page()) {
                    $result = $helpmate_settings['post-sidebar-position'];
                }
            }
        }
        $helpmate_sidebar_pos = $result;
    }
    return $helpmate_sidebar_pos;
}

//get global sidebar
function helpmate_get_sidebar() {
    $result = '';
    global $wp_query, $helpmate_settings, $helpmate_sidebar;
    if(empty($helpmate_sidebar)){
        $result = isset($helpmate_settings['sidebar']) ? $helpmate_settings['sidebar'] : 'none';
        if (is_404()) {
            $result = 'none';
        } else if (is_category()) {
            $cat = $wp_query->get_queried_object();
            $cat_sidebar = get_metadata('category', $cat->term_id, 'sidebar', true);
            if (!empty($cat_sidebar) && $cat_sidebar != 'default') {
                    $result = $cat_sidebar;
                }
            else{   
                $result = $helpmate_settings['post-sidebar'];
            }
        } else if (is_archive()) {
            if (function_exists('is_shop') && is_shop()) {
                $shop_sidebar = get_post_meta(wc_get_page_id('shop'), 'sidebar', true);
                $result = !empty($shop_sidebar) && $shop_sidebar != 'default' ? $shop_sidebar : $helpmate_settings['shop-sidebar'];
            } else {
                if (is_post_type_archive('gallery')) {
                    if(isset($helpmate_settings['gallery-sidebar'])){
                        $result = $helpmate_settings['gallery-sidebar'];  
                    }else{
                        $result = $helpmate_settings['sidebar']; 
                    }  
                } else if(is_post_type_archive('recipe')){
                    if(isset($helpmate_settings['recipe-sidebar'])){
                        $result = $helpmate_settings['recipe-sidebar'];  
                    }else{
                        $result = $helpmate_settings['sidebar']; 
                    }  
                } else if(is_post_type_archive('pressmedia')){
                    if(isset($helpmate_settings['press-sidebar'])){
                        $result = $helpmate_settings['press-sidebar'];  
                    }else{
                        $result = $helpmate_settings['sidebar']; 
                    }  
                } else {
                    $term = get_term_by('slug', get_query_var('term'), get_query_var('taxonomy'));
                    if ($term) {
                        $tax_sidebar = get_metadata($term->taxonomy, $term->term_id, 'sidebar', true);
                        switch ($term->taxonomy) {
                            case 'product_cat':
                                if(!empty($tax_sidebar) && $tax_sidebar != 'default') {
                                    $result = $tax_sidebar;
                                } else {
                                    $result = $helpmate_settings['shop-sidebar'];
                                }
                                break;
                            case 'product_tag':
                                $result = $helpmate_settings['shop-sidebar'];
                                break;
                            case 'gallery_cat':
                                if(isset($helpmate_settings['gallery-sidebar'])){
                                    $result = $helpmate_settings['gallery-sidebar'];
                                }else{
                                    $result = $helpmate_settings['sidebar'];
                                }
                                break;
                            case 'recipe_cat':
                                if(isset($helpmate_settings['recipe-sidebar'])){
                                    $result = $helpmate_settings['recipe-sidebar'];
                                }else{
                                    $result = $helpmate_settings['sidebar'];
                                }
                                break;
                            case 'pressmedia_cat':
                                if(isset($helpmate_settings['press-sidebar'])){
                                    $result = $helpmate_settings['press-sidebar'];
                                }else{
                                    $result = $helpmate_settings['sidebar'];
                                }
                                break;    
                            case 'recipe_tag':
                                if(isset($helpmate_settings['recipe-sidebar'])){
                                    $result = $helpmate_settings['recipe-sidebar'];
                                }else{
                                    $result = $helpmate_settings['sidebar'];
                                }
                                break;
                            case 'category':
                                if(!empty($tax_sidebar) && $tax_sidebar != 'default') {
                                    $result = $tax_sidebar;
                                } else {
                                    $result = $helpmate_settings['post-sidebar'];
                                }
                                break;
                            case 'tag':
                                $result = $helpmate_settings['post-sidebar'];
                                break; 
                            default:
                                $result = $helpmate_settings['sidebar'];
                        }
                    }
                }
            }
        } else {
            if (is_singular()) {
                $single_sidebar = get_post_meta(get_the_id(), 'sidebar', true);
                if (!empty($single_sidebar) && $single_sidebar != 'default') {
                    $result = $single_sidebar;
                } else {
                    switch (get_post_type()) {
                        case 'gallery':
                            $result = $helpmate_settings['gallery-sidebar'];
                            break;
                        case 'product':
                            $result = $helpmate_settings['single-product-sidebar'];
                            break;
                        case 'recipe':
                            $result = $helpmate_settings['recipe-sidebar'];
                            break;
                        case 'pressmedia':
                            $result = $helpmate_settings['press-sidebar'];
                            break;    
                        case 'post':
                            $result = $helpmate_settings['post-sidebar'];
                            break;
                        default:
                            $result = $helpmate_settings['sidebar'];
                    }
                }
            } else {
                if (is_home() && !is_front_page()) {
                    $result = $helpmate_settings['post-sidebar'];
                }
            }
        }
        $helpmate_sidebar = $result;
    } 
    return $helpmate_sidebar;   
}

function helpmate_get_header_type() {
    $result = '';
    global $helpmate_settings, $wp_query, $helpmate_header_type;
    if (empty($helpmate_header_type)) {
        $result = isset($helpmate_settings['header-type']) ? $helpmate_settings['header-type'] : 1;
        if (is_category()) {
            $cat = $wp_query->get_queried_object();
            $cat_layout = get_metadata('category', $cat->term_id, 'header', true);
            if (!empty($cat_layout) && $cat_layout != 'default') {
                    $result = $cat_layout;
                }
            else{   
                $result = $helpmate_settings['header-type'];
            }
        } else if (is_archive()) {
            if (function_exists('is_shop') && is_shop()) {
                $shop_layout = get_post_meta(wc_get_page_id('shop'), 'header', true);
                if(!empty($shop_layout) && $shop_layout != 'default') {
                    $result = $shop_layout;
                }
            } 
        } else {
            if (is_singular()) {
                $single_layout = get_post_meta(get_the_id(), 'header', true);
                if (!empty($single_layout) && $single_layout != 'default') {
                    $result = $single_layout;
                }
            } else {
                if (!is_home() && is_front_page()) {
                    $result = $helpmate_settings['header-type'];
                } else if (is_home() && !is_front_page()) {
                    $posts_page_id = get_option( 'page_for_posts' );
                    $posts_page_layout = get_post_meta($posts_page_id, 'header', true);
                    if (!empty($posts_page_layout) && $posts_page_layout != 'default') {
                        $result = $posts_page_layout;
                    }
                }
            }
        }

        $helpmate_header_type = $result;
    }
    return $helpmate_header_type;
}

function helpmate_get_footer_type() {
    $result = '';
    global $helpmate_settings, $wp_query, $footer_type;
    if(empty($footer_type)){
        $result = isset($helpmate_settings['footer-type']) ? $helpmate_settings['footer-type'] : 1;
        if (is_category()) {
            $cat = $wp_query->get_queried_object();
            $cat_layout = get_metadata('category', $cat->term_id, 'footer', true);
            if (!empty($cat_layout) && $cat_layout != 'default') {
                    $result = $cat_layout;
                }
            else{   
                $result = $helpmate_settings['footer-type'];
            }
        } else if (is_archive()) {
            if (function_exists('is_shop') && is_shop()) {
                $shop_layout = get_post_meta(wc_get_page_id('shop'), 'footer', true);
                if(!empty($shop_layout) && $shop_layout != 'default') {
                    $result = $shop_layout;
                }
            }
        } else {
            if (is_singular()) {
                $single_layout = get_post_meta(get_the_id(), 'footer', true);
                if (!empty($single_layout) && $single_layout != 'default') {
                    $result = $single_layout;
                }
            } else {
                if (!is_home() && is_front_page()) {
                    $result = $helpmate_settings['footer-type'];
                } else if (is_home() && !is_front_page()) {
                    $posts_page_id = get_option( 'page_for_posts' );
                    $posts_page_layout = get_post_meta($posts_page_id, 'footer', true);
                    if (!empty($posts_page_layout) && $posts_page_layout != 'default') {
                        $result = $posts_page_layout;
                    }
                }
            }
        }      

        $footer_type = $result;
    }  
    return $footer_type;  
}
//get search template
function helpmate_breadcrumbs() {
    global $post, $wp_query, $author, $helpmate_settings;

    $prepend = '';
    $before = '<li>';
    $after = '</li>';
    $home = esc_html__('Home', 'helpmate');

    $shop_page_id = false;
    $shop_page = false;
    $front_page_shop = false;
    if ( defined( 'WOOCOMMERCE_VERSION' ) ) {
        $permalinks   = get_option( 'woocommerce_permalinks' );
        $shop_page_id = wc_get_page_id( 'shop' );
        $shop_page    = get_post( $shop_page_id );
        $front_page_shop = get_option( 'page_on_front' ) == wc_get_page_id( 'shop' );
    }

    // If permalinks contain the shop page in the URI prepend the breadcrumb with shop
    if ( $shop_page_id && $shop_page && strstr( $permalinks['product_base'], '/' . $shop_page->post_name ) && get_option( 'page_on_front' ) != $shop_page_id ) {
        $prepend = $before . '<a href="' . get_permalink( $shop_page ) . '">' . $shop_page->post_title . '</a> ' . $after;
    }

    if ( ( ! is_home() && ! is_front_page() && ! ( is_post_type_archive() && $front_page_shop ) ) || is_paged() ) {
        echo '<ul>';

        if ( ! empty( $home ) ) {
            echo wp_kses($before,array('li'=>array())) . '<a class="home" href="' . apply_filters( 'woocommerce_breadcrumb_home_url', home_url() ) . '">' . esc_html($home) . '</a>' . $after;
        }

        if ( is_home() ) {

            echo wp_kses($before,array('li'=>array())) . single_post_title('', false) . $after;

        } elseif ( is_search() ) {

            echo wp_kses($before,array('li'=>array())) . esc_html__( 'Search results for &ldquo;', 'helpmate' ) . get_search_query() . '&rdquo;' . $after;

        } else if ( is_category()) {

            if ( get_option( 'show_on_front' ) == 'page' ) {
                echo wp_kses($before,array('li'=>array())) . '<a href="' . get_permalink( get_option('page_for_posts' ) ) . '">' . get_the_title( get_option('page_for_posts', true) ) . '</a>' . $after;
            }

            $cat_obj = $wp_query->get_queried_object();
            $this_category = get_category( $cat_obj->term_id );

            echo wp_kses($before,array('li'=>array())) . single_cat_title( '', false ) . $after;

        } elseif ( is_tax('product_cat') || is_tax('portfolio_cat')) {

            echo wp_kses($prepend, helpmate_allow_html());

            if ( is_tax('portfolio_cat') ) {
                $post_type = get_post_type_object( 'portfolio' );
                echo wp_kses($before,array('li'=>array())) . '<a href="' . get_post_type_archive_link( 'portfolio' ) . '">' . $post_type->labels->singular_name . '</a>' . $after;
            }
            $current_term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

            $ancestors = array_reverse( get_ancestors( $current_term->term_id, get_query_var( 'taxonomy' ) ) );

            foreach ( $ancestors as $ancestor ) {
                $ancestor = get_term( $ancestor, get_query_var( 'taxonomy' ) );

                echo wp_kses($before,array('li'=>array())) . '<a href="' . get_term_link( $ancestor->slug, get_query_var( 'taxonomy' ) ) . '">' . esc_html( $ancestor->name ) . '</a>' . $after;
            }

            echo wp_kses($before,array('li'=>array())) . esc_html( $current_term->name ) . $after;

        } elseif ( is_tax('product_tag') ) {

            $queried_object = $wp_query->get_queried_object();
            echo wp_kses($prepend, helpmate_allow_html()) . $before . ' ' . esc_html__( 'Products tagged &ldquo;', 'helpmate' ) . $queried_object->name . '&rdquo;' . $after;

        } elseif( is_tax('kbe_tags')){
            $queried_object = $wp_query->get_queried_object();
            echo wp_kses($prepend, helpmate_allow_html()) . $before . ' ' . esc_html__( 'Knowledge tagged &ldquo;', 'helpmate' ) . $queried_object->name . '&rdquo;' . $after;
        }  elseif ( is_tax('gallery_tags') || is_tax('gallery_skills') ||is_tax('gallery_cat')){

            echo wp_kses($prepend, helpmate_allow_html());
            $post_type = get_post_type_object( 'gallery' );
            $current_term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );
            echo wp_kses($before,array('li'=>array())) . '<a href="' . get_post_type_archive_link( 'gallery') . '">' .esc_html($post_type->labels->singular_name). '</a>'. $after;
            $ancestors = array_reverse( get_ancestors( $current_term->term_id, get_query_var( 'taxonomy' ) ) );

            foreach ( $ancestors as $ancestor ) {
                $ancestor = get_term( $ancestor, get_query_var( 'taxonomy' ) );

                echo wp_kses($before,array('li'=>array())) . '<a href="' . get_term_link( $ancestor->slug, get_query_var( 'taxonomy' ) ) . '">' . esc_html( $ancestor->name ) . '</a>' . $after;
            }

            echo wp_kses($before,array('li'=>array())) .  esc_html( $current_term->name ) . $after;
        }elseif ( is_day() ) {

            echo wp_kses($before,array('li'=>array())) . '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a>' . $delimiter . $after;
            echo wp_kses($before,array('li'=>array())) . '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a>' . $after;
            echo wp_kses($before,array('li'=>array())) . get_the_time('d') . $after;

        } elseif ( is_month() ) {

            echo wp_kses($before,array('li'=>array())) . '<a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a>' . $after;
            echo wp_kses($before,array('li'=>array())) . get_the_time('F') . $after;

        } elseif ( is_year() ) {

            echo wp_kses($before,array('li'=>array())) . get_the_time('Y') . $after;

        } elseif (is_tax( 'post_format' )){
            echo wp_kses($before,array('li'=>array())) . '<a href="' . get_post_format_link(get_post_format()) . '">' . get_post_format() . '</a>' . $after;
            
        } elseif ( is_post_type_archive('product') && get_option('page_on_front') !== $shop_page_id ) {

            $_name = wc_get_page_id( 'shop' ) ? get_the_title( wc_get_page_id( 'shop' ) ) : '';

            if ( ! $_name ) {
                $product_post_type = get_post_type_object( 'product' );
                $_name = $product_post_type->labels->singular_name;
            }

            if ( is_search() ) {

                echo wp_kses($before,array('li'=>array())) . '<a href="' . get_post_type_archive_link('product') . '">' . $_name . '</a>' . esc_html__( 'Search results for &ldquo;', 'helpmate' ) . get_search_query() . '&rdquo;' . $after;

            } elseif ( is_paged() ) {

                echo wp_kses($before,array('li'=>array())) . '<a href="' . get_post_type_archive_link('product') . '">' . $_name . '</a>' . $after;

            } else {

                echo wp_kses($before,array('li'=>array())) . $_name . $after;

            }

        } elseif ( is_single() && ! is_attachment() ) {

            if ( 'product' == get_post_type() ) {

                echo wp_kses($prepend, helpmate_allow_html());

                if ( $terms = wc_get_product_terms( $post->ID, 'product_cat', array( 'orderby' => 'parent', 'order' => 'DESC' ) ) ) {
                    $main_term = $terms[0];
                    $ancestors = get_ancestors( $main_term->term_id, 'product_cat' );
                    $ancestors = array_reverse( $ancestors );

                    foreach ( $ancestors as $ancestor ) {
                        $ancestor = get_term( $ancestor, 'product_cat' );

                        if ( ! is_wp_error( $ancestor ) && $ancestor ) {
                            echo wp_kses($before,array('li'=>array())) . '<a href="' . get_term_link( $ancestor ) . '">' . $ancestor->name . '</a>' . $after;
                        }
                    }

                    echo wp_kses($before,array('li'=>array())) . '<a href="' . get_term_link( $main_term ) . '">' . $main_term->name . '</a>' . $after;

                }

                echo wp_kses($before,array('li'=>array())) . get_the_title() . $after;

            } elseif ( 'post' != get_post_type() ) {
                $post_type = get_post_type_object( get_post_type() );
                $slug = $post_type->rewrite;
                echo wp_kses($before,array('li'=>array())) . '<a href="' . get_post_type_archive_link( get_post_type() ) . '">' . $post_type->labels->singular_name . '</a>' . $after;
                echo wp_kses($before,array('li'=>array())) . get_the_title() . $after;

            } else {

                if ( 'post' == get_post_type() && get_option( 'show_on_front' ) == 'page' ) {
                    echo wp_kses($before,array('li'=>array())) . '<a href="' . get_permalink( get_option('page_for_posts' ) ) . '">' . get_the_title( get_option('page_for_posts', true) ) . '</a>' . $after;
                }

                $cat = current( get_the_category() );
                if ( ( $parents = get_category_parents( $cat, TRUE, $after . $before ) ) && ! is_wp_error( $parents ) ) {
                    echo wp_kses($before,array('li'=>array())) . substr( $parents, 0, strlen($parents) - strlen($after . $before) ) . $after;
                }
                echo wp_kses($before,array('li'=>array())) . get_the_title() . $after;

            }

        } elseif ( is_404() ) {

            echo wp_kses($before,array('li'=>array())) . esc_html__( 'Error 404', 'helpmate' ) . $after;

        } elseif ( ! is_single() && ! is_page() && get_post_type() != 'post' ) {

            $post_type = get_post_type_object( get_post_type() );

            if ( $post_type ) {
                echo wp_kses($before,array('li'=>array())) . $post_type->labels->singular_name . $after;
            }

        } elseif ( is_attachment() ) {

            $parent = get_post( $post->post_parent );
            $cat = get_the_category( $parent->ID );
            $cat = $cat[0];
            if ( ( $parents = get_category_parents( $cat, TRUE, $after . $before ) ) && ! is_wp_error( $parents ) ) {
                echo wp_kses($before,array('li'=>array())) . substr( $parents, 0, strlen($parents) - strlen($after . $before) ) . $after;
            }
            echo wp_kses($before,array('li'=>array())) . '<a href="' . get_permalink( $parent ) . '">' . $parent->post_title . '</a>'. $after;
            echo wp_kses($before,array('li'=>array())) . get_the_title() . $after;

        } elseif ( is_page() && !$post->post_parent ) {

            echo wp_kses($before,array('li'=>array())) . get_the_title() . $after;

        } elseif ( is_page() && $post->post_parent ) {

            $parent_id  = $post->post_parent;
            $breadcrumbs = array();

            while ( $parent_id ) {
                $page = get_post( $parent_id );
                $breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title( $page->ID ) . '</a>';
                $parent_id  = $page->post_parent;
            }

            $breadcrumbs = array_reverse( $breadcrumbs );

            foreach ( $breadcrumbs as $crumb ) {
                echo wp_kses($before,array('li'=>array())) . $crumb . $after;
            }

            echo wp_kses($before,array('li'=>array())) . get_the_title() . $after;

        } elseif ( is_search() ) {

            echo wp_kses($before,array('li'=>array())) . esc_html__( 'Search results for &ldquo;', 'helpmate' ) . get_search_query() . '&rdquo;' . $after;

        } elseif ( is_tag() ) {

            echo wp_kses($before,array('li'=>array())) . esc_html__( 'Posts tagged &ldquo;', 'helpmate' ) . single_tag_title('', false) . '&rdquo;' . $after;

        } elseif ( is_author() ) {

            $userdata = get_userdata($author);
            echo wp_kses($before,array('li'=>array())) . esc_html__( 'Author:', 'helpmate' ) . ' ' . $userdata->display_name . $after;

        }

        if ( get_query_var( 'paged' ) ) {
            echo wp_kses($before,array('li'=>array())) . '&nbsp;(' . esc_html__( 'Page', 'helpmate' ) . ' ' . get_query_var( 'paged' ) . ')' . $after;
        }

        echo '</ul>';
    } else {
        if ( is_home() && !is_front_page() ) {
            echo '<ul>';

            if ( ! empty( $home ) ) {
                echo wp_kses($before,array('li'=>array())) . '<a class="home" href="' . apply_filters( 'woocommerce_breadcrumb_home_url', home_url() ) . '">' . esc_html($home) . '</a>' . $after;

                echo wp_kses($before,array('li'=>array())) . force_balance_tags(esc_html($helpmate_settings['blog-title'])) . $after;
            }

            echo '</ul>';
        }
    }
}

function helpmate_page_title() {

    global $helpmate_settings, $post, $wp_query, $author;

    $home = esc_html__('Home', 'helpmate');

    $shop_page_id = false;
    $front_page_shop = false;
    if ( defined( 'WOOCOMMERCE_VERSION' ) ) {
        $shop_page_id = wc_get_page_id( 'shop' );
        $front_page_shop = get_option( 'page_on_front' ) == wc_get_page_id( 'shop' );
    }

    if ( ( ! is_home() && ! is_front_page() && ! ( is_post_type_archive() && $front_page_shop ) ) || is_paged() ) {

        if ( is_home() ) {

        } else if ( is_category() ) {

            echo single_cat_title( '', false );

        }  elseif ( is_search() ) {

            echo esc_html__( 'Search results for &ldquo;', 'helpmate' ) . get_search_query() . '&rdquo;';

        } elseif ( is_tax('product_cat') || is_tax('portfolio_cat')) {

            $current_term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

            echo esc_html( $current_term->name );

        } elseif ( is_tax('product_tag') ) {

            $queried_object = $wp_query->get_queried_object();
            echo esc_html__( 'Products tagged &ldquo;', 'helpmate' ) . $queried_object->name . '&rdquo;';

        } elseif(is_tax('gallery_tags')){
             echo esc_html__( 'Gallery tagged &ldquo;', 'helpmate' ) . get_queried_object()->name . '&rdquo;';
        } elseif(is_tax('gallery_skills')){
             echo esc_html__( 'Gallery skill &ldquo;', 'helpmate' ) . get_queried_object()->name . '&rdquo;';
        } elseif(is_tax()){
             echo esc_html( get_queried_object()->name );
        } elseif ( is_day() ) {

            printf( esc_html__( 'Daily Archives: %s', 'helpmate' ), get_the_date() );

        } elseif ( is_month() ) {

            printf( esc_html__( 'Monthly Archives: %s', 'helpmate' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'helpmate' ) ) );

        } elseif ( is_year() ) {

            printf( esc_html__( 'Yearly Archives: %s', 'helpmate' ), get_the_date( _x( 'Y', 'yearly archives date format', 'helpmate' ) ) );

        } elseif (is_tax( 'post_format' )){
            printf( esc_html__( 'Post format: %s', 'helpmate' ), get_post_format() );
        } elseif ( is_post_type_archive('product') && get_option('page_on_front') !== $shop_page_id ) {

            $_name = wc_get_page_id( 'shop' ) ? get_the_title( wc_get_page_id( 'shop' ) ) : '';

            if ( ! $_name ) {
                $product_post_type = get_post_type_object( 'product' );
                $_name = $product_post_type->labels->singular_name;
            }

            if ( is_search() ) {
                echo esc_html__( 'Search results for &ldquo;', 'helpmate' ) . get_search_query() . '&rdquo;';
            } elseif ( is_paged() ) {

            } else {

                echo esc_html($_name);

            }

        } elseif ( is_post_type_archive('gallery') ) {

            $post_type = get_post_type_object( 'gallery' );
            echo esc_html($post_type->labels->name);

        } elseif ( is_post_type_archive('kbe_knowledgebase') ) {

            $post_type = get_post_type_object( 'kbe_knowledgebase' );
             echo esc_html__( 'Knowledge', 'helpmate' );

        } else if(is_post_type_archive('recipe')){
            if(isset($helpmate_settings['recipe-title']) && $helpmate_settings['recipe-title'] !=""){
                echo force_balance_tags(esc_html($helpmate_settings['recipe-title']));
            }else{
                echo esc_html__( 'Recipes', 'helpmate' );
            }
                
        }else if ( is_post_type_archive() ) {
            sprintf( esc_html__( 'Archives: %s', 'helpmate' ), post_type_archive_title( '', false ) );
        } elseif ( is_single() && ! is_attachment() ) {

            if ( 'gallery' == get_post_type() ) {

                echo get_the_title();

            } else {

                echo get_the_title();

            }

        } elseif ( is_404() ) {

            echo esc_html__( 'Error 404', 'helpmate' );

        } elseif ( ! is_single() && ! is_page() && get_post_type() != 'post' ) {

            $post_type = get_post_type_object( get_post_type() );

            if ( $post_type ) {
                echo esc_html($post_type->labels->singular_name);
            }

        } elseif ( is_attachment() ) {

            echo get_the_title();

        } elseif ( is_page() && !$post->post_parent ) {

            echo get_the_title();

        } elseif ( is_page() && $post->post_parent ) {

            echo get_the_title();

        } elseif ( is_search() ) {

            echo esc_html__( 'Search results for &ldquo;', 'helpmate' ) . get_search_query() . '&rdquo;';

        } elseif ( is_tag() ) {

            echo esc_html__( 'Posts tagged &ldquo;', 'helpmate' ) . single_tag_title('', false) . '&rdquo;';

        } elseif ( is_author() ) {

            $userdata = get_userdata($author);
            echo esc_html__( 'Author:', 'helpmate' ) . ' ' . $userdata->display_name;

        }

        if ( get_query_var( 'paged' ) ) {
            echo ' (' . esc_html__( 'Page', 'helpmate' ) . ' ' . get_query_var( 'paged' ) . ')';
        }
    } else {
        if ( is_home() && !is_front_page() ) {
            if ( ! empty( $home ) ) {
                echo force_balance_tags(esc_html($helpmate_settings['blog-title']));
            }
        }
    }
}

?>