<?php
function helpmate_clients_meta_data() {
    return array(
        array(
            "name" => "client_title",
            "title" => esc_html__("Title", 'helpmate'),
            "type" => "textfield"
        ), 
		array(
            "name" => "client_name",
            "title" => esc_html__("Name", 'helpmate'),
            "type" => "textfield"
        ), 
		array(
            "name" => "address",
            "title" => esc_html__("Address", 'helpmate'),
            "type" => "textfield"
        ), 
		array(
            "name" => "link",
            "title" => esc_html__("Link", 'helpmate'),
            "type" => "textfield"
        ),
    );
}
function helpmate_view_clients_meta_option() {
    $meta_box = helpmate_clients_meta_data();
    helpmate_show_meta_box($meta_box);
}

function helpmate_save_clients_meta_option($post_id) {
    $meta_box = helpmate_clients_meta_data();
    return helpmate_save_meta_data( $post_id, $meta_box );
}
function helpmate_add_clients_metaboxes() {
    if ( function_exists('add_meta_box') ) {
        add_meta_box( 'show-meta-boxes', esc_html__('Clients Option', 'helpmate'), 'helpmate_view_clients_meta_option', 'clients', 'normal', 'low' );
    }
}
add_action('add_meta_boxes', 'helpmate_add_clients_metaboxes');
add_action('save_post', 'helpmate_save_clients_meta_option');