<?php

function helpmate_default_meta_data() {
    $helpmate_layout = helpmate_layouts();
    $helpmate_main_layout = helpmate_main_layouts();
    $helpmate_sidebar_position = helpmate_sidebar_position();
    $helpmate_sidebars = helpmate_sidebars();
    $helpmate_header_layout = helpmate_header_types();
    $helpmate_footer_layout = helpmate_footer_types();
    $helpmate_popup_layout = helpmate_popup_layouts();
    $helpmate_block_name = helpmate_get_block_name();
    $helpmate_block_name['default'] ='default';
    return array(
        // header
        'header' => array(
            'name' => 'header',
            'title' => esc_html__('Header Layout', 'helpmate'),
            'type' => 'select',
            'options' => $helpmate_header_layout,
            'default' => 'default'
        ),
        //footer
        'footer' => array(
            'name' => 'footer',
            'title' => esc_html__('Footer Layout', 'helpmate'),
            'type' => 'select',
            'options' => $helpmate_footer_layout,
            'default' => 'default'
        ),
        // Main layout
        'main_layout' => array(
            'name' => 'main_layout',
            'title' => esc_html__('Main Layout', 'helpmate'),
            'type' => 'select',
            'options' => $helpmate_main_layout,
            'default' => 'default',
            'desc' => esc_html__('Select right main layout with header type. Ex: Main layout 1 will work effectively with header type 1.', 'helpmate'),
        ),        
        // Breadcrumbs
        'breadcrumbs' => array(
            'name' => 'breadcrumbs',
            'title' => esc_html__('Breadcrumbs', 'helpmate'),
            'desc' => esc_html__('Hide breadcrumbs', 'helpmate'),
            'type' => 'checkbox'
        ),
        'page_title' => array(
            'name' => 'page_title',
            'title' => esc_html__('Page Title', 'helpmate'),
            'desc' => esc_html__('Hide Page Title', 'helpmate'),
            'type' => 'checkbox'
        ),
        'show_header' => array(
            'name' => 'show_header',
            'title' => esc_html__('Header', 'helpmate'),
            'desc' => esc_html__('Hide header', 'helpmate'),
            'type' => 'checkbox'
        ),
        //  Show Footer
        'show_footer' => array(
            'name' => 'show_footer',
            'title' => esc_html__('Footer', 'helpmate'),
            'desc' => esc_html__('Hide footer', 'helpmate'),
            'type' => 'checkbox'
        ),
        //sidebar position
        'sidebar_position' => array(
            'name' => 'sidebar_position',
            'type' => 'select',
            'title' => esc_html__('Sidebar Position', 'helpmate'),
            'options' => $helpmate_sidebar_position,
            'default' => 'default'
        ),
        //sidebar
        'sidebar' => array(
            'name' => 'sidebar',
            'type' => 'select',
            'title' => esc_html__('Sidebar', 'helpmate'),
            'options' => $helpmate_sidebars,
            'default' => 'default'
        ),
        // layout
        'layout' => array(
            'name' => 'layout',
            'title' => esc_html__('Layout', 'helpmate'),
            'type' => 'select',
            'options' => $helpmate_layout,
            'default' => 'default'
        ),

        //popup
        'popup_layout' => array(
            'name' => 'popup_layout',
            'title' => esc_html__('Popup Layout', 'helpmate'),
            'type' => 'select',
            'options' => $helpmate_popup_layout,
            'default' => 'default'
        ),
        'hide_static' => array(
            'name' => 'hide_static',
            'title' => esc_html__('Banner Block', 'helpmate'),
            'desc' => esc_html__('Hide banner block', 'helpmate'),
            'type' => 'checkbox'
        ),
        'block_bottom' =>   array(
            'name'=>'block_bottom',
            'type' => 'select',
            'title' => esc_html__('Select Banner Block', 'helpmate'),
            'options' => $helpmate_block_name,
            'desc' => esc_html__('Choose a block to display at the bottom of pages. You can create a block in Static Block/Add New.', 'helpmate'),
            'default' => 'default'
        ), 
    );
}

function helpmate_skin_meta_data(){
    $helpmate_main_color = array('cardinal', 'pale-violet', 'summer-sky', 'lima','moon-yellow','havelock-blue'); 
    $other_fonts =  array(
                        'default' => esc_html__( 'default', 'helpmate' ),
                        'Poppins'  => 'Poppins',
                        'Hind'  => 'Hind',
                        'Roboto'  => 'Roboto',                      
                        'Palanquin'  => 'Palanquin',
                        'Open Sans'  => 'Open Sans',             
                        'Oxygen'  => 'Oxygen',                         
                    );
    return array(
        // font
        'cus_font' => array(
            'name' => 'cus_font',
            'title' => esc_html__('Special font family', 'helpmate'),
            'type' => 'select',
            'options' => $other_fonts,
            'default' => 'default',
            'group' => 'font',
        ),
        'font_size' => array(
            'name' => 'font_size',
            'title' => esc_html__('Font size', 'helpmate'),
            'desc' => esc_html__('Enter different font size', 'helpmate'),
            'type' => 'number',
            'number_after' => 'px',
            'group' => 'font',
        ),
        'line_height' => array(
            'name' => 'line_height',
            'title' => esc_html__('Line height', 'helpmate'),
            'desc' => esc_html__('Enter other line height value.', 'helpmate'),
            'type' => 'number',
            'number_after' => 'px',
            'group' => 'font',
        ),        
    );
}

