<?php
function helpmate_gallery_meta_data() {
    $single_layout_gallery = helpmate_gallery_single_layout();  
    return array(
        array(
            "name" => "client",
            "title" => esc_html__("Client", 'helpmate'),
            "type" => "textfield"
        ),
        array(
            "name" => "services",
            "title" => esc_html__("Services", 'helpmate'),
            "type" => "textfield"
        ), 
        //single layout
        array(
            'name' => 'single_layout',
            'title' => esc_html__('Single Layout', 'helpmate'),
            'type' => 'select',
            'options' => $single_layout_gallery,
            'default' => 'default'
        ),
        array(
            "name"=> "image_banner",
            "title"=> esc_html__("Banner", 'helpmate'),
            "desc" => esc_html__('Banner Will Show If You Select Single Layout Is Full Banner', 'helpmate'),
            "type" => "upload",
        ),       
    );
}
function helpmate_view_gallery_meta_option() {
    $meta_box = helpmate_gallery_meta_data();
    helpmate_show_meta_box($meta_box);
}

function helpmate_save_gallery_meta_option($post_id) {
    $meta_box = helpmate_gallery_meta_data();
    return helpmate_save_meta_data( $post_id, $meta_box );
}
function helpmate_add_gallery_metaboxes() {
    if ( function_exists('add_meta_box') ) {
        add_meta_box( 'show-meta-boxes', esc_html__('Gallery Options', 'helpmate'), 'helpmate_view_gallery_meta_option', 'gallery', 'normal', 'low' );
    }
}
add_action('add_meta_boxes', 'helpmate_add_gallery_metaboxes');
add_action('save_post', 'helpmate_save_gallery_meta_option');