<?php
function helpmate_post_meta_data() {
    return array(
        "highlight" => array(
            "name" => "highlight",
            "title" => esc_html__("Highlight content", 'helpmate'),
            "desc" => esc_html__("Content", 'helpmate'),
            "type" => "editor"
        ),
    );
}
function helpmate_post_format(){
    return array(
        "video_code" => array(
            "name" => "video_code",
            "title" => esc_html__("Video & Audio Embed Code", 'helpmate'),
            "desc" => esc_html__('Enter the embed link (Youtube or Vimeo). ', 'helpmate'),
            "type" => "textarea",
            'display_condition' => 'post-type-video', 
        ),
        "link_code" => array(
            "name" => "link_code",
            "title" => esc_html__("Link", 'helpmate'),
            "desc" => esc_html__('Enter link. ', 'helpmate'),
            "type" => "textfield",
            'display_condition' => 'post-type-link', 
        ),
        "link_title" => array(
            "name" => "link_title",
            "title" => esc_html__("Link title", 'helpmate'),
            "desc" => esc_html__('Enter link title. ', 'helpmate'),
            "type" => "textfield",
            'display_condition' => 'post-type-link', 
        ),
        "quote_code" => array(
            "name" => "quote_code",
            "title" => esc_html__("Quote", 'helpmate'),
            "desc" => esc_html__('Enter quote. ', 'helpmate'),
            "type" => "textarea",
            'display_condition' => 'post-type-quote', 
        ),
        "quote_author" => array(
            "name" => "quote_author",
            "title" => esc_html__("Quote author", 'helpmate'),
            "desc" => esc_html__('Enter quote author. ', 'helpmate'),
            "type" => "textfield",
            'display_condition' => 'post-type-quote', 
        ),
    );
}
function helpmate_view_post_meta_option() {
    $meta_box = helpmate_post_meta_data();
    helpmate_show_meta_box($meta_box);
}
function helpmate_view_post_format_meta_option() {
    $meta_box = helpmate_post_format();
    helpmate_show_meta_box($meta_box);
}

function helpmate_show_post_meta_option() {
    $meta_box = helpmate_default_meta_data();
    helpmate_show_meta_box($meta_box);
}
function helpmate_save_post2_meta_option($post_id) {
    $meta_box_post = helpmate_post_meta_data();
    $meta_box_format = helpmate_post_format();
    $meta_box = array_merge($meta_box_post,$meta_box_format); 
    return helpmate_save_meta_data($post_id, $meta_box);
}
function helpmate_save_post_meta_option($post_id) {
    $meta_box = helpmate_default_meta_data();
    return helpmate_save_meta_data($post_id, $meta_box);
}

function helpmate_add_post_metaboxes() {
    if (function_exists('add_meta_box')) {
        add_meta_box('view-format-boxes', esc_html__('Post Format', 'helpmate'), 'helpmate_view_post_format_meta_option', 'post', 'normal', 'low');
        add_meta_box('show-meta-boxes', esc_html__('Blog Options', 'helpmate'), 'helpmate_view_post_meta_option', 'post', 'normal', 'low');
        add_meta_box('view-meta-boxes', esc_html__('Layout Options', 'helpmate'), 'helpmate_show_post_meta_option', 'post', 'normal', 'low');
    }
}

add_action('add_meta_boxes', 'helpmate_add_post_metaboxes');
add_action('save_post', 'helpmate_save_post_meta_option');
add_action('save_post', 'helpmate_save_post2_meta_option');

function helpmate_default_post_tax_meta_data() {
    $helpmate_sidebar_position = helpmate_sidebar_position();
    $helpmate_sidebars = helpmate_sidebars();
    $helpmate_header_layout = helpmate_header_types();
    $helpmate_blog_layout = helpmate_page_blog_layouts();
    $helpmate_blog_layout['default']= esc_html__('Default','helpmate');
    return array(
        // Breadcrumbs
        'page_title' => array(
            'name' => 'page_title',
            'title' => esc_html__('Page Title', 'helpmate'),
            'desc' => esc_html__('Hide Page Title', 'helpmate'),
            'type' => 'checkbox'
        ),
        'show_header' => array(
            'name' => 'show_header',
            'title' => esc_html__('Header', 'helpmate'),
            'desc' => esc_html__('Hide header', 'helpmate'),
            'type' => 'checkbox'
        ),
        //  Show Footer
        'show_footer' => array(
            'name' => 'show_footer',
            'title' => esc_html__('Footer', 'helpmate'),
            'desc' => esc_html__('Hide footer', 'helpmate'),
            'type' => 'checkbox'
        ),
        'blog_layout' => array(
            'name' => 'blog_layout',
            'title' => esc_html__('Blog layout', 'helpmate'),
            'desc' => esc_html__('Select blog layout', 'helpmate'),
            'type' => 'select',
            'options' => $helpmate_blog_layout,
            'default' => 'default'            
        ),
        //sidebar position
        'sidebar_position' => array(
            'name' => 'sidebar_position',
            'type' => 'select',
            'title' => esc_html__('Sidebar Position', 'helpmate'),
            'options' => $helpmate_sidebar_position,
            'default' => 'default'
        ),
        //sidebar
        'sidebar' => array(
            'name' => 'sidebar',
            'type' => 'select',
            'title' => esc_html__('Sidebar', 'helpmate'),
            'options' => $helpmate_sidebars,
            'default' => 'default'
        ),
    );
}
//category taxonomy
function helpmate_add_categorymeta_table() {
    // Create Product Cat Meta
    global $wpdb;
    $type = 'category';
    $table_name = $wpdb->prefix . $type . 'meta';
    $variable_name = $type . 'meta';
    $wpdb->$variable_name = $table_name;

    // Create Category Meta Table
    helpmate_create_metadata_table($table_name, $type);
}
add_action( 'init', 'helpmate_add_categorymeta_table' );

// category meta
add_action( 'category_add_form_fields', 'helpmate_add_category', 10, 2);
function helpmate_add_category() {
    $category_meta_boxes = helpmate_default_post_tax_meta_data();
    helpmate_show_tax_add_meta_boxes($category_meta_boxes);
}

add_action( 'category_edit_form_fields', 'helpmate_edit_category', 10, 2);
function helpmate_edit_category($tag, $taxonomy) {
    $category_meta_boxes = helpmate_default_post_tax_meta_data();
    helpmate_show_tax_edit_meta_boxes($tag, $taxonomy, $category_meta_boxes);
}

add_action( 'created_term', 'helpmate_save_category', 10,3 );
add_action( 'edit_term', 'helpmate_save_category', 10,3 );
function helpmate_save_category($term_id, $tt_id, $taxonomy) {
    if (!$term_id) return;
    
    $category_meta_boxes = helpmate_default_post_tax_meta_data();
    return helpmate_save_taxdata( $term_id, $tt_id, $taxonomy, $category_meta_boxes );
}



 