<?php

function helpmate_product_sidebar_option(){
    $helpmate_sidebar_position = helpmate_sidebar_position();
    $helpmate_sidebars = helpmate_sidebars();
    $helpmate_header_layout = helpmate_header_types();
    $helpmate_footer_layout = helpmate_footer_types();
    $helpmate_main_layout = helpmate_main_layouts();
    return array(
        'header' => array(
            'name' => 'header',
            'title' => esc_html__('Header Layout', 'helpmate'),
            'type' => 'select',
            'options' => $helpmate_header_layout,
            'default' => 'default'
        ),
        //footer
        'footer' => array(
            'name' => 'footer',
            'title' => esc_html__('Footer Layout', 'helpmate'),
            'type' => 'select',
            'options' => $helpmate_footer_layout,
            'default' => 'default'
        ),
        // Main layout
        'main_layout' => array(
            'name' => 'main_layout',
            'title' => esc_html__('Main Layout', 'helpmate'),
            'type' => 'select',
            'options' => $helpmate_main_layout,
            'default' => 'default',
            'desc' => esc_html__('Select right main layout with header type. Ex: Main layout 1 will work effectively with header type 1.', 'helpmate'),
        ),
        //sidebar position
        'sidebar_position' => array(
            'name' => 'sidebar_position',
            'type' => 'select',
            'title' => esc_html__('Sidebar Position', 'helpmate'),
            'options' => $helpmate_sidebar_position,
            'default' => 'default'
        ),
        //sidebar
        'sidebar' => array(
            'name' => 'sidebar',
            'type' => 'select',
            'title' => esc_html__('Sidebar', 'helpmate'),
            'options' => $helpmate_sidebars,
            'default' => 'default'
        ),
    );
}
function helpmate_show_product_default_meta_option() {
    $meta_box = helpmate_product_sidebar_option();
    helpmate_show_meta_box($meta_box);
}


function helpmate_save_product_meta_option($post_id) {
    $meta_box = helpmate_product_sidebar_option();
    return helpmate_save_meta_data($post_id, $meta_box);
}

function helpmate_add_product_metaboxes() {
    if (function_exists('add_meta_box')) {
        add_meta_box('show-meta-boxes', esc_html__('Sidebar Options', 'helpmate'), 'helpmate_show_product_default_meta_option', 'product', 'side', 'low');
    }
}

add_action('add_meta_boxes', 'helpmate_add_product_metaboxes');
add_action('save_post', 'helpmate_save_product_meta_option');
function helpmate_add_categorymeta_product_table() {
// Create Product Cat Meta
global $wpdb;
$type = 'product_cat';
$table_name = $wpdb->prefix . $type . 'meta';
$variable_name = $type . 'meta';
$wpdb->$variable_name = $table_name;

// Create Product Cat Meta Table
helpmate_create_metadata_table($table_name, $type);
}
add_action( 'init', 'helpmate_add_categorymeta_product_table' );
//Taxonomy
function helpmate_default_product_tax_meta_data() {
    $helpmate_sidebar_position = helpmate_sidebar_position();
    $helpmate_sidebars = helpmate_sidebars();   
    $helpmate_list_mode = helpmate_product_type();
    $helpmate_header_layout = helpmate_header_types();
    $helpmate_footer_layout = helpmate_footer_types(); 
    $helpmate_main_layout = helpmate_main_layouts();
    return array(
        // Breadcrumbs
        'breadcrumbs' => array(
            'name' => 'breadcrumbs',
            'title' => esc_html__('Breadcrumbs', 'helpmate'),
            'desc' => esc_html__('Hide breadcrumbs', 'helpmate'),
            'type' => 'checkbox'
        ),
        'page_title' => array(
            'name' => 'page_title',
            'title' => esc_html__('Page Title', 'helpmate'),
            'desc' => esc_html__('Hide Page Title', 'helpmate'),
            'type' => 'checkbox'
        ),
        'show_header' => array(
            'name' => 'show_header',
            'title' => esc_html__('Header', 'helpmate'),
            'desc' => esc_html__('Hide header', 'helpmate'),
            'type' => 'checkbox'
        ),
        //  Show Footer
        'show_footer' => array(
            'name' => 'show_footer',
            'title' => esc_html__('Footer', 'helpmate'),
            'desc' => esc_html__('Hide footer', 'helpmate'),
            'type' => 'checkbox'
        ),
        //sidebar position
        'sidebar_position' => array(
            'name' => 'sidebar_position',
            'type' => 'select',
            'title' => esc_html__('Sidebar Position', 'helpmate'),
            'options' => $helpmate_sidebar_position,
            'default' => 'default'
        ),
        //sidebar
        'sidebar' => array(
            'name' => 'sidebar',
            'type' => 'select',
            'title' => esc_html__('Sidebar', 'helpmate'),
            'options' => $helpmate_sidebars,
            'default' => 'default'
        ),
        //sidebar
        'list_mode_product' => array(
            'name' => 'list_mode_product',
            'type' => 'select',
            'title' => esc_html__('List mode', 'helpmate'),
            'options' => $helpmate_list_mode,
            'default' => 'list-default'
        ),
    );
}

add_action( 'product_cat_add_form_fields', 'helpmate_add_product_cat', 10, 2);
function helpmate_add_product_cat() {
    $product_cat_meta_boxes = helpmate_default_product_tax_meta_data();

    helpmate_show_tax_add_meta_boxes($product_cat_meta_boxes);
}

add_action( 'product_cat_edit_form_fields', 'helpmate_edit_product_cat', 10, 2);
function helpmate_edit_product_cat($tag, $taxonomy) {
    $product_cat_meta_boxes = helpmate_default_product_tax_meta_data();

    helpmate_show_tax_edit_meta_boxes($tag, $taxonomy, $product_cat_meta_boxes);
}

add_action( 'created_term', 'helpmate_save_product_cat', 10,3 );
add_action( 'edit_term', 'helpmate_save_product_cat', 10,3 );

function helpmate_save_product_cat($term_id, $tt_id, $taxonomy) {
    if (!$term_id) return;
    
    $product_cat_meta_boxes = helpmate_default_product_tax_meta_data();
    return helpmate_save_taxdata( $term_id, $tt_id, $taxonomy, $product_cat_meta_boxes );
}