<?php
        //add workspacefont to iconpicker shortcode
    function helpmate_iconpicker_type_fontello($icons) {
        $fontello_icons = array(
            array("icon-pipe9" => "Pipe9"),
            array("icon-lightbulb" => "Lightbulb"),
            array("icon-hammer2" => "Hammer2"),
            array("icon_flower" => "Flower"),
            array("icon1" => "Icon1"),
            array("icon2" => "Icon2"),
            array("icon3" => "Icon3"),
            array("icon_certificat" => "Certificat"),
            array("icon_price" => "Price"),
            array("icon_phone" => "Phone"),
            array("serv_icon1" => "Service Icon1"),
            array("serv_icon2" => "Service Icon2"),
            array("serv_icon3" => "Service Icon3"),
            array("serv_icon4" => "Service Icon4"),
            array("serv_icon5" => "Service Icon5"),
            array("serv_icon6" => "Service Icon6"),
            array("serv_icon7" => "Service Icon7"),
            array("serv_icon8" => "Service Icon8"),
            array("icon_users" => "Users"),
            array("icon_time" => "Time"),
            array("icon_truck" => "Truck"),
            array("icon_heart" => "Heart"),
            array("icon_money" => "Money"),
            array("icon_serv" => "Icon Service"),
            array("icon_item1" => "Icon Item 1"),
            array("icon_item2" => "Icon Item 2"),
            array("icon_item3" => "Icon Item 3"),
            array("icon_item4" => "Icon Item 4"),
            array("icon_item5" => "Icon Item 5"),
        );

        return array_merge($icons, $fontello_icons);
    }
    add_filter( 'vc_iconpicker-type-fontello', 'helpmate_iconpicker_type_fontello' );
    function helpmate_vc_tta_accordion() {
        $attributes = array(
        array(
            'type' => 'dropdown',
            'param_name' => 'style',
            'value' => array(
                esc_html__('Helpmate style', 'helpmate') => 'helpmate_style',
                esc_html__('Classic', 'helpmate') => 'classic',
                esc_html__('Modern', 'helpmate') => 'modern',
                esc_html__('Flat', 'helpmate') => 'flat',
                esc_html__('Outline', 'helpmate') => 'outline',
            ),
            'heading' => esc_html__('Style', 'helpmate'),
            'description' => esc_html__('Select accordion display style.', 'helpmate'),
        ),
        );
        vc_add_params('vc_tta_accordion', $attributes); // Note: 'vc_message' was used as a base for "Message box" element
    }
    add_action('vc_before_init', 'helpmate_vc_tta_accordion'); 

    function helpmate_vc_icon() {
        $attributes = array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Icon library', 'helpmate'),
                'value' => array(
                    esc_html__('Font Awesome', 'helpmate') => 'fontawesome',
                    esc_html__('Fontello', 'helpmate') => 'fontello',
                    esc_html__( 'Open Iconic', 'helpmate' ) => 'openiconic',
                    esc_html__( 'Typicons', 'helpmate' ) => 'typicons',
                    esc_html__( 'Entypo', 'helpmate' ) => 'entypo',
                    esc_html__( 'Linecons', 'helpmate' ) => 'linecons',
                    esc_html__( 'Mono Social', 'helpmate' ) => 'monosocial',
                ),
                'admin_label' => true,
                'param_name' => 'type',
                'weight' => 10,
                'description' => esc_html__('Select icon library.', 'helpmate'),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__('Icon', 'helpmate'),
                'param_name' => 'icon_fontello',
                'settings' => array(
                    'emptyIcon' => false, // default true, display an "EMPTY" icon?
                    'type' => 'fontello',
                    'iconsPerPage' => 4000, // default 100, how many icons per/page to display
                ),
                'dependency' => array(
                    'element' => 'type',
                    'value' => 'fontello',
                ),
                'weight' => 9,
                'description' => esc_html__('Select icon from library.', 'helpmate'),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Title', 'helpmate' ),
                'param_name' => 'icon_title',
                'value' => '',
                'description' => esc_html__( "Title.", "helpmate" ),
                'group' => esc_html__( 'Content', 'helpmate' )
            ),
            array(
                "type" => "textarea",
                "holder" => "div",
                "class" => "",
                "heading" => esc_html__( "Content", "helpmate" ),
                "param_name" => "description", 
                "description" => esc_html__( "Enter your content.", "helpmate" ),
                'group' => esc_html__( 'Content', 'helpmate' )
            )
        );
        vc_add_params('vc_icon', $attributes); 
    }
    add_action('vc_before_init', 'helpmate_vc_icon'); 

    function helpmate_vc_single_image() {
    $attributes = array(
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Caption title", "helpmate" ),
            "param_name" => "cap_title", 
            "description" => esc_html__( "Enter title", "helpmate" ),
            'group' => esc_html__( 'Caption', 'helpmate' )
        ),
        array(
            "type" => "textarea",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Description", "helpmate" ),
            "param_name" => "cap_des", 
            "description" => esc_html__( "Enter description", "helpmate" ),
            'group' => esc_html__( 'Caption', 'helpmate' )
        ),
        array(
            "type" => "textfield",
            "holder" => "div",
            "class" => "",
            "heading" => esc_html__( "Button text", "helpmate" ),
            "param_name" => "btn_text", 
            "description" => esc_html__( "Enter button text", "helpmate" ),
            'group' => esc_html__( 'Caption', 'helpmate' )
        ),
    );
    vc_add_params('vc_single_image', $attributes); 
    }
    add_action('vc_before_init', 'helpmate_vc_single_image'); 

    function helpmate_vc_row() {
        $attributes = array(
            array(
                'type' => 'checkbox',
                'heading' => esc_html__("Wrapped row in container", "helpmate"),
                'param_name' => 'row_wrap',
                'value' => array( esc_html__( 'Yes', 'helpmate' ) => 'yes' ),
                'weight' => 5,
            ),
        );
        vc_add_params('vc_row', $attributes); 
    }
    add_action('vc_before_init', 'helpmate_vc_row'); 

    function helpmate_vc_heading() {
        $attributes = array(
        array(
            'type' => 'dropdown',
            'param_name' => 'heading_style',
            'value' => array(
                esc_html__('Default', 'helpmate') => 'default',
                esc_html__('Helpmate main title', 'helpmate') => 'helpmate_style',             
            ),
            'heading' => esc_html__('Style', 'helpmate'),
            'description' => esc_html__('Select accordion display style.', 'helpmate'),
            'group' => esc_html__( 'Style', 'helpmate' )
        ),
		array(
			'type' => 'textarea',
			'param_name' => 'first_heading',
			'value' => '',
			'heading' => esc_html__('First heading', 'helpmate'),
			'group' => esc_html__('First Heading', 'helpmate')
		),
        );
        vc_add_params('vc_custom_heading', $attributes); // Note: 'vc_message' was used as a base for "Message box" element
    }
    add_action('vc_before_init', 'helpmate_vc_heading');
?>