<?php
class Helpmate_Widget_Recent_Work extends WP_Widget {

	/**
	 * Sets up a new Recent Work widget instance.
	 *
	 * @since 2.8.0
	 * @access public
	 */
	public function __construct() {
		$widget_ops = array('classname' => 'widget_post_blog', 'description' => esc_html__( "Your site&#8217;s most recent Work.", "helpmate") );
		parent::__construct('recent-work', esc_html__('Recent Work', 'helpmate'), $widget_ops);
		$this->alt_option_name = 'widget_recent_entries';
	}

	/**
	 * Outputs the content for the current Recent Work widget instance.
	 *
	 * @since 2.8.0
	 * @access public
	 *
	 * @param array $args     Display arguments including 'before_title', 'after_title',
	 *                        'before_widget', and 'after_widget'.
	 * @param array $instance Settings for the current Recent Work widget instance.
	 */
	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';

		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
		if ( ! $number )
			$number = 5;
		$show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : false;

		/**
		 * Filter the arguments for the Recent Work widget.
		 *
		 * @since 3.4.0
		 *
		 * @see WP_Query::get_Work()
		 *
		 * @param array $args An array of arguments used to retrieve the recent Work.
		 */
		$r = new WP_Query( apply_filters( 'widget_work_args', array(
			'posts_per_page'      => $number,
			'no_found_rows'       => true,
			'post_status'         => 'publish',
			'ignore_sticky_Work' => true,
			'post_type' => 'gallery'
		) ) );
		$slide_id = 'recent_work_' . wp_rand();
		if ($r->have_posts()) :
		?>
		<?php echo ($args['before_widget']); ?>
		<?php if ( $title ) {
			echo ($args['before_title'] . $title . $args['after_title']);
		} ?>
		<div class="carousel_type_3">
			<div id="<?php echo esc_attr($slide_id); ?>" class="owl-carousel">
			<?php while ( $r->have_posts() ) : $r->the_post(); ?>
				<div class="item clearfix">
					<?php if (has_post_thumbnail()): ?>
						<?php 		                    
							$attachment_id = get_post_thumbnail_id();
		                    $attachment_grid = helpmate_get_attachment($attachment_id, 'helpmate_portfolio_widget'); 
		                    ?>
		                    
						<figure><img class="img-responsive" width="<?php echo esc_attr($attachment_grid['width']) ?>" height="<?php echo esc_attr($attachment_grid['height']) ?>" src="<?php echo esc_url($attachment_grid['src']) ?>" alt="<?php echo esc_attr($attachment_grid['alt']) ?>" /></figure>
	                <?php endif;?>
	                	<a href="<?php the_permalink(); ?>"><h6><?php get_the_title() ? the_title() : the_ID(); ?></h6></a>		
	                
				</div>
			<?php endwhile; ?>
			</div>
			<script type="text/javascript">
	            jQuery(function ($) {
	                var owl = $("#<?php echo esc_js($slide_id); ?>");
	                owl.owlCarousel({
	                   	items: 1,
	                   	nav:true,
	                   	navText : false
	                }); //end: owl
	            });
	        </script>
		</div>
		<?php echo ($args['after_widget']); ?>
		<?php
		// Reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();

		endif;
	}

	/**
	 * Handles updating the settings for the current Recent Work widget instance.
	 *
	 * @since 2.8.0
	 * @access public
	 *
	 * @param array $new_instance New settings for this instance as input by the user via
	 *                            WP_Widget::form().
	 * @param array $old_instance Old settings for this instance.
	 * @return array Updated settings to save.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['number'] = (int) $new_instance['number'];
		$instance['show_date'] = isset( $new_instance['show_date'] ) ? (bool) $new_instance['show_date'] : true;
		return $instance;
	}

	/**
	 * Outputs the settings form for the Recent Work widget.
	 *
	 * @since 2.8.0
	 * @access public
	 *
	 * @param array $instance Current settings.
	 */
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
		$show_date = isset( $instance['show_date'] ) ? (bool) $instance['show_date'] : true;
?>
		<p><label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php echo esc_html__( 'Title:', 'helpmate' ); ?></label>
		<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>

		<p><label for="<?php echo esc_attr($this->get_field_id( 'number' )); ?>"><?php echo esc_html__( 'Number of Work to show:', 'helpmate' ); ?></label>
		<input class="tiny-text" id="<?php echo esc_attr($this->get_field_id( 'number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number' )); ?>" type="number" step="1" min="1" value="<?php echo esc_attr($number); ?>" size="3" /></p>

		<p><input class="checkbox" type="checkbox"<?php checked( $show_date ); ?> id="<?php echo esc_attr($this->get_field_id( 'show_date' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'show_date' )); ?>" />
		<label for="<?php echo esc_attr($this->get_field_id( 'show_date' )); ?>"><?php echo esc_html__( 'Display post date?', 'helpmate' ); ?></label></p>
<?php
	}
}
add_action( 'widgets_init', create_function( '', 'register_widget( "Helpmate_Widget_Recent_Work" );' ) );
