<?php 
add_action('widgets_init', 'helpmate_tabs_load_widgets');
function helpmate_tabs_load_widgets()
{
    register_widget('Helpmate_Tabs');
}

class Helpmate_Tabs extends WP_Widget {
	function __construct(){
        parent::__construct (
	      'helpmate_tabs', 
	      'Helpmate Post Tabs', 
	      array(
	      	'classname' => 'widget_helpmate_tabs',
	        'description' => 'Display posts ordering by popular, recent posts and recent comments' 
	      )
	    );
    }
    function form($instance){
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';	
		$title_tab1     = isset( $instance['title_tab1'] ) ? esc_attr( $instance['title_tab1'] ) : 'Popular';	
		$title_tab2     = isset( $instance['title_tab2'] ) ? esc_attr( $instance['title_tab2'] ) : 'Recent';	
		$title_tab3     = isset( $instance['title_tab3'] ) ? esc_attr( $instance['title_tab3'] ) : 'Comments';	
		$show_popular = isset( $instance['show_popular'] ) ? (bool) $instance['show_popular'] : true;
		$show_recent = isset( $instance['show_recent'] ) ? (bool) $instance['show_recent'] : true;
		$show_comment = isset( $instance['show_comment'] ) ? (bool) $instance['show_comment'] : true;
        $number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 3;
         $number1    = isset( $instance['number1'] ) ? absint( $instance['number1'] ) : 3;
          $number2    = isset( $instance['number2'] ) ? absint( $instance['number2'] ) : 3;
        ?>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title')); ?>">
                <strong><?php echo esc_html__('Title', 'helpmate') ?>:</strong>
                <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" value="<?php if (isset($instance['title'])) echo esc_attr($instance['title']); ?>" />
            </label>
        </p>
		<p><input class="checkbox" type="checkbox"<?php checked( $show_popular ); ?> id="<?php echo esc_attr($this->get_field_id( 'show_popular' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'show_popular' )); ?>" />
		<label for="<?php echo esc_attr($this->get_field_id( 'show_popular' )); ?>"><?php echo esc_html__( 'Display popular tab', 'helpmate' ); ?></label></p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title_tab1')); ?>">
                <strong><?php echo esc_html__('(Popular tab) Tab 1 title', 'helpmate') ?>:</strong>
                <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id('title_tab1')); ?>" name="<?php echo esc_attr($this->get_field_name('title_tab1')); ?>" value="<?php if (isset($instance['title_tab1'])) echo esc_attr($instance['title_tab1']); ?>" />
            </label>
        </p>
        <p><label for="<?php echo esc_attr($this->get_field_id( 'number' )); ?>"><?php echo esc_html__( 'Number of popular posts to show:', 'helpmate' ); ?></label>
		<input class="tiny-text" id="<?php echo esc_attr($this->get_field_id( 'number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number' )); ?>" type="number" step="1" min="1" value="<?php echo esc_attr($number); ?>" size="3" /></p>
        <p><input class="checkbox" type="checkbox"<?php checked( $show_recent ); ?> id="<?php echo esc_attr($this->get_field_id( 'show_recent' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'show_recent' )); ?>" />
		<label for="<?php echo esc_attr($this->get_field_id( 'show_recent' )); ?>"><?php echo esc_html__( 'Display recent tab', 'helpmate' ); ?></label></p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title_tab2')); ?>">
                <strong><?php echo esc_html__('(Recent tab) Tab 2 title', 'helpmate') ?>:</strong>
                <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id('title_tab2')); ?>" name="<?php echo esc_attr($this->get_field_name('title_tab2')); ?>" value="<?php if (isset($instance['title_tab2'])) echo esc_attr($instance['title_tab2']); ?>" />
            </label>
        </p>
        <p><label for="<?php echo esc_attr($this->get_field_id( 'number1' )); ?>"><?php echo esc_html__( 'Number of recent posts to show:', 'helpmate' ); ?></label>
		<input class="tiny-text" id="<?php echo esc_attr($this->get_field_id( 'number1' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number1' )); ?>" type="number" step="1" min="1" value="<?php echo esc_attr($number1); ?>" size="3" /></p>
        <p><input class="checkbox" type="checkbox"<?php checked( $show_comment ); ?> id="<?php echo esc_attr($this->get_field_id( 'show_comment' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'show_comment' )); ?>" />
		<label for="<?php echo esc_attr($this->get_field_id( 'show_comment' )); ?>"><?php echo esc_html__( 'Display comment tab', 'helpmate' ); ?></label></p>
        <p>
            <label for="<?php echo esc_attr($this->get_field_id('title_tab3')); ?>">
                <strong><?php echo esc_html__('(Comment tab) Tab 3 title', 'helpmate') ?>:</strong>
                <input type="text" class="widefat" id="<?php echo esc_attr($this->get_field_id('title_tab3')); ?>" name="<?php echo esc_attr($this->get_field_name('title_tab3')); ?>" value="<?php if (isset($instance['title_tab3'])) echo esc_attr($instance['title_tab3']); ?>" />
            </label>
        </p>
        <p><label for="<?php echo esc_attr($this->get_field_id( 'number2' )); ?>"><?php echo esc_html__( 'Number of posts have comment to show:', 'helpmate' ); ?></label>
		<input class="tiny-text" id="<?php echo esc_attr($this->get_field_id( 'number2' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number2' )); ?>" type="number" step="1" min="1" value="<?php echo esc_attr($number2); ?>" size="3" /></p>
        <?php
    }
    function update($new_instance, $old_instance){
    	$instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['title_tab1'] = strip_tags($new_instance['title_tab1']);
        $instance['title_tab2'] = strip_tags($new_instance['title_tab2']);
        $instance['title_tab3'] = strip_tags($new_instance['title_tab3']);
		$instance['show_popular'] = isset( $new_instance['show_popular'] ) ? (bool) $new_instance['show_popular'] : false;
		$instance['show_recent'] = isset( $new_instance['show_recent'] ) ? (bool) $new_instance['show_recent'] : false;
		$instance['show_comment'] = isset( $new_instance['show_comment'] ) ? (bool) $new_instance['show_comment'] : false;
		$instance['number'] = (int) $new_instance['number'];
		$instance['number1'] = (int) $new_instance['number1'];
		$instance['number2'] = (int) $new_instance['number2'];

        return $instance;
    }
    function widget($args, $instance){
    	extract($args);
        $title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : '';
        $title_tab1 = ( ! empty( $instance['title_tab1'] ) ) ? $instance['title_tab1'] : 'Popular';
        $title_tab2 = ( ! empty( $instance['title_tab2'] ) ) ? $instance['title_tab2'] : 'Recent';
        $title_tab3 = ( ! empty( $instance['title_tab3'] ) ) ? $instance['title_tab3'] : 'Comment';
		$show_popular = isset( $instance['show_popular'] ) ? $instance['show_popular'] : true;
		$show_recent = isset( $instance['show_recent'] ) ? $instance['show_recent'] : true;
		$show_comment = isset( $instance['show_comment'] ) ? $instance['show_comment'] : true;
		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 3;
		$number1 = ( ! empty( $instance['number1'] ) ) ? absint( $instance['number1'] ) : 3;
		$number2 = ( ! empty( $instance['number2'] ) ) ? absint( $instance['number2'] ) : 3;
        ?>
        <?php echo ($args['before_widget']); ?>
		<?php if ( $title ) {
			echo ($args['before_title'] . $title . $args['after_title']);
		} ?>
        <div class="tabs">
        <!--tabs navigation-->
            <div class="clearfix tabs_conrainer">
                <ul class="tabs_nav clearfix">
                	<?php if($show_popular):?>
                  		<li class=""><a href="#tab-1"><?php echo wp_kses($title_tab1,array());?></a></li>
                  	<?php endif;?>
                  	<?php if($show_recent):?>
                  	<li class=""><a href="#tab-2"><?php echo wp_kses($title_tab2,array());?></a></li>
                  	<?php endif;?>
                  	<?php if($show_comment):?>
                  	<li class=""><a href="#tab-3"><?php echo wp_kses($title_tab3,array());?></a></li>
                  	<?php endif;?>
                </ul>
            </div>
            <?php $title =""?>
              <!--tabs content-->
            <div class="tabs_content">
            	<?php if($show_popular):?>
                <div id="tab-1">
					<?php 
                		$r = new WP_Query( apply_filters( 'widget_posts_args', array(
							'posts_per_page'      => $number,
							'no_found_rows'       => true,
							'meta_key' => 'post_views_count',
							'orderby' => 'meta_value_num',
							'post_status'         => 'publish',
							'ignore_sticky_posts' => true
						) ) );
						if ($r->have_posts()) :?>
							<?php while ( $r->have_posts() ) : $r->the_post(); ?>
								<div class="mad_img_post clearfix">
									<?php if (has_post_thumbnail()): ?>
										<?php $blogImages = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()) ); ?>
										<a href="<?php the_permalink(); ?>">
				                          	<img width="80" height="80" src="<?php echo esc_url($blogImages[0]); ?>" alt="blog-img">
				                        </a>
					                <?php endif;?>	
					                	<span><?php echo esc_html__('On','helpmate')?> <?php echo get_the_date('F d, Y'); ?></span>			
										<h5><a href="<?php the_permalink(); ?>"><?php get_the_title() ? the_title() : the_ID(); ?></a></h5>
								</div>
							<?php endwhile; ?>
					<?php endif;?>
                </div>
            	<?php endif;?>
            	<?php if($show_recent):?>
                <div id="tab-2">
                	<?php 
                		$r = new WP_Query( apply_filters( 'widget_posts_args', array(
							'posts_per_page'      => $number1,
							'no_found_rows'       => true,
							'post_status'         => 'publish',
							'ignore_sticky_posts' => true
						) ) );
						if ($r->have_posts()) :?>
							<?php while ( $r->have_posts() ) : $r->the_post(); ?>
								<div class="mad_img_post clearfix">
									<?php if (has_post_thumbnail()): ?>
										<?php $blogImages = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()) ); ?>
										<a href="<?php the_permalink(); ?>">
				                          	<img width="80" height="80" src="<?php echo esc_url($blogImages[0]); ?>" alt="blog-img">
				                        </a>
					                <?php endif;?>		
					                	<span><?php echo esc_html__('On','helpmate')?> <?php echo get_the_date('F d, Y'); ?></span>			
										<h5><a href="<?php the_permalink(); ?>"><?php get_the_title() ? the_title() : the_ID(); ?></a></h5>
								</div>
							<?php endwhile; ?>
					<?php endif;?>
                </div>
                <?php endif;?>
                <?php if($show_comment):?>
                <div id="tab-3">
					<?php  $comments = get_comments('status=approve&number='.$number2.'&post_type=post');
			        foreach ($comments as $comment) :?>
			        <?php $post= get_post($comment->comment_post_ID);?>

					<div class="mad_img_post clearfix">
						<?php if (has_post_thumbnail()): ?>
							<?php $blogImages = wp_get_attachment_image_src( get_post_thumbnail_id($comment->comment_post_ID) ); ?>
							<a href="<?php the_permalink(); ?>">
			                  	<img width="80" height="80" src="<?php echo esc_url($blogImages[0]); ?>" alt="blog-img">
			                </a>
			            <?php endif;?>		
			            	<span><?php echo esc_html__('On','helpmate')?> <?php comment_date( 'F d, Y', $comment->comment_ID); ?></span>			
							<h5><a href="<?php the_permalink(); ?>"><?php echo wp_kses($post->post_title,array()); ?></a></h5>
					</div>
			        <?php endforeach;?> 
                </div>
                <?php endif;?>
            </div>
        </div>
        <?php echo ($args['after_widget']); ?>
        <?php 

        wp_reset_postdata();	

    }
}
?>