<?php
//remove action
remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart');
remove_action('woocommerce_after_shop_loop_item_title','woocommerce_template_loop_rating', 5 );
remove_action('woocommerce_after_shop_loop_item_title','woocommerce_template_loop_price', 10);
remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20);
remove_action('woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
remove_action('woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
remove_action( 'woocommerce_cart_collaterals',
'woocommerce_cross_sell_display' );
//add action
add_action ('woocommerce_after_cart', 'woocommerce_cross_sell_display');
add_action('woocommerce_before_shop_loop', 'helpmate_product_loop_view_mode', 40);
add_action('woocommerce_archive_description', 'helpmate_category_image', 5);
add_action('woocommerce_before_shop_loop_item_title', 'woocommerce_show_product_loop_sale_flash', 15);
add_action('woocommerce_after_shop_loop_item_title','woocommerce_template_loop_rating', 10 );
add_action('woocommerce_after_shop_loop_item_title','woocommerce_template_loop_price', 5);
add_action( 'after_setup_theme', 'helpmate_woocommerce_support' );
add_action( 'woocommerce_single_product_summary', 'helpmate_position_wishlist_button', 51 );
//add filter
add_filter('woocommerce_add_to_cart_fragments', 'helpmate_woocommerce_header_add_to_cart_fragment');
add_filter('loop_shop_per_page', 'helpmate_product_shop_per_page', 20);
add_filter( 'woocommerce_billing_fields' , 'helpmate_override_billing_fields' );
add_filter( 'woocommerce_shipping_fields' , 'helpmate_override_shipping_fields' );
add_filter('woocommerce_checkout_fields', 'helpmate_custom_override_checkout_fields');
add_filter("woocommerce_checkout_fields", "helpmate_order_fields");
add_filter("woocommerce_checkout_fields", "helpmate_order_shipping_fields");
add_filter( 'woocommerce_get_price_html', 'helpmate_price_html', 100, 2 );
add_filter( 'wc_add_to_cart_message_html', 'helpmate_add_to_cart_message' );
add_filter( 'woocommerce_output_related_products_args', 'helpmate_related_products_args' );
add_filter( 'woocommerce_product_add_to_cart_text' , 'helpmate_woocommerce_product_add_to_cart_text' );
function helpmate_woocommerce_support() {
    add_theme_support( 'woocommerce' );
}
//update cart items on minicart
function helpmate_woocommerce_header_add_to_cart_fragment($fragments) {
    $_cartQty = WC()->cart->cart_contents_count;
    $fragments['.number-product'] = '<p class="number-product">' . $_cartQty . '</p>';
    return $fragments;
}
function helpmate_price_html($price){
    $array1 = array('<ins><span class="amount">','</span></ins>');
    $replace_arr   = array('<ins>', '</ins>');
    $price_arr = str_replace($array1, $replace_arr, $price);;
    return $price_arr;
}
function helpmate_position_wishlist_button($product) {
    global $helpmate_settings;
    ?>
    <?php if($helpmate_settings['single_product_share']):?>
    <div class="horisontal_list soc_count_list">

      <span><?php echo esc_html__('Share:','helpmate'); ?></span>
      <ul>
        <li>
        <?php     
            if ( class_exists('YITH_WCWL') && $helpmate_settings['product-wishlist'] && shortcode_exists('yith_wcwl_add_to_wishlist') ) {
                echo do_shortcode( "[yith_wcwl_add_to_wishlist]" );
            }
        ?>
        
        </li>
        <li><a href="http://www.facebook.com/sharer.php?u=<?php echo urlencode(get_the_permalink()); ?>" target="_blank"><i class="icon-facebook-3"></i> <?php echo helpmate_get_fb_share(get_the_permalink());?></a></li>
        <li><a href="https://pinterest.com/pin/create/button/?url=<?php echo urlencode(get_the_permalink()); ?>&media=<?php echo urlencode(wp_get_attachment_url( get_post_thumbnail_id() )); ?>&description=<?php echo urlencode(get_the_title()); ?>" target="_blank"><i class="icon-pinterest-circled"></i><?php echo helpmate_get_pinterest_share(get_the_permalink());?></a></li>
      </ul>

    </div>
    <?php endif;?>
    <?php 
}

function helpmate_add_to_cart_message() {
    if ( get_option( 'woocommerce_cart_redirect_after_add' ) == 'yes' ) :
        $message = sprintf( '<p>%s</p><a href="%s" class="class="button type3"><span><span>%s</span><span>%s</span></span></a>', esc_html__( 'Successfully added to cart.', 'helpmate' ), esc_url( get_permalink( wc_get_page_id( 'shop' ) ) ), esc_html__( 'Continue Shopping', 'helpmate' ),esc_html__( 'Continue Shopping', 'helpmate' ) );
    else :
        $message = sprintf( '<p>%s</p><a href="%s" class="button type3"><span><span>%s</span><span>%s</span></span></a>', esc_html__( 'Successfully added to cart.' , 'helpmate' ), esc_url( get_permalink( wc_get_page_id( 'cart' ) ) ), esc_html__( 'View Cart', 'helpmate' ), esc_html__( 'View Cart', 'helpmate' ) );
    endif;
    return $message;
}


function helpmate_related_products_args( $args ) {
    $helpmate_settings = helpmate_check_theme_options();
    global $helpmate_sidebar_pos, $helpmate_layout, $helpmate_sidebar;
    $args['posts_per_page'] = 4; // 4 related products
    if (($helpmate_sidebar_pos == 'left-sidebar' || $helpmate_sidebar_pos == 'right-sidebar') && $helpmate_sidebar && is_active_sidebar($helpmate_sidebar)){
        $args['posts_per_page'] = 3; // 4 related products
    }
    return $args;
}
//function
function helpmate_product_loop_view_mode() {
    global $helpmate_settings, $wp_query;
    $cat = $wp_query->get_queried_object();
    if(isset($cat->term_id)){
    $woo_cat = $cat->term_id;
    }else{
        $woo_cat = '';
    }
    $product_list_mode = get_metadata('product_cat', $woo_cat, 'list_mode_product', true);
    if(is_product_category()) :
    ?>
    <div class="f_right">
        <div class="mad_layout_buttons viewmode-toggle">
            <?php if($product_list_mode == 'only-grid') : ?>
            <button class="black_button_active" id="grid_mode" data-isotope-layout="grid" data-isotope-container="#can_change_layout" title="<?php echo esc_html__('Grid View', 'helpmate') ?>"><i class="icon-th-3"></i></button>
            <?php elseif($product_list_mode == 'only-list'):?>
            <button class="black_button_active" data-isotope-layout="list" data-isotope-container="#can_change_layout" id="list_mode" title="<?php echo esc_html__('List View', 'helpmate') ?>"><i class="icon-th-list-4"></i></button>
            <?php elseif($product_list_mode == 'list-default'):?>
                <button class="black_hover" id="grid_mode" data-isotope-layout="grid" data-isotope-container="#can_change_layout" title="<?php echo esc_html__('Grid View', 'helpmate') ?>"><i class="icon-th-3"></i></button>
                <button class="black_button_active" data-isotope-layout="list" data-isotope-container="#can_change_layout" id="list_mode" title="<?php echo esc_html__('List View', 'helpmate') ?>"><i class="icon-th-list-4"></i></button>
            <?php else:?>
                <button class="black_button_active" id="grid_mode" data-isotope-layout="grid" data-isotope-container="#can_change_layout" title="<?php echo esc_html__('Grid View', 'helpmate') ?>"><i class="icon-th-3"></i></button>
                <button class="black_hover" data-isotope-layout="list" data-isotope-container="#can_change_layout" id="list_mode" title="<?php echo esc_html__('List View', 'helpmate') ?>"><i class="icon-th-list-4"></i></button>
            <?php endif;?>
        </div>
    </div>   
    <?php
    endif;
}
function helpmate_category_image() {
    if (is_product_category()) {
        global $wp_query;
        $cat = $wp_query->get_queried_object();
        $thumbnail_id = get_woocommerce_term_meta($cat->term_id, 'thumbnail_id', true);
        $image = wp_get_attachment_url($thumbnail_id);
        if ($image) {
            echo '<figure class="mad_bottom2"><img src="' . esc_url($image) . '" class="category-image" alt="" /></figure>';
        }
    }
}
function helpmate_banner_bottom_woocommerce(){
    global $helpmate_settings;
    ?>
    <?php if ((is_woocommerce() || is_cart() || is_checkout()) && $helpmate_settings['banner_product'] && $helpmate_settings['banner_product']['url']): ?>
    <div class="hot_line var2 align_center">
        <div class="container">
            <?php
                echo '<img class="" src="' . esc_url(str_replace(array('http:', 'https:'), '', $helpmate_settings['banner_product']['url'])) . '" alt="' . esc_attr(get_bloginfo('name', 'display')) . '" />';
            ?>
        </div>
    </div>
    <?php endif;?>
    <?php
}
function helpmate_order_fields($fields) {
    $order = array(
        "billing_country",
        "billing_first_name", 
        "billing_last_name", 
        "billing_company", 
        "billing_address_1", 
        "billing_address_2",
        "billing_city",   
        "billing_postcode",       
        "billing_email", 
        "billing_phone"
    );
    foreach($order as $field)
    {
        $ordered_fields[$field] = $fields["billing"][$field];
    }

    $fields["billing"] = $ordered_fields;
    return $fields;

}
function helpmate_order_shipping_fields($fields) {
    $order = array(
        "shipping_country",
        "shipping_first_name", 
        "shipping_last_name", 
        "shipping_company", 
        "shipping_address_1",
        "shipping_address_2",
        "shipping_city",        
        "shipping_postcode",
        "shipping_phone",       
        "shipping_email", 
        
    );
    foreach($order as $field)
    {
        $ordered_fields[$field] = $fields["shipping"][$field];
    }

    $fields["shipping"] = $ordered_fields;
    return $fields;

}

function helpmate_product_shop_per_page() {
    global $helpmate_settings;
    parse_str($_SERVER['QUERY_STRING'], $params);

    // replace it with theme option
    if ($helpmate_settings['category-item']) {
        $per_page = explode(',', $helpmate_settings['category-item']);
    } else {
        $per_page = explode(',', '12,24,36');
    }

    $item_count = !empty($params['count']) ? $params['count'] : $per_page[0];

    return $item_count;
}
function helpmate_override_billing_fields( $fields ) {
  $fields['billing_first_name'] = array(
        'label' => esc_html__('First Name','helpmate'),
        'placeholder' => _x('First Name *', 'placeholder', 'helpmate'),
        'required' => true,
    );
    $fields['billing_last_name'] = array(
        'label' => esc_html__('Last Name','helpmate'),
        'placeholder' => _x('Last Name *', 'placeholder', 'helpmate'),
        'required' => true,
    );
  $fields['billing_company'] = array(
        'label' => esc_html__('Company name','helpmate'),
        'placeholder' => _x('Company Name', 'placeholder', 'helpmate'),
        'required' => false,
    );
  $fields['billing_email'] = array(
        'label' => esc_html__('Email','helpmate'),
        'placeholder' => _x('E-mail *', 'placeholder', 'helpmate'),
        'required' => true,
    );
  $fields['billing_phone'] = array(
        'label' => esc_html__('Phone','helpmate'),
        'placeholder' => _x('Phone *', 'placeholder', 'helpmate'),
        'required' => true,
    );
  $fields['billing_address_1'] = array(
        'label' => esc_html__('Address','helpmate'),
        'placeholder' => _x('Address', 'placeholder', 'helpmate'),
        'required' => false,
    );
  $fields['billing_address_2'] = array(
        'label' => esc_html__('Apartment, suite, unit etc. (optional)','helpmate'),
        'placeholder' => _x('Apartment, suite, unit etc. (optional)', 'placeholder', 'helpmate'),
        'required' => false,
    );
  $fields['billing_postcode'] = array(
        'label' => esc_html__('Postcode / Zip','helpmate'),
        'placeholder' => _x('Postcode / Zip *', 'placeholder', 'helpmate'),
        'required' => true,
    );
  $fields['billing_city'] = array(
        'label' => esc_html__('Town / City','helpmate'),
        'placeholder' => _x('Town / City *', 'placeholder', 'helpmate'),
        'required' => true,
    );
  $fields['billing_phone'] = array(
        'label' => esc_html__('Phone','helpmate'),
        'placeholder' => _x('Phone *', 'placeholder', 'helpmate'),
        'required' => true,
    );
  return $fields;
}

function helpmate_override_shipping_fields( $fields ) {
  $fields['shipping_first_name'] = array(
        'label' => esc_html__('First Name','helpmate'),
        'placeholder' => _x('First Name *', 'placeholder', 'helpmate'),
        'required' => true,
    );
    $fields['shipping_last_name'] = array(
        'label' => esc_html__('Last Name','helpmate'),
        'placeholder' => _x('Last Name *', 'placeholder', 'helpmate'),
        'required' => true,
    );
  $fields['shipping_company'] = array(
        'label' => esc_html__('Company name','helpmate'),
        'placeholder' => _x('Company Name', 'placeholder', 'helpmate'),
        'required' => false,
    );
  $fields['shipping_email'] = array(
        'label' => esc_html__('Email','helpmate'),
        'placeholder' => _x('E-mail *', 'placeholder', 'helpmate'),
        'required' => true,
    );
  $fields['shipping_phone'] = array(
        'label' => esc_html__('Phone','helpmate'),
        'placeholder' => _x('Phone *', 'placeholder', 'helpmate'),
        'required' => true,
    );
  $fields['shipping_address_1'] = array(
        'label' => esc_html__('Address','helpmate'),
        'placeholder' => _x('Address *', 'placeholder', 'helpmate'),
        'required' => true,
    );
  $fields['shipping_address_2'] = array(
        'label' => esc_html__('Apartment, suite, unit etc. (optional)','helpmate'),
        'placeholder' => _x('Apartment, suite, unit etc. (optional)', 'placeholder', 'helpmate'),
        'required' => false,
    );
  $fields['shipping_postcode'] = array(
        'label' => esc_html__('Postcode / Zip','helpmate'),
        'placeholder' => _x('Postcode / Zip *', 'placeholder', 'helpmate'),
        'required' => true,
    );
  $fields['shipping_city'] = array(
        'label' => esc_html__('Town / City','helpmate'),
        'placeholder' => _x('Town / City *', 'placeholder', 'helpmate'),
        'required' => true,
    );
  $fields['shipping_phone'] = array(
        'label' => esc_html__('Phone','helpmate'),
        'placeholder' => _x('Phone *', 'placeholder', 'helpmate'),
        'required' => true,
    );
  return $fields;
}
function helpmate_custom_override_checkout_fields($fields) {

    $fields['billing']['billing_first_name'] = array(
        'label' => esc_html__('First Name','helpmate'),
        'placeholder' => _x('First Name *', 'placeholder', 'helpmate'),
        'required' => true,
    );
    $fields['billing']['billing_last_name'] = array(
        'label' => esc_html__('Last Name','helpmate'),
        'placeholder' => _x('Last Name *', 'placeholder', 'helpmate'),
        'required' => true,
    );
    $fields['billing']['billing_company'] = array(
        'label' => '',
        'placeholder' => _x('Company Name', 'placeholder', 'helpmate'),
        'required' => false,
        'class'     => array('form-row-wide'),
    );
    $fields['billing']['billing_address_1'] = array(
        'label' => '',
        'placeholder' => _x('Address', 'placeholder', 'helpmate'),
        'required' => false,
        'class'     => array('form-row-wide'),
    );
    $fields['billing']['billing_address_2'] = array(
        'label' => '',
        'placeholder' => _x('Enter Your Apartment', 'placeholder', 'helpmate'),
        'required' => false,
    );
    $fields['billing']['billing_city'] = array(
        'label' => esc_html__('City','helpmate'),
        'placeholder' => _x('City *', 'placeholder', 'helpmate'),
        'required' => true,
    );
    $fields['billing']['billing_postcode'] = array(
        'label' => esc_html__('Postcode / Zip','helpmate'),
        'placeholder' => _x('Postcode / Zip *', 'placeholder', 'helpmate'),
        'required' => true,
        'value' => '',
    );
    $fields['billing']['billing_email'] = array(
        'label' => esc_html__('Email Address','helpmate'),
        'placeholder' => _x('E-mail *', 'placeholder', 'helpmate'),
        'required' => true,
    );
    $fields['billing']['billing_phone'] = array(
        'label' => esc_html__('Phone','helpmate'),
        'placeholder' => _x('Phone *', 'placeholder', 'helpmate'),
        'required' => true,
    );
    $fields['billing']['billing_state'] = array(
        'label' => esc_html__('State / County','helpmate'),
        'placeholder' => _x('State / County', 'placeholder', 'helpmate'),
        'required' => false,
    );
    $fields['shipping']['shipping_phone'] = array(
        'label' => esc_html__('Phone','helpmate'),
        'placeholder'   => _x('Phone Number *', 'placeholder', 'helpmate'),
        'required'  => true,
     );
    $fields['shipping']['shipping_first_name'] = array(
        'label' => esc_html__('First Name','helpmate'),
        'placeholder' => _x('First Name *', 'placeholder', 'helpmate'),
        'required' => true,
    );
    $fields['shipping']['shipping_last_name'] = array(
        'label' => esc_html__('Last Name','helpmate'),
        'placeholder' => _x('Last Name *', 'placeholder', 'helpmate'),
        'required' => true,
    );
    $fields['shipping']['shipping_company'] = array(
        'label' => esc_html__('Company name','helpmate'),
        'placeholder' => _x('Company Name', 'placeholder', 'helpmate'),
        'required' => false,
        'class'     => array('form-row-wide'),
    );
    $fields['shipping']['shipping_city'] = array(
        'label' => esc_html__('City','helpmate'),
        'placeholder' => _x('City *', 'placeholder', 'helpmate'),
        'required' => true,
    );
    $fields['shipping']['shipping_state'] = array(
        'label' => esc_html__('Enter State/Country','helpmate'),
        'placeholder' => _x('Enter State/Country *', 'placeholder', 'helpmate'),
        'required' => false,
    );
    $fields['shipping']['shipping_email'] = array(
        'label' => esc_html__('Email Address','helpmate'),
        'placeholder' => _x('E-mail *', 'placeholder', 'helpmate'),
        'required' => true,
    );
    $fields['shipping']['shipping_postcode'] = array(
        'label' => esc_html__('Postcode / Zip','helpmate'),
        'placeholder' => _x('Postal Code *', 'placeholder', 'helpmate'),
        'required' => true,
    );
    $fields['shipping']['shipping_address_1'] = array(
        'label' => esc_html__('Address','helpmate'),
        'placeholder' => _x('Address *', 'placeholder', 'helpmate'),
        'required' => true,
        'class'     => array('form-row-wide'),
    );
    $fields['order']['order_comments'] = array(
        'label' => esc_html__('Order notes','helpmate'),
        'placeholder' => _x('Order Notes', 'placeholder', 'helpmate'),
        'required' => false,
        'type' => 'textarea',
        'class'     => array('form-row-wide'),
    );
    

    return $fields;
}

function helpmate_woocommerce_product_add_to_cart_text() {
    global $product;
    
    $product_type = $product->get_type();
    
    switch ( $product_type ) {
        case 'external':
            return esc_html__( 'Buy product', 'helpmate' );
        break;
        case 'grouped':
            return esc_html__( 'View products', 'helpmate' );
        break;
        case 'simple':
            return esc_html__( 'Add to cart', 'helpmate' );
        break;
        case 'variable':
            return esc_html__( 'Select options', 'helpmate' );
        break;
        default:
            return '';
    }
    
}
//change text sort by
add_filter( 'gettext', 'helpmate_sort_change', 20, 3 );
function helpmate_sort_change( $translated_text, $text, $domain ) {

    if ( is_woocommerce() ) {

        switch ( $translated_text ) {
            case 'Sort by popularity' :

                $translated_text = esc_html__( 'Popularity', 'helpmate' );
                break;
            case 'Sort by average rating' :

                $translated_text = esc_html__( 'Average rating', 'helpmate' );
                break;    
            case 'Sort by newness' :

                $translated_text = esc_html__( 'Newest', 'helpmate' );
                break;
            case 'Sort by price: low to high' :

                $translated_text = esc_html__( 'Low to high', 'helpmate' );
                break;    
            case 'Sort by price: high to low' :

                $translated_text = esc_html__( 'High to low', 'helpmate' );
                break;    
        }

    }

    return $translated_text;
} 
