<?php
//remove wpml language selector style
define('ICL_DONT_LOAD_LANGUAGE_SELECTOR_CSS', true);
//remove wpml currency-switcher style
add_action('wp_print_styles', 'helpmate_dequeue_css_currency_switcher', 100);

function helpmate_dequeue_css_currency_switcher() {
    wp_dequeue_style('currency-switcher');
}

//show currency switcher dropdown list
function helpmate_show_currencies_dropdown() {
    global $helpmate_settings;
    if (class_exists('WCML_CurrencySwitcher') && class_exists('Woocommerce') && $helpmate_settings['header-currency']) {
        global $woocommerce_wpml;
        if (!isset($woocommerce_wpml->multi_currency_support)) {
            return;
        }
        $settings = $woocommerce_wpml->get_settings();
        $current_currency = $woocommerce_wpml->multi_currency_support->get_client_currency();
        $wc_currencies = get_woocommerce_currencies();
        $format_setting = isset($settings['wcml_curr_template']) && $settings['wcml_curr_template'] != '' ? $settings['wcml_curr_template'] : '%name% (%symbol%) - %code%';
        $currency_format = preg_replace(array('#%name%#', '#%symbol%#', '#%code%#'), array($wc_currencies[$current_currency], get_woocommerce_currency_symbol($current_currency), $current_currency), $format_setting);
        ?>
            <div class="currency_custom">
                <a class="current-open" href="#" aria-expanded="false" aria-haspopup="true" data-toggle="dropdown">
                    <?php echo esc_html($currency_format);?>
                </a>
                <div class="dib header-currencies dropdown-menu">
                    <div id="currencyHolder">
                        <?php echo(do_shortcode('[currency_switcher switcher_style="list" orientation="vertical"]')); ?>
                    </div>
                </div>
            </div>
        <?php
    }
}
//show language switcher dropdown list
function helpmate_show_language_dropdown() {
    global $helpmate_settings, $sitepress;
    if( !defined( 'ICL_LANGUAGE_CODE' ) && !isset( $sitepress )) {
        return false;
    }
    $languages = icl_get_languages('skip_missing=0&orderby=code');
    if ($helpmate_settings['header-language']) {
        $language_text = esc_html__('Languages', 'helpmate');
        if(defined('ICL_LANGUAGE_CODE')) {
            $language_text = ICL_LANGUAGE_CODE;
        }
        ?>
        <div class="languges-flags">
            <?php 
            if(!empty($languages)){
                foreach($languages as $l){
                    if($l['active']) echo '<a class="current-open" href="#" aria-expanded="false" aria-haspopup="true" data-toggle="dropdown">';
                    if($l['active']) echo '<img src="'.$l['country_flag_url'].'" height="12" alt="'.$l['language_code'].'" width="18" />';
                    if($l['active']) echo '</a>';
                }
            }
            ?>
            <div class="header-languages dropdown-menu">
                <?php do_action('icl_language_selector'); ?>
            </div>
        </div>
        <?php
    }
}
