<?php
    $image_gallery = get_post_meta(get_the_ID(), 'images_gallery', true);
    $image_banner = get_post_meta(get_the_ID(), 'image_banner', true);
    $client = get_post_meta(get_the_ID(), 'client', true);
    $services = get_post_meta(get_the_ID(), 'services', true);
  ?>  
<div class="mad_blog single-gallery-1">
  
  <div class="row">
    <div class="col-sm-3 col-xs-3">
      
      <h4><?php echo esc_html__('Project Details','helpmate');?></h4>
        <div class="vertical_list">
          <ul>
            <li>
              <span><?php echo esc_html__( 'Date:', 'helpmate' ); ?></span> <?php echo get_the_date();?>
            </li>
            <li>
              <span><?php echo esc_html__( 'Client:', 'helpmate' ); ?></span> <?php echo esc_html($client);?>
            </li>
            <li>
              <span><?php echo esc_html__( 'Services:', 'helpmate' ); ?></span> <?php echo esc_html($services);?>
            </li>
            <li>
              <span><?php echo esc_html__( 'Skills:', 'helpmate' ); ?></span> <?php echo get_the_term_list($post->ID,'gallery_skills', '', ', ' ); ?>
            </li>
            <li>
              <span><?php echo esc_html__( 'Category:', 'helpmate' ); ?></span> <?php echo get_the_term_list($post->ID,'gallery_cat', '', ', ' ); ?>
            </li>
            <li>
              <span><?php echo esc_html__( 'Tags:', 'helpmate' ); ?></span> <?php echo get_the_term_list($post->ID,'gallery_tags', '', ', ' ); ?>
            </li>
          </ul>
        </div>

    </div>
    <div class="col-sm-9 col-xs-9">
      
      <div class="mad_bottom3">
        
        <h4><?php echo esc_html__( 'Description', 'helpmate' ); ?></h4>
        <p class="mad_bottom2">
            <?php echo get_the_content() ;?> 
        </p>
        <div class="horisontal_list soc_count_list">          
          <ul>
            <li> <?php  if(function_exists('helpmate_getPostLikeLink')) {
                    echo helpmate_getPostLikeLink( get_the_ID() );
                                            }
                  ?>
            </li>
            <li><a href="http://www.facebook.com/sharer.php?u=<?php echo urlencode(get_the_permalink()); ?>" target="_blank"><i class="icon-facebook-3"></i> <?php echo helpmate_get_fb_share(get_the_permalink());?></a></li>
            <li><a href="https://twitter.com/share?url=<?php echo urlencode(get_the_permalink()); ?>&amp;text=<?php echo urlencode(get_the_title()); ?>" target="_blank"><i class="fa fa-twitter"></i><?php echo helpmate_get_twitter_share(get_the_permalink());?></a></a></li>
            <li><a href="https://pinterest.com/pin/create/button/?url=<?php echo urlencode(get_the_permalink()); ?>&media=<?php echo urlencode(wp_get_attachment_url( get_post_thumbnail_id() )); ?>&description=<?php echo urlencode(get_the_title()); ?>" target="_blank"><i class="icon-pinterest-circled"></i><?php echo helpmate_get_pinterest_share(get_the_permalink());?></a></li>
          </ul>
        </div>

      </div>
      <div class="clearfix">
        <div class="f_left"><a href="<?php echo get_the_permalink();?>" class="button type1"><span><span><?php echo esc_html__( 'View Project', 'helpmate' ); ?></span><span><?php echo esc_html__( 'View Project', 'helpmate' ); ?></span></span></a></div>
        <div class="f_right">
          <div class="paginations">
              <?php 
                  $previous = ( is_attachment() ) ? get_post(get_post()->post_parent) : get_adjacent_post(false, '', true);
                  $next = get_adjacent_post(false, '', false);
                  $prev_post = get_previous_post();
                  $next_post = get_next_post();
                  ?>
                <ul>
                    <?php
                    if($prev_post){
                    previous_post_link('<li class="arrow_left"><a href="'.get_permalink( $prev_post->ID ).'"></a></li>', '');
                    } ?>
                    <li class="sort"><a href="<?php echo esc_url( home_url( '/' ) ); ?>gallery"></a></li>
                    <?php
                    if($next_post){
                    next_post_link('<li class="arrow_right"><a href="'.get_permalink( $next_post->ID ).'"></a></li>', '');
                    } ?>            
                </ul>
          </div>
        </div>
      </div>

    </div>
  </div>  
</div>