<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' ); ?>
	<?php 
		$helpmate_settings = helpmate_check_theme_options();
		global $helpmate_sidebar_pos, $helpmate_layout, $helpmate_sidebar;
		$class = '';
		if (($helpmate_sidebar_pos == 'left-sidebar' || $helpmate_sidebar_pos == 'right-sidebar') && $helpmate_sidebar && is_active_sidebar($helpmate_sidebar)){
		 	$class .= 'col-lg-9 col-md-9 col-sm-12 col-xs-12 main-sidebar'; 
		}else {
			$class .= 'content-primary'; 
			if($helpmate_layout == 'fullwidth'){
				$class .= ' col-md-12';
			}
		}
		if ($helpmate_sidebar_pos == 'left-sidebar' && is_active_sidebar($helpmate_sidebar)){
			$class .= ' f-right';
		}
	?>
	<div class="<?php echo esc_attr($class);?> mad_shop_page">
		<?php
			/**
			 * woocommerce_before_main_content hook.
			 *
			 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
			 * @hooked woocommerce_breadcrumb - 20
			 */
			do_action( 'woocommerce_before_main_content' );
		?>	
		<?php if(is_product_category()):?>
		<div class="mad_section inset2">
		<?php endif;?>
		<?php
			/**
			 * woocommerce_archive_description hook.
			 *
			 * @hooked woocommerce_taxonomy_archive_description - 10
			 * @hooked woocommerce_product_archive_description - 10
			 */
			do_action( 'woocommerce_archive_description' );
		?>
		<?php if(is_product_category()):?>
		</div>
		<?php endif;?>
		<?php if(is_product_category()) :?>
			<?php if(class_exists('YITH_WCBR')):?>
			<div class="mad_section inset2">       
		        <div class="horisontal_list">
		          <ul>
		            	<?php
				        $args = array(
				        );			      			        
			        	$brands = get_terms('yith_product_brand', $args);
				        foreach ($brands as $_brand) {
				            $thumbnail_id = get_woocommerce_term_meta($_brand->term_id, 'thumbnail_id');
				            $_brand->thumbnail_id = $thumbnail_id;
				            $_brand->brand_url = get_term_link($_brand->slug, 'yith_product_brand');
				            $image = wp_get_attachment_image_src($thumbnail_id, 'full');
				            if ($image) {
				                echo sprintf('<li class="post_area"><figure class="brands-img"><a title="' . $_brand->name . '" href="%s"><img src="%s" alt="%s"/></a></figure><div class="user_info"><h6><a><b>' . $_brand->name . '</b></a></h6></div></li>', get_term_link($_brand), $image[0], $image[1], $image[2], $_brand->name);
				            } else {
				                echo sprintf('<li class="post_area"><figure class="brands-img"><a title="' . $_brand->name . '" href="%s"><img src="%s" alt="%s"/></a></figure><div class="user_info"><h6><a><b>' . $_brand->name . '</b></a></h6></div></li>', get_term_link($_brand), wc_placeholder_img_src(), $_brand->name);
				            }
				        }

				        ?>
		          </ul>
		        </div>
		    </div>
		    <?php endif;?>
		<?php endif;?>
		<?php if ( have_posts() ) : ?>
			<div class="mad_sort_categories">
				<div class="clearfix">
				<?php
					/**
					 * woocommerce_before_shop_loop hook.
					 *
					 * @hooked woocommerce_result_count - 20
					 * @hooked woocommerce_catalog_ordering - 30
					 */
					do_action( 'woocommerce_before_shop_loop' );
				?>
				</div>
				
			</div>
			<?php if(is_product_category()) :?>
			<div class="mad_section inset2">
				<?php
					woocommerce_pagination();
				?>
			</div>
			<?php endif;?>
			<div id="can_change_layout" class="isotope isotope_container three_collumn wrapper" data-isotope-options='{
                "itemSelector": ".item",
                  "layoutMode": "fitRows"
              }'>
			<?php woocommerce_product_loop_start(); ?>

				<?php woocommerce_product_subcategories(); ?>

				<?php while ( have_posts() ) : the_post(); ?>

					<?php wc_get_template_part( 'content', 'product' ); ?>

				<?php endwhile; // end of the loop. ?>

			<?php woocommerce_product_loop_end(); ?>
			</div>
			<?php
				/**
				 * woocommerce_after_shop_loop hook.
				 *
				 * @hooked woocommerce_pagination - 10
				 */
				do_action( 'woocommerce_after_shop_loop' );
			?>

		<?php elseif ( ! woocommerce_product_subcategories( array( 'before' => woocommerce_product_loop_start( false ), 'after' => woocommerce_product_loop_end( false ) ) ) ) : ?>

			<?php wc_get_template( 'loop/no-products-found.php' ); ?>

		<?php endif; ?>

	<?php
		/**
		 * woocommerce_after_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		do_action( 'woocommerce_after_main_content' );
	?>
	</div>
	<?php get_sidebar() ?>
<?php get_footer( 'shop' ); ?>
