<?php
/**
 * Empty cart page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/mini-cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<?php do_action( 'woocommerce_before_mini_cart' ); ?>
<div class="products_list">

<ul class="cart_list product_list_widget <?php echo $args['list_class']; ?>">

	<?php if ( ! WC()->cart->is_empty() ) : ?>

		<?php
			foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
				$_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
				$product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

				if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {

					$product_name  = apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key );
					$thumbnail     = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
					$product_price = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
					?>
					<li class="<?php echo esc_attr( apply_filters( 'woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key ) ); ?>">
						<div>
						<?php if ( ! $_product->is_visible() ) : ?>
							<?php echo str_replace( array( 'http:', 'https:' ), '', $thumbnail ); ?>
							<div class="product_description">
								<?php echo $product_name . '&nbsp;'; ?>
								<?php echo wc_get_formatted_cart_item_data( $cart_item ); ?>
								<?php echo apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf( '%s &times; %s', $cart_item['quantity'], $product_price ) . '</span>', $cart_item, $cart_item_key ); ?>
							</div>	
						<?php else : ?>				
							<?php echo str_replace( array( 'http:', 'https:' ), '', $thumbnail ); ?>
							<div class="product_description">
								<a href="<?php echo esc_url( $_product->get_permalink( $cart_item ) ); ?>">
									<?php echo $product_name . '&nbsp;'; ?>
								</a>
								<div class="prise clearfix">
								<?php echo wc_get_formatted_cart_item_data( $cart_item ); ?>
								<?php echo apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf( '%s &times; %s', $cart_item['quantity'], $product_price ) . '</span>', $cart_item, $cart_item_key ); ?>
								</div>
							</div>	
						<?php endif; ?>
						<?php
						echo apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
							'<a href="%s" class="remove close_product" title="%s" data-product_id="%s" data-product_sku="%s"></a>',
							esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
							__( 'Remove this item', 'helpmate' ),
							esc_attr( $product_id ),
							esc_attr( $_product->get_sku() )
						), $cart_item_key );
						?>
						</div>
					</li>
					<?php
				}
			}
		?>

	<?php else : ?>

		<li class="empty"><?php echo esc_html__( 'No products in the cart.', 'helpmate' ); ?></li>

	<?php endif; ?>

</ul><!-- end product list -->
</div>

<?php if ( ! WC()->cart->is_empty() ) : ?>

	<div class="total_price">
		<ul>
        	<li class="clearfix"><div class="f_left"><?php echo esc_html__( 'Subtotal', 'helpmate' ); ?></div><div class="f_right"><?php echo WC()->cart->get_cart_subtotal(); ?></div></li>
        </ul>
	</div>

	<?php do_action( 'woocommerce_widget_shopping_cart_before_buttons' ); ?>
	<div class="sc_footer">
      <a href="<?php echo esc_url( wc_get_cart_url() ); ?>" class="button type1 wc-forward"><span><span><?php echo esc_html__( 'View Cart', 'helpmate' ); ?></span><span><?php echo esc_html__( 'View Cart', 'helpmate' ); ?></span></span></a>
      <a href="<?php echo esc_url( wc_get_checkout_url() ); ?>" class="button type1 checkout wc-forward"><span><span><?php echo esc_html__( 'Checkout', 'helpmate' ); ?></span><span><?php echo esc_html__( 'Checkout', 'helpmate' ); ?></span></span></a>
    </div>
	<p><?php echo esc_html__('Enjoy complimentary shipping on all orders over $75 and also complimentary samples and returns with every order.','helpmate') ?></p>
<?php endif; ?>

<?php do_action( 'woocommerce_after_mini_cart' ); ?>
