<?php
/**
 * The template for displaying product widget entries
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-widget-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	http://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.5.5
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$helpmate_settings = helpmate_check_theme_options();
global $product; ?>

<li class="clearfix">
	<figure>
	<?php echo $product->get_image(); ?>
	</figure>
	<a href="<?php echo esc_url( get_permalink( $product->get_id() ) ); ?>" title="<?php echo esc_attr( $product->get_title() ); ?>">
		<h5><?php echo $product->get_title(); ?></h5>
	</a>
	<?php if($helpmate_settings['product_price']):?>
	<div class="widget_price">
	<?php echo $product->get_price_html(); ?>
	</div>
	<?php endif; ?>
	<div class="clearfix rating-sidebar">
	<?php if ( ! empty( $show_rating ) ) : ?>
		<?php echo wc_get_rating_html( $product->get_average_rating() ); ?>
	<?php endif; ?>
	</div>
</li>
