<?php
/**
 * Show options for ordering
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/orderby.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>
<?php if(is_product_category()):?>
	<div class="f_left">
	<div class="custom_select">
		<form class="woocommerce-ordering custom_select" method="get">
			<select name="orderby" class="orderby">
				<?php foreach ( $catalog_orderby_options as $id => $name ) : ?>
					<option value="<?php echo esc_attr( $id ); ?>" <?php selected( $orderby, $id ); ?>><?php echo esc_html( $name ); ?></option>
				<?php endforeach; ?>
			</select>
			<?php
				// Keep query string vars intact
				foreach ( $_GET as $key => $val ) {
					if ( 'orderby' === $key || 'submit' === $key ) {
						continue;
					}
					if ( is_array( $val ) ) {
						foreach( $val as $innerVal ) {
							echo '<input type="hidden" name="' . esc_attr( $key ) . '[]" value="' . esc_attr( $innerVal ) . '" />';
						}
					} else {
						echo '<input type="hidden" name="' . esc_attr( $key ) . '" value="' . esc_attr( $val ) . '" />';
					}
				}
			?>
		</form>
	</div>
	<?php if(class_exists('YITH_WCBR')):?>
    <div class="custom_select">
        <form class="woocommerce-ordering custom_select" method="post">
	        <select name="filterby" class="filterby" id="filterby"> 
	            	<?php
			        $args = array(
			        );

			        $brands = get_terms('yith_product_brand', $args);
			        echo '<option value="all">'.esc_html__('Select Manufacturer','helpmate').'</option>';
			        foreach ($brands as $_brand):
			        ?>    
			            <option value="<?php echo esc_attr($_brand->slug) ;?>"><?php echo $_brand->name;?></option>
					<?php endforeach; ?>
	        </select>
			<script type="text/javascript">
			    jQuery(function ($) {
				    var val = $(location).attr('href');	
				    if(window.location.href.indexOf("yith_product_brand") > -1){
				    var optionVal = val.substr(val.indexOf("yith_product_brand=") + 19);
				    $("#filterby").find("option[value=" + optionVal +"]").attr('selected', true);
					}
					
			      	jQuery('.filterby').on('change', function () {
			      		var optionValue = jQuery(this).val();

			      		$("#filterby").val(optionValue).find("option[value=" + optionValue +"]").attr('selected', true);
			      		if(jQuery(this).val() != 'all'){
			      			if((window.location.href.indexOf("orderby") > -1) || window.location.href.indexOf("min_price") > -1){
								if(window.location.href.indexOf("yith_product_brand") > -1){
									var val = $(location).attr('href');
									var myString = val.substr(val.indexOf("&yith_product_brand=") + 1);
									var url = $(location).attr('href').replace(myString,'yith_product_brand='+ jQuery(this).val());
								}else{
									var url = $(location).attr('href') + '&yith_product_brand='+ jQuery(this).val();
								}
							}else{
							    var url = '?yith_product_brand='+ jQuery(this).val();
							}				          
					        if (url) { 
								window.location = url; // redirect
								return false;
					        }
				        }else if(jQuery(this).val() == 'all'){
			      			var val = $(location).attr('href');					        				        	
				        	if(window.location.href.indexOf("orderby") > -1){
								var myString = val.substr(val.indexOf("&yith_product_brand=") + 1);
								var url = $(location).attr('href').replace(myString,'');
				        		window.location = url;
				        		return false;
				        	}else{		        
								var myString = val.substr(val.indexOf("?yith_product_brand="));
								var url = $(location).attr('href').replace(myString,'');
				        		window.location = url;
				        		return false;
				        	}
				        }
				        
			      });
			    });
			</script>
        </form>
    </div>
	<?php endif;?>
</div>


<?php else:?>

<div class="<?php if(!is_product_category()){echo 'f_right';}else{echo 'f_left';}?>">
		<form class="woocommerce-ordering custom_select" method="get">
			<select name="orderby" class="orderby">
				<?php foreach ( $catalog_orderby_options as $id => $name ) : ?>
					<option value="<?php echo esc_attr( $id ); ?>" <?php selected( $orderby, $id ); ?>><?php echo esc_html( $name ); ?></option>
				<?php endforeach; ?>
			</select>
			<?php
				// Keep query string vars intact
				foreach ( $_GET as $key => $val ) {
					if ( 'orderby' === $key || 'submit' === $key ) {
						continue;
					}
					if ( is_array( $val ) ) {
						foreach( $val as $innerVal ) {
							echo '<input type="hidden" name="' . esc_attr( $key ) . '[]" value="' . esc_attr( $innerVal ) . '" />';
						}
					} else {
						echo '<input type="hidden" name="' . esc_attr( $key ) . '" value="' . esc_attr( $val ) . '" />';
					}
				}
			?>
		</form>
</div>	
<?php endif;?>
