<?php
/**
 * Pagination - Show numbered pagination for catalog pages
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/pagination.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.3.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $wp_query;
if ( $wp_query->max_num_pages <= 1 ) {
	return;
}
?>
<div class="row">
	<div class="col-md-4">
		<?php
		$paged    = max( 1, $wp_query->get( 'paged' ) );
		$per_page = $wp_query->get( 'posts_per_page' );
		$total    = $wp_query->found_posts;
		$first    = ( $per_page * $paged ) - $per_page + 1;
		$last     = min( $total, $wp_query->get( 'posts_per_page' ) * $paged );

		if ( 1 === $total ) {
			echo esc_html__( 'Showing the single result', 'helpmate' );
		} elseif ( $total <= $per_page || -1 === $per_page ) {
			printf( esc_html__( 'Showing all %d results', 'helpmate' ), $total );
		} else {
			printf( _x( 'Showing %1$d&ndash;%2$d of %3$d results', '%1$d = first, %2$d = last, %3$d = total', 'helpmate' ), $first, $last, $total );
		}
		?>
	</div>
	<div class="col-md-8">
		<div class="pagination_list align_right">
			<?php
				echo paginate_links( apply_filters( 'woocommerce_pagination_args', array(
					'base'         => esc_url_raw( str_replace( 999999999, '%#%', remove_query_arg( 'add-to-cart', get_pagenum_link( 999999999, false ) ) ) ),
					'format'       => '',
					'add_args'     => false,
					'current'      => max( 1, get_query_var( 'paged' ) ),
					'total'        => $wp_query->max_num_pages,
					'prev_text'    => '&larr;',
					'next_text'    => '&rarr;',
					'type'         => 'list',
					'end_size'     => 3,
					'mid_size'     => 3
				) ) );
			?>
			<ul>
				<li class="pagination_button_prev"><?php previous_posts_link( esc_html__('Previous','helpmate') ); ?></li>
				<li class="pagination_button_next"><?php next_posts_link(esc_html__('Next','helpmate')); ?></li>
			</ul>
		</div>
	</div>
</div>	
