<?php
/**
 * Login Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<?php wc_print_notices(); ?>

<?php do_action( 'woocommerce_before_customer_login_form' ); ?>

<?php if ( get_option( 'woocommerce_enable_myaccount_registration' ) === 'yes' ) : ?>

<div class="col2-set" id="customer_login">

	<div class="col-1">

<?php endif; ?>

		<h4><?php echo esc_html__( 'Login', 'helpmate' ); ?></h4>

		<form method="post" class="login">

			<?php do_action( 'woocommerce_login_form_start' ); ?>

			<p class="form-row form-row-wide padding_15">
				<input type="text" placeholder="<?php echo esc_attr__('Username or email address', 'helpmate'); ?>" class="input-text" name="username" id="username" value="<?php if ( ! empty( $_POST['username'] ) ) echo esc_attr( $_POST['username'] ); ?>" />
			</p>
			<p class="form-row form-row-wide padding_15">
				<input class="input-text"  placeholder="<?php echo esc_attr__('Password', 'helpmate'); ?>" type="password" name="password" id="password" />
			</p>

			<?php do_action( 'woocommerce_login_form' ); ?>

				<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
				<div class="wpcf7-form inline_class">
					<div class="button type1">
						<span>
							<input type="submit" class="button" name="login" value="<?php esc_attr_e( 'Login', 'helpmate' ); ?>" />
							<input type="submit" class="button" name="login" value="<?php esc_attr_e( 'Login', 'helpmate' ); ?>" />
						</span>	
					</div>
				</div>	
				<div class="remember-me">
					<input name="rememberme" type="checkbox" id="rememberme" value="forever" /> <?php echo esc_html__( 'Remember me', 'helpmate' ); ?>
					<label for="rememberme" class="inline remember_class"></label>
				</div>
			<p class="lost_password">
				<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php echo esc_html__( 'Lost your password?', 'helpmate' ); ?></a>
			</p>

			<?php do_action( 'woocommerce_login_form_end' ); ?>

		</form>

<?php if ( get_option( 'woocommerce_enable_myaccount_registration' ) === 'yes' ) : ?>

	</div>

	<div class="col-2 form_register_custom">

		<h4><?php echo esc_html__( 'Register', 'helpmate' ); ?></h4>

		<form method="post" class="register">

			<?php do_action( 'woocommerce_register_form_start' ); ?>

			<?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>

				<p class="form-row form-row-wide padding_15">
					<input type="text" class="input-text"  placeholder="<?php echo esc_attr__('Username', 'helpmate'); ?>" name="username" id="reg_username" value="<?php if ( ! empty( $_POST['username'] ) ) echo esc_attr( $_POST['username'] ); ?>" />
				</p>

			<?php endif; ?>

			<p class="form-row form-row-wide padding_15">
				<input type="email" class="input-text"  placeholder="<?php echo esc_attr__('Email Address', 'helpmate'); ?>" name="email" id="reg_email" value="<?php if ( ! empty( $_POST['email'] ) ) echo esc_attr( $_POST['email'] ); ?>" />
			</p>

			<?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>

				<p class="form-row form-row-wide padding_15">
					<input type="password"  placeholder="<?php echo esc_attr__('Password', 'helpmate'); ?>" class="input-text" name="password" id="reg_password" />
				</p>

			<?php endif; ?>

			<?php do_action( 'woocommerce_register_form' ); ?>

			<p class="form-row">
				<?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
				<div class="wpcf7-form inline_class">
					<div class="button type1">
						<span>
							<input type="submit" class="button" name="register" value="<?php esc_attr_e( 'Register', 'helpmate' ); ?>" />
							<input type="submit" class="button" name="register" value="<?php esc_attr_e( 'Register', 'helpmate' ); ?>" />
						</span>	
					</div>
				</div>	
			</p>

			<?php do_action( 'woocommerce_register_form_end' ); ?>

		</form>

	</div>

</div>
<?php endif; ?>

<?php do_action( 'woocommerce_after_customer_login_form' ); ?>
