<?php
/**
 * Lost password form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/form-lost-password.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woothemes.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.5.2
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>

<?php wc_print_notices(); ?>

<form method="post" class="lost_reset_password">

	<p><?php echo apply_filters( 'woocommerce_lost_password_message', esc_html__( 'Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'helpmate' ) ); ?></p>

	<p class="form-row form-row-first padding_15"><input class="input-text" placeholder="<?php echo esc_attr__('Username or email', 'helpmate'); ?>" type="text" name="user_login" id="user_login" /></p>

	<div class="clear"></div>

	<?php do_action( 'woocommerce_lostpassword_form' ); ?>

	<p class="form-row">
		<div class="wpcf7-form">
			<div class="button type1">
				<span>
					<input type="submit" class="button" value="<?php echo 'lost_password' === $args['form'] ? esc_html__( 'Reset Password', 'helpmate' ) : esc_html__( 'Save', 'helpmate' ); ?>" />
					<input type="submit" class="button" value="<?php echo 'lost_password' === $args['form'] ? esc_html__( 'Reset Password', 'helpmate' ) : esc_html__( 'Save', 'helpmate' ); ?>" />
					<input type="hidden" name="wc_reset_password" value="true" />
				</span>
			</div>	
		</div>
	</p>

	<?php wp_nonce_field( 'lost_password' ); ?>

</form>
