<?php
/**
 * Display single product reviews (comments)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product-reviews.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.6.0
 */
global $product;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! comments_open() ) {
	return;
}

?>
<div id="reviews" >
	<div id="comments">

		<?php if ( have_comments() ) : ?>
			<div class="comment_section post_news">
			<ol class="commentlist">
				<?php wp_list_comments( apply_filters( 'woocommerce_product_review_list_args', array( 'callback' => 'woocommerce_comments' ) ) ); ?>
			</ol>

			<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) :
				echo '<nav class="woocommerce-pagination">';
				paginate_comments_links( apply_filters( 'woocommerce_comment_pagination_args', array(
					'prev_text' => '&larr;',
					'next_text' => '&rarr;',
					'type'      => 'list',
				) ) );
				echo '</nav>';
			endif; ?>
			</div>
		<?php else : ?>

			<p class="woocommerce-noreviews"><?php esc_html_e( 'There are no reviews yet.', 'helpmate' ); ?></p>

		<?php endif; ?>
	</div>

	<?php if ( get_option( 'woocommerce_review_rating_verification_required' ) === 'no' || wc_customer_bought_product( '', get_current_user_id(), $product->get_id() ) ) : ?>

		<div id="review_form_wrapper">
			<div id="review_form">
			<h4><?php echo esc_html__('Leave a Review','helpmate');?></h4>
			<p class="mad_bottom"><?php echo esc_html__('All fields with * are required.','helpmate');?></p>
			<div class="form_holder">
				<?php
					$commenter = wp_get_current_commenter();
					if ( $account_page_url = wc_get_page_permalink( 'myaccount' ) ) {
						$comment_form['must_log_in'] = '<p class="must-log-in">' .  sprintf( __( 'You must be <a href="%s">logged in</a> to post a review.', 'helpmate' ), esc_url( $account_page_url ) ) . '</p>';
					}

					$comment_form = array(
						'class_form' => 'form_type_1',			
						'title_reply'          => have_comments() ? '' : '',
						'title_reply_to'       => esc_html__( 'Leave a Reply to %s', 'helpmate' ),
						'comment_notes_before' => '',
						'comment_field' => '',
						'fields'               => array(
							'author' => '<div class="control-group"><label class="control-label">' . esc_html__( 'Name', 'helpmate' ) . ' *:</label>' .
							            '<div class="controls"><input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30" aria-required="true" /></div></div>',
							'email'  => '<div class="control-group"><label class="control-label" for="email">' . esc_html__( 'Email', 'helpmate' ) . ' <span class="required">*:</span></label> ' .
							            '<div class="controls"><input id="email" name="email" type="text" value="' . esc_attr(  $commenter['comment_author_email'] ) . '" size="30" aria-required="true" /></div></div>',
							'url'  => '<div class="control-group"><label class="control-label">' . esc_html__( 'Website', 'helpmate' ) .'</label> ' .
							            '<div class="controls"><input id="url" name="url" type="text" value="' . esc_attr(  $commenter['comment_author_url'] ) . '" size="30"  /></div></div>',							            
						),
						'label_submit'  => esc_html__( 'Submit', 'helpmate' ),
						'logged_in_as'  => '',
						'class_submit' => 'hidden',
					    'comment_notes_after' => '<button type="submit" class="button type1"><span><span>'.esc_html__('Submit','helpmate').'</span><span>'.esc_html__('Submit','helpmate').'</span></span></button>',
					);
					if ( get_option( 'woocommerce_enable_review_rating' ) === 'yes' ) {
						$comment_form['comment_field'] = '<div class="control-group "><label class="control-label rating-label" for="rating">' . esc_html__( 'Rating*:', 'helpmate' ) .'</label><select name="rating" id="rating">
							<option value="">' . esc_html__( 'Rate&hellip;', 'helpmate' ) . '</option>
							<option value="5">' . esc_html__( 'Perfect', 'helpmate' ) . '</option>
							<option value="4">' . esc_html__( 'Good', 'helpmate' ) . '</option>
							<option value="3">' . esc_html__( 'Average', 'helpmate' ) . '</option>
							<option value="2">' . esc_html__( 'Not that bad', 'helpmate' ) . '</option>
							<option value="1">' . esc_html__( 'Very Poor', 'helpmate' ) . '</option>
						</select></div>';
					}
					$comment_form['comment_field'] .= '<div class="control-group  ">' .
				       		'<label class="control-label">'.esc_html__('Comment','helpmate'). '*'  .': </label><div class="controls"><textarea id="comment" class="required" name="comment" cols="45" rows="8" aria-required="true"></textarea></div></div>';

					comment_form( apply_filters( 'woocommerce_product_review_comment_form_args', $comment_form ) );
				?>
				</div>
			</div>
		</div>

	<?php else : ?>

		<p class="woocommerce-verification-required"><?php esc_html_e( 'Only logged in customers who have purchased this product may leave a review.', 'helpmate' ); ?></p>

	<?php endif; ?>

	<div class="clear"></div>
</div>
