<?php
/**
 * The Template for displaying all single products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

get_header( 'shop' ); ?>
	<?php 
		$helpmate_settings = helpmate_check_theme_options();
		global $helpmate_sidebar_pos, $helpmate_layout, $helpmate_sidebar;
		$class = '';
		if (($helpmate_sidebar_pos == 'left-sidebar' || $helpmate_sidebar_pos == 'right-sidebar') && $helpmate_sidebar && is_active_sidebar($helpmate_sidebar)){
		 	$class .= 'col-lg-9 col-md-9 col-sm-12 col-xs-12 main-sidebar'; 
		}else {
			$class .= 'content-primary'; 
			if($helpmate_layout == 'fullwidth'){
				$class .= ' col-md-12';
			}
		}
		if ($helpmate_sidebar_pos == 'left-sidebar' && is_active_sidebar($helpmate_sidebar)){
			$class .= ' f-right';
		}
	?>
<div class="mad_shop_page <?php echo esc_attr($class);?>">
	<?php
		/**
		 * woocommerce_before_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 */
		do_action( 'woocommerce_before_main_content' );
	?>

		<?php while ( have_posts() ) : the_post(); ?>
			<h3><?php echo get_the_title();?></h3>
			<?php wc_get_template_part( 'content', 'single-product' ); ?>

		<?php endwhile; // end of the loop. ?>

	<?php
		/**
		 * woocommerce_after_main_content hook.
		 *
		 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
		 */
		do_action( 'woocommerce_after_main_content' );
	?>

</div>
<?php get_sidebar() ?>
<?php get_footer( 'shop' ); ?>
