<?php
/**
 * Single Product Thumbnails
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-thumbnails.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     3.5.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post, $product, $woocommerce;
$helpmate_settings = helpmate_check_theme_options();
global $helpmate_sidebar_pos, $helpmate_layout, $helpmate_sidebar;
$item_num = 4;
if (($helpmate_sidebar_pos == 'left-sidebar' || $helpmate_sidebar_pos == 'right-sidebar') && $helpmate_sidebar && is_active_sidebar($helpmate_sidebar)){
 	$item_num = 3; 
}
$attachment_ids = $product->get_gallery_image_ids();

if ( $attachment_ids ) {
	$loop 		= 0;
	$columns 	= apply_filters( 'woocommerce_product_thumbnails_columns', 3 );
	?>
	<div class="thumbnails <?php echo 'columns-' . $columns; ?>">
	    <div class="product_thumbnails_wrap">
	      	<div class="product_carousel" id="thumbnails" data-max-items="<?php echo esc_attr($item_num);?>">

	<?php
		if ( has_post_thumbnail() ) {
			$image_fe_title 	= esc_attr( get_the_title( get_post_thumbnail_id() ) );
			$feature_image      = get_the_post_thumbnail( $post->ID, apply_filters( 'single_product_small_thumbnail_size', 'shop_thumbnail' ), array(
				'title'	=> $image_fe_title,
				'alt'	=> $image_fe_title,
				) );
			$feature_image_class= 'active';
			$image_featured_link  	= wp_get_attachment_url( get_post_thumbnail_id() );
			echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<a href="#" class="%s" data-image="%s" data-zoom-image="%s"  >%s</a>', $feature_image_class, $image_featured_link, $image_featured_link, $feature_image ), get_post_thumbnail_id(), $post->ID, $feature_image_class );
		}
		foreach ( $attachment_ids as $attachment_id ) {

			$classes = array( '' );

			$image_link = wp_get_attachment_url( $attachment_id );

			if ( ! $image_link )
				continue;

			$image_title 	= esc_attr( get_the_title( $attachment_id ) );
			$image_caption 	= esc_attr( get_post_field( 'post_excerpt', $attachment_id ) );

			$image       = wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', 'shop_thumbnail' ), 0, $attr = array(
				'title'	=> $image_title,
				'alt'	=> $image_title,	
				) );

			$image_class = esc_attr( implode( ' ', $classes ) );

			echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<a href="#" class="%s" title="%s" data-image="%s" data-zoom-image="%s"  >%s</a>', $image_class, $image_caption, $image_link, $image_link, $image ), $attachment_id, $post->ID, $image_class );

			$loop++;
		}

	?>
			</div>
		</div>		
	</div>
	<?php
}
