<?php
/**
 * Single Product Sale Flash
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/sale-flash.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post, $product;
$helpmate_settings = helpmate_check_theme_options();
?>

<?php if($helpmate_settings['product_label']):?>
<?php if ( $product->is_on_sale() ) : ?>

	<?php echo apply_filters( 'woocommerce_sale_flash', '<a class="sale_label">' . esc_html__( 'Sale', 'helpmate' ) . '</a>', $post, $product ); ?>

<?php endif; ?>
<?php if ( ! $product->is_in_stock() ) {
	echo '<a class="sold_label">';
    echo esc_html__('Sold Out', 'helpmate');
    echo '</a>';
}
?>
<?php endif; ?>