<?php
	
	/**
	 * Load the patterns into arrays.
	 */
	$patterns=array();
	$patterns[0]='none';
	for($i=1; $i<=10; $i++){
		$patterns[]='pattern'.$i.'.jpg';
	}
	
	$imperio_fonts_array = imperio_fonts_array_builder();
	
	$imperio_style_general_options= array( array(
		"name" => "Footer",
		"type" => "title",
	),
	
	array(
		"type" => "open",
		"subtitles"=>array(array("id"=>"style-footer", "name"=>"Footer"))
	),
	
	/* ------------------------------------------------------------------------*
	 * FOOTER
	 * ------------------------------------------------------------------------*/
	
	array(
		"type" => "subtitle",
		"id" => 'style-footer'
	),
	
	array(
		"type" => "documentation",
		"text" => '<h3>Primary Footer</h3>'
	),
	
	array(
		"name" => "Show Primary Footer?",
		"id" => "imperio_show_primary_footer",
		"type" => "checkbox",
		"std" => 'on'
	),
	
	array(
		"name" => "Background Type",
		"id" => "imperio_footerbg_type",
		"type" => "select",
		"options" => array(array('id'=>'color','name'=>'Color'), array('id'=>'image','name'=>'Image'), array('id'=>'pattern','name'=>'Pattern'), array('id'=>'custom_pattern','name'=>'Custom Pattern')),
		"std" => 'color'
	),
	
	array(
		"name" => "Image",
		"id" => "imperio_footerbg_image",
		"type" => "upload_from_media",
		"desc" => 'Here you can choose the image for your footer.'
	),
	
	array(
		"name" => "Color",
		"id" => "imperio_footerbg_color",
		"type" => "color",
		"std" => '191919'
	),
	
	array(
		"name" => "Background Opacity",
		"id" => "imperio_footerbg_color_opacity",
		"type" => "opacity_slider",
		"std" => "100"
	),
	
	array(
		"name" => "Pattern",
		"id" => "imperio_footerbg_pattern",
		"type" => "pattern",
		"options" => $patterns,
		"desc" => 'Here you can choose the pattern for your footer.'
	),
	
	array(
		"name" => "Custom Pattern",
		"id" => "imperio_footerbg_custom_pattern",
		"type" => "upload_from_media",
		"desc" => 'Here you can choose the custom pattern for your footer. It will replace the pattern you choose above.'
	),
	
	array(
		"name" => "Borders Color",
		"id" => "imperio_footerbg_borderscolor",
		"type" => "color",
		"std" => '191919'
	),
	
	array(
		"name" => "Padding Top",
		"id" => "imperio_primary_footer_padding_top",
		"type" => "text",
		"std" => "80px"
	),
	
	array(
		"name" => "Padding Bottom",
		"id" => "imperio_primary_footer_padding_bottom",
		"type" => "text",
		"std" => "80px"
	),
	
	array(
		"type" => "documentation",
		"text" => '<h3>Primary Footer - Text Colors</h3>'
	),
	
	array(
		"name" => "Links Color",
		"id" => "imperio_footerbg_linkscolor",
		"type" => "color",
		"std" => 'ACACAD'
	),
	
	array(
		"name" => "Paragraphs Color",
		"id" => "imperio_footerbg_paragraphscolor",
		"type" => "color",
		"std" => 'ACACAD'
	),
	
	array(
		"name" => "Headings Color",
		"id" => "imperio_footerbg_headingscolor",
		"type" => "color",
		"std" => 'ffffff'
	),
	
	array(
		"type" => "documentation",
		"text" => '<h3>Secondary Footer</h3>'
	),
	
	array(
		"name" => "Show Secondary Footer?",
		"id" => "imperio_show_sec_footer",
		"type" => "checkbox",
		"std" => 'on'
	),
	
	array(
		"name" => "Background Type",
		"id" => "imperio_sec_footerbg_type",
		"type" => "select",
		"options" => array(array('id'=>'color','name'=>'Color'), array('id'=>'image','name'=>'Image'), array('id'=>'pattern','name'=>'Pattern'), array('id'=>'custom_pattern','name'=>'Custom Pattern')),
		"std" => 'color'
	),
	
	array(
		"name" => "Image",
		"id" => "imperio_sec_footerbg_image",
		"type" => "upload_from_media",
		"desc" => 'Here you can choose the image for your footer.'
	),
	
	array(
		"name" => "Color",
		"id" => "imperio_sec_footerbg_color",
		"type" => "color",
		"std" => '141414'
	),
	
	array(
		"name" => "Background Opacity",
		"id" => "imperio_sec_footerbg_color_opacity",
		"type" => "opacity_slider",
		"std" => "100"
	),
	
	array(
		"name" => "Pattern",
		"id" => "imperio_sec_footerbg_pattern",
		"type" => "pattern",
		"options" => $patterns,
		"desc" => 'Here you can choose the pattern for your footer.'
	),
	
	array(
		"name" => "Custom Pattern",
		"id" => "imperio_sec_footerbg_custom_pattern",
		"type" => "upload_from_media",
		"desc" => 'Here you can choose the custom pattern for your footer. It will replace the pattern you choose above.'
	),
	
	array(
		"name" => "Padding Top",
		"id" => "imperio_secondary_footer_padding_top",
		"type" => "text",
		"std" => "20px"
	),
	
	array(
		"name" => "Padding Bottom",
		"id" => "imperio_secondary_footer_padding_bottom",
		"type" => "text",
		"std" => "20px"
	),
	
	array(
		"name" => "Social Icons Size",
		"id" => "imperio_sec_footer_social_icons_size",
		"type" => "text",
		"std" => "40px"
	),
	
	array(
		"name" => "Social Icons Color",
		"id" => "imperio_sec_footer_social_icons_color",
		"type" => "color",
		"std" => "BBBBBB"
	),
	
	array(
		"name" => "Social Icons Hover Color",
		"id" => "imperio_sec_footer_social_icons_hover_color",
		"type" => "color",
		"std" => "FFFFFF"
	),
	
	array(
		"type" => "close"
	),

	
	/*close array*/
	
	array(
		"type" => "close"
	));
	
	imperio_add_style_options($imperio_style_general_options);
	
?>