<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Litae
 */
/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if (post_password_required()) {
    return;
}
?>

<div id="comments" class="comments-area">

    <?php
    // You can start editing here -- including this comment!
    if (have_comments()) :
        ?>
        <div class="num-of-com">
            <span><?php echo number_format_i18n( get_comments_number() );?></span>
            <?php echo esc_html( _nx( 'comment', 'comments', get_comments_number(), 'comments title', 'litae') );?>
        </div>

        <ol class="comment-list">
    <?php
    wp_list_comments(array(
        'style' => 'ol',
        'callback' => 'better_comment',
        'end-callback' => 'better_comment_close',
        'short_ping' => true,
    ));
    ?>
        </ol><!-- .comment-list -->

    <?php if (get_comment_pages_count() > 1 && get_option('page_comments')) : // Are there comments to navigate through?  ?>
            <nav id="comment-nav-below" class="navigation comment-navigation" role="navigation">
                <h2 class="screen-reader-text"><?php esc_html_e('Comment navigation', 'litae'); ?></h2>
                <div class="nav-links">

                    <div class="nav-previous"><?php previous_comments_link(esc_html__('Older Comments', 'litae')); ?></div>
                    <div class="nav-next"><?php next_comments_link(esc_html__('Newer Comments', 'litae')); ?></div>

                </div><!-- .nav-links -->
            </nav><!-- #comment-nav-below -->
        <?php
    endif; // Check for comment navigation.

endif; // Check for have_comments().
// If comments are closed and there are comments, let's leave a little note, shall we?
if (!comments_open() && get_comments_number() && post_type_supports(get_post_type(), 'comments')) :
    ?>

        <p class="no-comments"><?php esc_html_e('Comments are closed.', 'litae'); ?></p>
        <?php
    endif;
    $aria_req = 'aria-required="true"';
    $args = array(
        'title_reply' => esc_html__( 'Have Something To Say:', 'litae' ),
        'cancel_reply_link' => esc_html__( 'Cancel Reply', 'litae' ),
        'fields' => apply_filters( 'comment_form_default_fields', array(
            'author' => '<p class="comment-form-author half-width">' . 
            '<input id="author" name="author" type="text" value="" '. $aria_req.' placeholder="'. esc_html__( 'Your Name: *', 'litae' ) .'">' .'</p>',
            'email'  => '<p class="comment-form-email half-width">' . 
            '<input id="email" name="email" type="text" value=""' . $aria_req . ' placeholder="'. esc_html__( 'Your Email: *', 'litae' ) .'">'.'</p>',
            
            'url'    => ''
        ) ),

        'comment_field' => '<p>' .
        
            '<textarea id="comment" name="comment" cols="45" rows="8"'. $aria_req .' placeholder="'. esc_html__( 'Your comment: *', 'litae' ) .'"></textarea>' .
        
            '</p>',

        'comment_notes_before' => '<p class="comment-notes">' . esc_html__( 'Your email address will not be published. Required fields are marked *', 'litae' ) . '</p>',
        'comment_notes_after' => '',
        'label_submit'      => esc_html__( 'Post Comment', 'litae' ),
    );
    
    comment_form( $args );
    ?>

</div><!-- #comments -->
