<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Litae
 */

?>

	</div><!-- #content -->
<?php
global $litae_options;

$column_class = ($litae_options['footer_social_column']=='1' )? 'four' : 'six';
$column_1 = $litae_options['footer_first_column'];
$column_2 =  $litae_options['footer_second_column'];
$allowed_html = array(
    'br' => array(),
    'a' => array(
        'title' => array(),
        'href'  => array(),
        'class' => array(),
        'target' => array('_blank', '_top'),
    ),
    'p' => array(
        'class' => array()
    ),
    'strong' => array(),
);
$social_repeater = $litae_options['social_repeater'];
?>
	<footer id="colophon" class="site-footer padding-top-bottom footer" role="contentinfo">
            <div class="container hidden-overflow">
                <div class="row">
                <div class="<?php echo esc_attr($column_class); ?> columns animatedParent animateOnce">
                    <div class="animated fadeInUpShort">
                        <?php
                        echo wp_kses($column_1, $allowed_html);
                        ?>
                    </div>
                </div>
                <div class="<?php echo esc_attr($column_class); ?> columns animatedParent animateOnce">
                    <div class="animated fadeInUpShort">
                        <?php
                        echo wp_kses($column_2, $allowed_html);
                        ?>
                    </div>
                </div>
                <?php
                if( $column_class=='four' ):
                ?>
                <div class="four columns animatedParent animateOnce">
                    <div class="social-footer animated fadeInUpShort">
                        <ul class="list-social-footer">
                            <?php
                            foreach( $social_repeater['social_icon'] as $key=>$icon ):
                                $name = strtolower( str_replace('-', ' ', str_replace(array(
                                    'fa ',
                                    'fa-',
                                    '-play',
                                    '-square',
                                    '-alt',
                                    '-circle'
                                                                                                            
                                ), '', $icon) ) );
                            ?>
                            <li class="icon-footer tipped" data-title="<?php echo esc_attr($name);?>" data-tipper-options='{"direction":"bottom","follow":"true","margin":35}'>
                                <a href="<?php echo esc_url($social_repeater['social_url'][$key]);?>"><i class="<?php echo esc_attr($icon);?>"></i></a>
                            </li>
                            <?php
                            endforeach;
                            ?>
			</ul>
                    </div>
                </div>
                <?php
                endif;
                ?>
                </div>
            </div>
	</footer><!-- #colophon -->     
        
</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>
