<?php

/**
 * Litae functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Litae
 */

//menu walker class
require_once get_template_directory() . '/classes/menu.php';

//menu walker class
require_once get_template_directory() . '/classes/litae.admin.notice.php';

if (!function_exists('litae_setup')) :

    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    function litae_setup() {
        /*
         * Make theme available for translation.
         * Translations can be filed in the /languages/ directory.
         * If you're building a theme based on Litae, use a find and replace
         * to change 'litae' to the name of your theme in all the template files.
         */
        load_theme_textdomain('litae', get_template_directory() . '/languages');

        // Add default posts and comments RSS feed links to head.
        add_theme_support('automatic-feed-links');

        /*
         * Let WordPress manage the document title.
         * By adding theme support, we declare that this theme does not use a
         * hard-coded <title> tag in the document head, and expect WordPress to
         * provide it for us.
         */
        add_theme_support('title-tag');

        /*
         * Enable support for Post Thumbnails on posts and pages.
         *
         * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
         */
        add_theme_support('post-thumbnails');

        // This theme uses wp_nav_menu() in one location.
        register_nav_menus(array(
            'menu-1' => esc_html__('Primary', 'litae'),
        ));

        /*
         * Switch default core markup for search form, comment form, and comments
         * to output valid HTML5.
         */
        add_theme_support('html5', array(
            'search-form',
            'comment-form',
            'comment-list',
            'gallery',
            'caption',
        ));

        // Set up the WordPress core custom background feature.
        add_theme_support('custom-background', apply_filters('litae_custom_background_args', array(
            'default-color' => 'ffffff',
            'default-image' => '',
        )));

        // Add theme support for selective refresh for widgets.
        add_theme_support('customize-selective-refresh-widgets');
    }

endif;
add_action('after_setup_theme', 'litae_setup');

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function litae_content_width() {
    $GLOBALS['content_width'] = apply_filters('litae_content_width', 640);
}

add_action('after_setup_theme', 'litae_content_width', 0);

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function litae_widgets_init() {
    register_sidebar(array(
        'name' => esc_html__('Sidebar', 'litae'),
        'id' => 'sidebar-1',
        'description' => esc_html__('Add widgets here.', 'litae'),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget' => '</section>',
        'before_title' => '<h2 class="widget-title">',
        'after_title' => '</h2>',
    ));
}

add_action('widgets_init', 'litae_widgets_init');

/**
 * Enqueue scripts and styles.
 */
function litae_scripts() {

    wp_enqueue_style('litae-style', get_stylesheet_uri());
    //animations
    wp_enqueue_style('animations', get_template_directory_uri() . '/css/animations.css' );
    //base.css
    wp_enqueue_style('litae-base', get_template_directory_uri() . '/css/base.css' );
    //skeleteon.css
    wp_enqueue_style('litae-skeleton', get_template_directory_uri() .'/css/skeleton.css', array(), '1.2' );
    //google fonts
    wp_enqueue_style('litae-google-fonts', litae_fonts_url() , array(), null);
    //layout.css
    wp_enqueue_style('litae-layout', get_template_directory_uri() .'/css/layout.css', array(), '1.0' );
    //color.css
    wp_enqueue_style('litae-color', get_template_directory_uri() .'/css/custom-color.css', array(), '1.0' );
    //fontawesome.css
    wp_enqueue_style('font-awesome', get_template_directory_uri() .'/css/font-awesome.css', array(), '4.7.0' );
    //ionicons.css
    wp_enqueue_style('ionicons', get_template_directory_uri() .'/css/ionicons.min.css', array(), '2.0.1' );

    
    wp_enqueue_script('litae-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20151215', true);

    wp_enqueue_script('litae-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20151215', true);

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
    
    //modernizr
    wp_enqueue_script( 'modernizr', get_template_directory_uri().'/js/modernizr.custom.js', array(), '2.6.2', false );
    
    //imagesLoaded
    wp_enqueue_script( 'imagesloaded' );
    
    //plugins
    wp_enqueue_script( 'litae-plugins', get_template_directory_uri().'/js/plugins.js', array('jquery'), '1.0.0', true );
    
    //slick
    wp_enqueue_script( 'jquery-slick', get_template_directory_uri().'/js/slick.min.js', array('jquery'), '1.6.0', true );
    
    //main
    wp_enqueue_script('litae-main', get_template_directory_uri() . '/js/main.js', array('jquery'), '1.0.0', true );
}

add_action('wp_enqueue_scripts', 'litae_scripts');

/*
 * Google fonts
 */
if (!function_exists('litae_fonts_url')) {

    function litae_fonts_url() {
    
        $fonts_url = '';

        /* Translators: If there are characters in your language that are not
         * supported by Montserrat, translate this to 'off'. Do not translate
         * into your own language.
         */
        $archivo_black = _x('on', 'Archivo Black font: on or off', 'litae');
        
        /* Translators: If there are characters in your language that are not
         * supported by Montserrat, translate this to 'off'. Do not translate
         * into your own language.
         */
        $tenor_sans = _x('on', 'Tenor Sans font: on or off', 'litae');


        /* Translators: If there are characters in your language that are not
         * supported by Open Sans, translate this to 'off'. Do not translate
         * into your own language.
         */
        $open_sans = _x('on', 'Open Sans font: on or off', 'litae');

        if ('off' !== $archivo_black || 'off' !== $tenor_sans || 'off' !== $open_sans) {

            $font_families = array();

            if ('off' !== $archivo_black) {
                $font_families[] = 'Archivo Black';
            }
            
            if ('off' !== $tenor_sans) {
                $font_families[] = 'Tenor Sans';
            }
            
            if ('off' !== $open_sans) {
                $font_families[] = 'Open Sans';
            }

            $query_args = array(
                'family' => urlencode(implode('|', $font_families)) . ':300,300i,400,400i,600,600i,700,700i,800,800i',
                'subset' => urlencode('latin,greek,greek-ext,vietnamese,cyrillic-ext,latin-ext,cyrillic'),
            );


            $fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');
        }


        return esc_url_raw($fonts_url);
    }

}

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';


/*
 * Get Litae Theme Options
 */    
function litae_get_theme_options(){
    $options = get_option( 'litae_options' );
    if(!$options){
        litae_set_theme_options();
        return litae_get_theme_options();
    }
    return $options;
}
function litae_set_theme_options(){
    $default_options = '{"last_tab":"1","menu_style":"light","blog_page_layout":"one-column","blog_page_title":"Journal","blog_page_title_font":"home-big-text other-font","blog_page_title_animation":"1","blog_page_title_anim_color":"#fcf652","blog_page_title_anim_direction":"lr","blog_page_subtitle":"I just don\'t know why<br>people can\'t use the word \'journal\'.","blog_page_subtitle_animation":"1","blog_page_subtitle_anim_color":"#7f40f1","blog_page_subtitle_anim_direction":"rl","blog_title_alignment":"text-left","blog_title_placement":"text-left","blog_page_header_height":"big-height","blog_page_header_image":{"url":"https://ivang-design.com/litae-wp/wp-content/uploads/2017/04/blog.jpg","id":"3368","height":"1200","width":"1920","thumbnail":"https://ivang-design.com/litae-wp/wp-content/uploads/2017/04/blog-150x150.jpg"},"blog_page_posts_bg_color":"#fcf652","blog_page_post_animation":"1","blog_page_post_anim_color":"#fcf652","blog_page_post_anim_direction":"lr","single_post_page_layout":"two-columns-right","single_post_page_title_animation":"1","single_post_page_title_anim_color":"#fcf652","single_post_page_title_anim_direction":"lr","single_post_page_entry_animation":"1","single_post_page_entry_anim_color":"#7f40f1","single_post_page_entry_anim_direction":"rl","search_page_layout":"two-columns-right","archive_page_layout":"two-columns-right","theme_main_color":"#7F40F1","theme_main_color_before":"#FCF652","theme_tooltip_color":"#FCF652","social_repeater":{"redux_repeater_data":[{"title":"Twitter"},{"title":"Facebook"},{"title":"Facebook"}],"social_icon":["fa fa-twitter","fa fa-facebook","fa fa-apple"],"social_url":["#twitter","#facebook","#"]},"favicon":{"url":"https://ivang-design.com/litae-wp/wp-content/themes/litae/images/favicon.png","id":"","height":"","width":"","thumbnail":""},"apple_57":{"url":"https://ivang-design.com/litae-wp/wp-content/themes/litae/images/apple-touch-icon.png","id":"","height":"","width":"","thumbnail":""},"apple_72":{"url":"https://ivang-design.com/litae-wp/wp-content/themes/litae/images/apple-touch-icon-72x72.png","id":"","height":"","width":"","thumbnail":""},"apple_114":{"url":"https://ivang-design.com/litae-wp/wp-content/themes/litae/images/apple-touch-icon-114x114.png","id":"","height":"","width":"","thumbnail":""},"preloader":"1","preloader_bg":"#ffffff","preloader_image":{"url":"https://ivang-design.com/litae-wp/wp-content/themes/litae/images/preload.gif","id":"","height":"","width":"","thumbnail":""},"logo":{"url":"https://ivang-design.com/litae-wp/wp-content/themes/litae/images/logo.png","id":"","height":"","width":"","thumbnail":""},"google_api_key":"","footer_bg_color":"#ffffff","footer_text_color":"#999999","footer_link_color":{"regular":"#999","hover":"#7f40f1"},"footer_first_column":"<a href=\"#\" class=\"logo-text-footer\">The Litae</a><br><a href=\"#\" class=\"mail-text-footer\">hello@thelitea.com</a>","footer_second_column":"kralja milutina 325<br>11000 belgrade, serbia<br>(+381)60111222333","footer_social_column":"1","redux-backup":1}';

    update_option('litae_options', json_decode($default_options, true)  );
}

/*
 * Custom excerpt lenght
 */
if( !function_exists('litae_custom_excerpt_length') ){
    function litae_custom_excerpt_length() {
         return 22;// <----- TO DO in general options 
    }
    add_filter( 'excerpt_length', 'litae_custom_excerpt_length', 999 );
}


/*
 * move comment reply textarea to bottom
 */
if( !function_exists('litae_move_comment_field_to_bottom') ){
    function litae_move_comment_field_to_bottom( $fields ) {
        $comment_field = $fields['comment'];
        unset( $fields['comment'] );
        $fields['comment'] = $comment_field;
        return $fields;
    }
    add_filter( 'comment_form_fields', 'litae_move_comment_field_to_bottom' );
}
/*
 * 
 */
if( !function_exists( 'litae_on_redux_save') ){
    
    function litae_on_redux_save(){
        litae_auto_compile_less( get_template_directory() . '/css/color.less', get_template_directory() . '/css/custom-color.css' );
    }
    
    add_action('redux/options/litae_options/saved', 'litae_on_redux_save', 10, 2);
}



function litae_auto_compile_less($inputFile, $outputFile) {
    global $litae_options;
    if (!class_exists('lessc')) {
        return;
    }
    $less = new lessc;
    //$less->setFormatter('compressed');
    $less->setVariables(array(
        'wp-main-theme-color' => isset( $litae_options['theme_main_color'] )?
        $litae_options['theme_main_color']
        : '#7F40F1',
        'wp-main-theme-color-before' => isset( $litae_options['theme_main_color_before'] )?
        $litae_options['theme_main_color_before']
        : '#FCF652',
        'wp-footer-link-color-regular' => ( isset($litae_options['footer_link_color']['regular']) )?
        $litae_options['footer_link_color']['regular']
        : '#999',
        'wp-blog-page-posts-bg-color' => ( isset($litae_options['blog_page_posts_bg_color']) )?
        $litae_options['blog_page_posts_bg_color']
        : 'fcf652',
        'wp-footer-link-color-hover' => ( isset($litae_options['footer_link_color']['hover']) )?
        $litae_options['footer_link_color']['hover']
        : '#7F40F1',
        'wp-footer-bg-color' => ( isset($litae_options['footer_bg_color']) )?
        $litae_options['footer_bg_color']
        : '#fff',
        'wp-footer-text-color' => ( isset($litae_options['footer_text_color']) )?
        $litae_options['footer_text_color']
        : '#999',
        'wp-tooltip-color' => ( isset($litae_options['theme_tooltip_color']) )?
        $litae_options['theme_tooltip_color']
        : '#FCF652',
        'wp-preloader-background' => ( isset($litae_options['preloader_bg']) )?
        $litae_options['preloader_bg']
        : '#fff',
        '@wp-preloader-image' => ( isset($litae_options['preloader_image']['url']) && '' != $litae_options['preloader_image']['url'] )?
        "'" . $litae_options['preloader_image']['url'] ."'"
        : "'" . get_template_directory_uri().'/images/preload.gif' . "'"  ,
    ));

    try {
        /* you can safely run request_filesystem_credentials() without any issues and don't need to worry about passing in a URL */
        $creds = request_filesystem_credentials(admin_url(), '', false, false, array());

        /* initialize the API */
        if (!WP_Filesystem($creds)) {
            /* any problems and we exit */
            return false;
        }
        global $wp_filesystem;
        $wp_filesystem->put_contents(
                $outputFile, $less->compileFile($inputFile)
        );
        
        
    } catch (exception $e) {
        
        new LitaeAdminNotice( $e->getMessage(), 'error' );
        
    }
}

function litae_get_the_posts_navigation( $loop, $args = array() ) {
    $prev_label = isset( $args['prev_label']) ? esc_html( $args['prev_label'] ) : esc_html__( 'Newer', 'litae' );
    $next_label = isset( $args['next_label']) ? esc_html( $args['next_label'] ) : esc_html__( 'Older', 'litae' );
    $html = '';
    if( $loop->max_num_pages > 1 ){
        $html .= '<nav class="navigation posts-navigation" role="navigation">';
        $html .= '<div class="nav-links">';
        $html .= '<div class="nav-previous">';
        $html .= get_next_posts_link( $next_label, $loop->max_num_pages );
        $html .= '</div>';
        $html .= '<div class="nav-next">';
        $html .= get_previous_posts_link( $prev_label );
        $html .= '</div>';
        $html .= '</div>';
        $html .= '</nav>';
    }
    
    return $html;
}

// <editor-fold defaultstate="collapsed" desc="COMMENTS TEMPLATE">

/*
 * Thanks to Georgie Luhur https://gist.github.com/georgiecel 
 * on wp-comment-callbak https://gist.github.com/georgiecel/9444896
 */
function better_comment($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;
    extract($args, EXTR_SKIP);
    if ('article' == $args['style']) {
        $tag = 'li';
        $add_below = 'div-comment';
    } else {
        $tag = 'li';
        $add_below = 'div-comment';
    }
            ?>
    <<?php echo esc_attr($tag); ?> <?php comment_class(empty($args['has_children']) ? '' : 'parent') ?> id="comment-<?php comment_ID() ?>">
    <article id="div-comment-<?php comment_ID(); ?>" itemscope itemtype="http://schema.org/Comment">
        <figure class="gravatar"><?php echo get_avatar($comment, 80); ?></figure>
        <div class="comment-meta post-meta" role="complementary">
            <time class="comment-meta-item" datetime="<?php comment_date('Y-m-d') ?>T<?php comment_time('H:iP') ?>" itemprop="datePublished">
    <?php comment_date(get_option('date_format')) ?>
                <span itemprop="url" content="#comment-<?php comment_ID(); ?>"></span>
            </time>
            <h2 class="comment-author">
                <a class="comment-author-link" href="<?php comment_author_url(); ?>" itemprop="author"><?php comment_author(); ?></a>
            </h2>
            
    <?php if ($comment->comment_approved == '0') : ?>
                <p class="comment-meta-item">Your comment is awaiting moderation.</p>
    <?php endif; ?>
        </div>
        <div class="comment-content post-content" itemprop="text">
    <?php comment_text() ?>
            <div class="comment-reply">
    <?php comment_reply_link(array_merge($args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
    <?php edit_comment_link(esc_html__('Edit this comment', 'litae'), '<p class="comment-meta-item">', '</p>'); ?>
            </div>
        </div>
    </article>
    <?php
}

// end of awesome semantic comment
function better_comment_close() {
    echo '</li>';
}
// </editor-fold>

function litae_admin_style() {
    wp_enqueue_style('font-awesome', get_template_directory_uri() .'/css/font-awesome.css', array(), '4.7.0' );
    wp_enqueue_style('litae-admin-styles', get_template_directory_uri() . '/css/litae-admin.css');
}
add_action('admin_enqueue_scripts', 'litae_admin_style');


if (!function_exists('litae_primary_menu_fallback')) {

    function litae_primary_menu_fallback() {
        echo '<div class="no-menu-box">';
        //nav menus link
        $nav_menus_link = get_admin_url(get_current_blog_id(), 'nav-menus.php');
        // Translators 1: Link to Menus, 2: Link to Customize
        printf(
                esc_html__('Please assign a menu to the primary menu location under %1$s.', 'litae'), sprintf(
                        wp_kses(__('<a href="%s">Menus</a>', 'litae'), array(
            'a' => array(
                'href' => array()
            )
                        )), $nav_menus_link)
        );
        echo '</div>';
    }

}

function litae_acf_init() {
    acf_update_setting('google_api_key', 'your-api-key');
}

add_action('acf/init', 'litae_acf_init');


// <editor-fold defaultstate="collapsed" desc="TGMPA">
/**
 * Include the TGM_Plugin_Activation class.
 *
 * Depending on your implementation, you may want to change the include call:
 *
 * Parent Theme:
 * require_once get_template_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Child Theme:
 * require_once get_stylesheet_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Plugin:
 * require_once dirname( __FILE__ ) . '/path/to/class-tgm-plugin-activation.php';
 */
require_once get_template_directory() . '/classes/class-tgm-plugin-activation.php';

add_action('tgmpa_register', 'litae_register_required_plugins');

/**
 * Register the required plugins for this theme.
 *
 * In this example, we register five plugins:
 * - one included with the TGMPA library
 * - two from an external source, one from an arbitrary source, one from a GitHub repository
 * - two from the .org repo, where one demonstrates the use of the `is_callable` argument
 *
 * The variables passed to the `tgmpa()` function should be:
 * - an array of plugin arrays;
 * - optionally a configuration array.
 * If you are not changing anything in the configuration array, you can remove the array and remove the
 * variable from the function call: `tgmpa( $plugins );`.
 * In that case, the TGMPA default settings will be used.
 *
 * This function is hooked into `tgmpa_register`, which is fired on the WP `init` action on priority 10.
 */
function litae_register_required_plugins() {
    /*
     * Array of plugin arrays. Required keys are name and slug.
     * If the source is NOT from the .org repo, then source is also required.
     	 */
    $plugins = array(
        array(
            'name' => 'Advanced Custom Fields PRO', // The plugin name.
            'slug' => 'advanced-custom-fields-pro', // The plugin slug (typically the folder name).
            'source' => get_template_directory() . '/plugins/advanced-custom-fields-pro.zip', // The plugin source.
            'required' => true, // If false, the plugin is only 'recommended' instead of required.
            'version' => '5.5.12', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
            'force_activation' => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
        ),
        array(
            'name' => 'Litae Theme Plugin', // The plugin name.
            'slug' => 'litae-theme-plugin', // The plugin slug (typically the folder name).
            'source' => get_template_directory() . '/plugins/litae-theme-plugin.zip', // The plugin source.
            'required' => true, // If false, the plugin is only 'recommended' instead of required.
            'version' => '', // E.g. 1.0.0. If set, the active plugin must be this version or higher. If the plugin version is higher than the plugin version installed, the user will be notified to update the plugin.
            'force_activation' => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch.
            'force_deactivation' => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins.
        ),
        array(
            'name' => 'Elementor Page Builder',
            'slug' => 'elementor',
            'required' => true,
        ),
        array(
            'name' => 'Autoptimize',
            'slug' => 'autoptimize',
            'required' => true,
        ),
        array(
            'name' => 'Contact Form 7',
            'slug' => 'contact-form-7',
            'required' => true,
        ),
    );

    /*
     * Array of configuration settings. Amend each line as needed.
     *
     * TGMPA will start providing localized text strings soon. If you already have translations of our standard
     * strings available, please help us make TGMPA even better by giving us access to these translations or by
     * sending in a pull-request with .po file(s) with the translations.
     *
     * Only uncomment the strings in the config array if you want to customize the strings.
     	 */
    $config = array(
        'id' => 'litae', // Unique ID for hashing notices for multiple instances of TGMPA.
        'default_path' => '', // Default absolute path to bundled plugins.
        'menu' => 'tgmpa-install-plugins', // Menu slug.
        'has_notices' => true, // Show admin notices or not.
        'dismissable' => true, // If false, a user cannot dismiss the nag message.
        'dismiss_msg' => '', // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false, // Automatically activate plugins after installation or not.
        'message' => '', // Message to output right before the plugins table.
        
		'strings' => array(
            'page_title' => __('Install Required Plugins', 'litae'),
            'menu_title' => __('Install Plugins', 'litae'),
            /* translators: %s: plugin name. */
            'installing' => __('Installing Plugin: %s', 'litae'),
            /* translators: %s: plugin name. */
            'updating' => __('Updating Plugin: %s', 'litae'),
            'oops' => __('Something went wrong with the plugin API.', 'litae'),
            'notice_can_install_required' => _n_noop(
                    /* translators: 1: plugin name(s). */
                    'This theme requires the following plugin: %1$s.', 				'This theme requires the following plugins: %1$s.', 				'litae'
            ),
            'notice_can_install_recommended' => _n_noop(
                    /* translators: 1: plugin name(s). */
                    'This theme recommends the following plugin: %1$s.', 				'This theme recommends the following plugins: %1$s.', 				'litae'
            ),
            'notice_ask_to_update' => _n_noop(
                    /* translators: 1: plugin name(s). */
                    'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 				'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 				'litae'
            ),
            'notice_ask_to_update_maybe' => _n_noop(
                    /* translators: 1: plugin name(s). */
                    'There is an update available for: %1$s.', 				'There are updates available for the following plugins: %1$s.', 				'litae'
            ),
            'notice_can_activate_required' => _n_noop(
                    /* translators: 1: plugin name(s). */
                    'The following required plugin is currently inactive: %1$s.', 				'The following required plugins are currently inactive: %1$s.', 				'litae'
            ),
            'notice_can_activate_recommended' => _n_noop(
                    /* translators: 1: plugin name(s). */
                    'The following recommended plugin is currently inactive: %1$s.', 				'The following recommended plugins are currently inactive: %1$s.', 				'litae'
            ),
            'install_link' => _n_noop(
                    'Begin installing plugin', 				'Begin installing plugins', 				'litae'
            ),
            'update_link' => _n_noop(
                    'Begin updating plugin', 				'Begin updating plugins', 				'litae'
            ),
            'activate_link' => _n_noop(
                    'Begin activating plugin', 				'Begin activating plugins', 				'litae'
            ),
            'return' => __('Return to Required Plugins Installer', 'litae'),
            'plugin_activated' => __('Plugin activated successfully.', 'litae'),
            'activated_successfully' => __('The following plugin was activated successfully:', 'litae'),
            /* translators: 1: plugin name. */
            'plugin_already_active' => __('No action taken. Plugin %1$s was already active.', 'litae'),
            /* translators: 1: plugin name. */
            'plugin_needs_higher_version' => __('Plugin not activated. A higher version of %s is needed for this theme. Please update the plugin.', 'litae'),
            /* translators: 1: dashboard link. */
            'complete' => __('All plugins installed and activated successfully. %1$s', 'litae'),
            'dismiss' => __('Dismiss this notice', 'litae'),
            'notice_cannot_install_activate' => __('There are one or more required or recommended plugins to install, update or activate.', 'litae'),
            'contact_admin' => __('Please contact the administrator of this site for help.', 'litae'),
            			'nag_type' => '', // Determines admin notice type - can only be one of the typical WP notice classes, such as 'updated', 'update-nag', 'notice-warning', 'notice-info' or 'error'. Some of which may not work as expected in older WP versions.
        ),
    	);

    tgmpa($plugins, $config);
}
// </editor-fold>
