<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Litae
 */
global $litae_options;
$litae_options = litae_get_theme_options();


$menu_style = ( isset($litae_options['menu_style']) && $litae_options['menu_style'] != '' ) ? $litae_options['menu_style'] : 'light';
?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
        <link rel="profile" href="http://gmpg.org/xfn/11">

        <!-- Favicons
        ================================================== -->
        <?php
        if (!function_exists('wp_site_icon') || !has_site_icon()) {
            if ($litae_options['favicon'] && $litae_options['favicon']['url'] != '') {
                echo '<link rel="shortcut icon" href="' . esc_url($litae_options['favicon']['url']) . '">';
            }
            if ($litae_options['apple_57'] && $litae_options['apple_57']['url'] != '') {
                echo '<link rel="apple-touch-icon" href="' . esc_url($litae_options['apple_57']['url']) . '">';
            }
            if ($litae_options['apple_72'] && $litae_options['apple_72']['url'] != '') {
                echo '<link rel="apple-touch-icon" sizes="72x72" href="' . esc_url($litae_options['apple_72']['url']) . '">';
            }
            if ($litae_options['apple_114'] && $litae_options['apple_114']['url'] != '') {
                echo '<link rel="apple-touch-icon" sizes="114x114" href="' . esc_url($litae_options['apple_114']['url']) . '">';
            }
        }
        ?>

        <meta name="theme-color" content="<?php echo isset($litae_options['theme_main_color']) ? esc_attr($litae_options['theme_main_color']) : '#7F40F1'; ?>">

        <?php wp_head(); ?>
    </head>

    <body <?php body_class(); ?>>
        <?php if (intval($litae_options['preloader'])): ?>
            <div id="litae_preloader">
                <div id="litae_preloader_status">&nbsp;</div>
            </div>
        <?php endif; ?>
        <div id="page" class="site">
            <div class="scroll-to-top tipped" data-title="<?php echo esc_html__('to top', 'litae'); ?>"  data-tipper-options='{"direction":"bottom","follow":"true","margin":35}'></div>
            <a class="skip-link screen-reader-text" href="#content"><?php esc_html_e('Skip to content', 'litae'); ?></a>


            <nav id="menu-wrap" class="menu-back cbp-af-header <?php echo esc_attr($menu_style); ?>"> <!-- fixed container --> <!-- ADD CLASS LIGHT ON FIXED CONTAINER TO CHANGE IT TO LIGHT SCHEME -->
                <div class="container">
                    <div class="row">
                        <div class="twelve columns no-vertical-padding">
                        <div class="logo light">
                            <a href="<?php echo esc_url(home_url('/')); ?>" rel="home">

                                <?php
                                if (isset($litae_options['logo']['url']) && '' != $litae_options['logo']['url']):
                                    echo '<img src="' . esc_url($litae_options['logo']['url']) . '" alt="' . get_bloginfo('name') . '">';
                                else:
                                    echo '<span>' . get_bloginfo('name') . '</span>';
                                endif;
                                ?>
                            </a>
                        </div> <!-- logo in absolute position --> <!-- ADD CLASS LIGHT ON LOGO TO CHANGE LOGO FOR LIGHT SCHEME -->
                        <!-- menu start --> <!-- ADD CLASS LIGHT ON MENU TO CHANGE MENU TO LIGHT SCHEME -->
                        <?php
                        wp_nav_menu(array(
                            'theme_location' => 'menu-1',
                            'menu_id' => 'primary-menu',
                            'container' => 'div',
                            'container_class' => 'menu light',
                            'walker' => new litae_menu_walker(),
                            'fallback_cb' => 'litae_primary_menu_fallback',
                        ));
                        ?>
                        <div class="clearfix"></div>
                        </div>
                    </div>
                </div>
            </nav>

            <div id="content" class="site-content">
