(function ($) {
    "use strict";

    $(document).on('ready', function () {
        
        //TaurusMenu
        $('.menu > ul > li:has( > ul)').addClass('menu-dropdown-icon');
        //Checks if li has sub (ul) and adds class for toggle icon - just an UI

        $(".menu > ul").before("<a href=\"#\" class=\"menu-mobile\"></a>");

        //Adds menu-mobile class (for mobile toggle menu) before the normal menu
        //Mobile menu is hidden if width is more then 1199px, but normal menu is displayed
        //Normal menu is hidden if width is below 1199px, and jquery adds mobile menu
        //Done this way so it can be used with wordpress without any trouble

        $('.menu > ul > li').on('hover',function (e) {
            if ($(window).width() > 1183) {
                $(this).children("ul").stop(true, false).toggleClass('active');
                e.preventDefault();
            }
        });

        $(".menu > ul > li").on('click', function (e) {
            if ($(window).width() < 1183) {
                var $me = $(this),
                    width = $me.outerWidth(),
                    height = $me.outerHeight(),
                    top = $me.position().top,
                    left = $me.position().left;

                var len = Math.sqrt(Math.pow(width - e.offsetX, 2) + Math.pow(e.offsetY, 2));

                if (len < 50)
                    $(this).children("ul").stop(true, false).toggleClass('active');
            }
        });

        //2nd dropdown
        $(".menu > ul > li > ul.normal-sub > li").on('hover', function (e) {
            if ($(window).width() > 1183) {
                //$(this).children("ul").stop(true, false).fadeToggle(300);
                e.preventDefault();
            }
        });
        //If width is more than 1183px 2nd dropdowns are displayed on hover

        $(".menu-mobile").on('click', function (e) {
            $(".menu > ul").toggleClass('show-on-mobile');
            e.preventDefault();
        });
        //when clicked on mobile-menu, normal menu is shown as a list, classic rwd menu story


        /*
         * FitVids
         */
        $(".container").fitVids();

        /*
         * Parallax
         */
        $('[data-litae_parallax]').each(function( k, obj ){
            var data = $(obj).data('litae_parallax');
            $(obj).parallax( data.xpos, data.speed);
        });
        $.selectorCache('.parallax-home').parallax("50%", 0.3);
        
        /*
         * Tooltip
         */
        $.selectorCache(".tipped").tipper();

        
        /*
         * Scroll Back to Top
         */
        var offset = 450;
        var duration = 500;
        $(window).on('scroll', function() {
            if ($(this).scrollTop() > offset) {
                $.selectorCache('.scroll-to-top').fadeIn(duration);
            } else {
                $.selectorCache('.scroll-to-top').fadeOut(duration);
            }
        });

        $.selectorCache('.scroll-to-top').on('click', function(event) {
            event.preventDefault();
            $('html, body').animate({scrollTop: 0}, duration);
            return false;
        });
        
        
        /*
         * Masonry
         */
        $(window).on('load', function () {
            // isotope Masonry
            var container = $('.blog-container');
            container.imagesLoaded(function () {
                container.isotope({
                    itemSelector: '.grid-item', 
                    layoutMode: 'masonry',
                    percentPosition: true,
                    resizesContainer: false,
                    masonry: {
                        gutterWidth: 10
                    }
                });
                
                /* preloader */
                $.selectorCache("#litae_preloader_status").fadeOut();
                /*
                * Revealer Init
                */
                LitaeRevealer.init();
                $.selectorCache("#litae_preloader").delay(150).fadeOut("slow");

            });
            // filter items on button click
            $('ul.filter li a').on('click', function (e) {
                e.preventDefault();
                var filterValue = $(this).attr('data-filter');
                $(this).parent().parent().find('a').removeClass('current');
                $(this).addClass('current');
                container.isotope({
                    filter: filterValue
                });

                return false;
            });
        });


    });/* end ready*/

})(jQuery);


//custom revealer handling
var LitaeRevealer = (function () {
    var api = {};
    var $boxes = null;

    api.init = function () {
        $boxes = document.querySelectorAll('.watcher');
        //console.log($boxes);
        for (var i = 0; i < $boxes.length; i++) {
            api.createWatcher($boxes[i], -120);
        }
    };

    api.createWatcher = function (element, offset) {
        var watcher = scrollMonitor.create(element, offset);
       
        /*
         * edit
         */
        var settings = (jQuery(element).data('rev-settings') !== null) ? 
        jQuery(element).data('rev-settings')
        : {
            bgcolor: '#fcf652',
            direction: 'lr',
            delay: 250
        };
        var effect = new RevealFx(element,{
            revealSettings: {
                direction: settings.direction,
                bgcolor: settings.bgcolor,
                delay: settings.delay,
                onStart: function (contentEl, revealerEl) {
                    contentEl.style.opacity = 0;
                },
                onCover: function (contentEl, revealerEl) {
                    contentEl.style.opacity = 1;
                }
            }
        });
        /*
         * end edit
         */
         
        watcher.enterViewport(function (e, o) {
            //console.log('I have entered the viewport');
           effect.reveal();
           watcher.destroy();

        });
        //if watcher destroy remove exitViewport
        watcher.exitViewport(function () {
            //console.log('I have left the viewport');
        });
    };

    return api;
})();

(function(html){html.className = html.className.replace(/\bno-js\b/,'js');})(document.documentElement);