<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Litae
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php
		if ( is_single() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;

		if ( 'post' === get_post_type() ) : ?>
		<div class="entry-meta">
			<?php litae_posted_on(); ?>
		</div><!-- .entry-meta -->
		<?php
		endif; ?>
	</header><!-- .entry-header -->
        
        <div class="entry-content">
            <?php
            if (has_excerpt($post->ID)):
                echo get_the_excerpt();
            else:
                the_excerpt();
            endif;

            wp_link_pages(array(
                'before' => '<div class="page-links">' . esc_html__('Pages:', 'litae'),
                'after' => '</div>',
            ));
            ?>
        </div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php litae_entry_footer(); ?>
	</footer><!-- .entry-footer -->
</article><!-- #post-## -->
