<?php

global $litae_options;

//TITLE
$blog_page_title = ( isset($litae_options['blog_page_title']) && $litae_options['blog_page_title']!='' )? $litae_options['blog_page_title'] : get_bloginfo('name');

$blog_page_title_font = ( isset($litae_options['blog_page_title_font']) &&  $litae_options['blog_page_title_font']!='' )? $litae_options['blog_page_title_font'] : 'home-big-text';

//blog title watcher class if animation exists
$blog_page_title_animation = ( isset($litae_options['blog_page_title_animation']) &&  $litae_options['blog_page_title_animation']!='' )? $litae_options['blog_page_title_animation'] : '0';
$title_watcher = ( $blog_page_title_animation == '0' )? '' : 'watcher';

//blog title animation settings
$blog_page_title_anim_color = ( isset($litae_options['blog_page_title_anim_color']) &&  $litae_options['blog_page_title_anim_color']!='' )? $litae_options['blog_page_title_anim_color'] : '#fcf652';
$blog_page_title_anim_direction = ( isset($litae_options['blog_page_title_anim_direction']) &&  $litae_options['blog_page_title_anim_direction']!='' )? $litae_options['blog_page_title_anim_direction'] : 'lr';
$blog_page_title_rev_settings = array(
    'bgcolor' => $blog_page_title_anim_color,
    'direction' => $blog_page_title_anim_direction,
    'delay' => 0,
);

//SUBTITLE
$blog_page_subtitle = ( isset($litae_options['blog_page_subtitle']) && $litae_options['blog_page_subtitle']!='' )? $litae_options['blog_page_subtitle'] : get_bloginfo('description');

//blog subtitle watcher class if animation exists
$blog_page_subtitle_animation = ( isset($litae_options['blog_page_subtitle_animation']) &&  $litae_options['blog_page_subtitle_animation']!='' )? $litae_options['blog_page_subtitle_animation'] : '0';
$subtitle_watcher = ( $blog_page_subtitle_animation == '0' )? '' : 'watcher';

//blog subtitle animation settings
$blog_page_subtitle_anim_color = ( isset($litae_options['blog_page_subtitle_anim_color']) &&  $litae_options['blog_page_subtitle_anim_color']!='' )? $litae_options['blog_page_subtitle_anim_color'] : '#7F40F1';
$blog_page_subtitle_anim_direction = ( isset($litae_options['blog_page_subtitle_anim_direction']) &&  $litae_options['blog_page_subtitle_anim_direction']!='' )? $litae_options['blog_page_subtitle_anim_direction'] : 'lr';
$blog_page_subtitle_rev_settings = array(
    'bgcolor' => $blog_page_subtitle_anim_color,
    'direction' => $blog_page_subtitle_anim_direction,
    'delay' => 0,
);


$blog_title_alignment = ( isset($litae_options['blog_title_alignment']) && $litae_options['blog_title_alignment']!='' )? $litae_options['blog_title_alignment'] : 'text-center';

$blog_title_placement = ( isset($litae_options['blog_title_placement']) && $litae_options['blog_title_placement']!='' )? $litae_options['blog_title_placement'] : 'text-center';

$blog_page_header_height  = ( isset($litae_options['blog_page_header_height']) && $litae_options['blog_page_header_height']!='' )? $litae_options['blog_page_header_height'] : 'big-height';

$blog_page_header_image = ( isset($litae_options['blog_page_header_image']['url']) && $litae_options['blog_page_header_image']['url']!='' )? $litae_options['blog_page_header_image']['url'] : '';

?>


<div class="section <?php echo esc_attr($blog_page_header_height);?> back-white">
    <div class="parallax-home" <?php if($blog_page_header_image!=''){echo 'style="background-image:url('.  esc_url($blog_page_header_image) .')"';}?>></div>
    <div class="page-center-wrap">
        <div class="container">
            <div class="twelve columns <?php echo esc_attr($blog_title_placement);?>">
                <div class="<?php echo esc_attr($blog_page_title_font);?> <?php echo esc_attr($blog_title_alignment);?> <?php echo ($title_watcher!='')? esc_attr($title_watcher): '';?>" data-rev-settings="<?php echo esc_attr( wp_json_encode($blog_page_title_rev_settings) );?>">
                    <h1><?php echo esc_html($blog_page_title);?></h1>
                </div>
                <br/>
                <div class="home-small-text <?php echo esc_attr($blog_title_alignment);?> <?php echo ($subtitle_watcher!='')? esc_attr($subtitle_watcher): '';?>" data-rev-settings="<?php echo esc_attr( wp_json_encode($blog_page_subtitle_rev_settings) );?>">
                    <?php echo wp_kses( $blog_page_subtitle, array(
                    'a' => array(
                        'href' => array(),
                        'title' => array()
                    ),
                    'br' => array(),
                    'em' => array(),
                    'strong' => array()
                    ) );
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>