<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Litae
 */


$is_page_canvas = is_page_template('page-canvas.php')? true : false;

if($is_page_canvas):
    //Page canvas template
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="entry-content">
        <?php
            the_content();

            wp_link_pages( array(
                    'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'litae' ),
                    'after'  => '</div>',
            ) );
        ?>
    </div><!-- .entry-content -->
</article><!-- #post-## -->
<?php
else:
    //Default template
    ?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <header class="entry-header">
        <?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
    </header><!-- .entry-header -->
    <div class="entry-content">
    <?php
    the_content();

    wp_link_pages( array(
            'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'litae' ),
            'after'  => '</div>',
    ) );
    ?>
    </div><!-- .entry-content -->
</article><!-- #post-## -->
<?php    
endif;