<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Litae
 */
global $litae_options;

$blog_page_post_animation = ( isset($litae_options['blog_page_post_animation']) && $litae_options['blog_page_post_animation'] != '' ) ? $litae_options['blog_page_post_animation'] : '0';
$post_watcher = ( $blog_page_post_animation == '0' ) ? '' : 'watcher';

$blog_page_post_anim_color = ( isset($litae_options['blog_page_post_anim_color']) && $litae_options['blog_page_post_anim_color'] != '' ) ? $litae_options['blog_page_post_anim_color'] : '#fcf652';
$blog_page_post_anim_direction = ( isset($litae_options['blog_page_post_anim_direction']) && $litae_options['blog_page_post_anim_direction'] != '' ) ? $litae_options['blog_page_post_anim_direction'] : 'lr';
$blog_page_post_rev_settings = array(
    'bgcolor' => $blog_page_post_anim_color,
    'direction' => $blog_page_post_anim_direction,
    'delay' => 0,
);



//blog post class
$blog_page_layout = ( isset($litae_options['blog_page_layout']) && $litae_options['blog_page_layout'] != '' ) ? $litae_options['blog_page_layout'] : 'one-column';
$blog_blox_class = ( $blog_page_layout == 'one-column') ? 'blog-box' : 'blog-box-two-columns';

/* Single post page */
$single_post_page_title_animation = ( isset($litae_options['single_post_page_title_animation']) && $litae_options['single_post_page_title_animation'] != '' ) ? $litae_options['single_post_page_title_animation'] : '0';
$single_post_watcher = ( $single_post_page_title_animation == '0' ) ? '' : 'watcher';
$single_post_page_title_anim_color = ( isset($litae_options['single_post_page_title_anim_color']) && $litae_options['single_post_page_title_anim_color'] != '' ) ? $litae_options['single_post_page_title_anim_color'] : '#fcf652';
$single_post_page_title_anim_direction = ( isset($litae_options['single_post_page_title_anim_direction']) && $litae_options['single_post_page_title_anim_direction'] != '' ) ? $litae_options['single_post_page_title_anim_direction'] : 'lr';
$single_post_title_rev_settings = array(
    'bgcolor' => $single_post_page_title_anim_color,
    'direction' => $single_post_page_title_anim_direction,
    'delay' => 0,
);

/* Single Post Page Hedar Entry */
$single_post_page_entry_animation = ( isset($litae_options['single_post_page_entry_animation']) && $litae_options['single_post_page_entry_animation'] != '' ) ? $litae_options['single_post_page_entry_animation'] : '0';
$single_post_entry_watcher = ( $single_post_page_entry_animation == '0' ) ? '' : 'watcher';
$single_post_page_entry_anim_color = ( isset($litae_options['single_post_page_entry_anim_color']) && $litae_options['single_post_page_entry_anim_color'] != '' ) ? $litae_options['single_post_page_entry_anim_color'] : '#7f40f1';
$single_post_page_entry_anim_direction = ( isset($litae_options['single_post_page_entry_anim_direction']) && $litae_options['single_post_page_entry_anim_direction'] != '' ) ? $litae_options['single_post_page_entry_anim_direction'] : 'lr';
$single_post_page_entry_rev_settings = array(
    'bgcolor' => $single_post_page_entry_anim_color,
    'direction' => $single_post_page_entry_anim_direction,
    'delay' => 0,
);

if (!is_single()):
    ?>
    <div class="<?php echo esc_attr($blog_blox_class); ?> grid-item <?php echo ( $post_watcher != '') ? esc_attr($post_watcher) : ''; ?>" data-rev-settings="<?php echo esc_attr( wp_json_encode($blog_page_post_rev_settings) );?>">
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <div class="content-in">
                <?php
                $url = wp_get_attachment_url(get_post_thumbnail_id($post->ID), 'thumbnail');
                if ($url):
                    ?>
                    <img src="<?php echo esc_url($url); ?>" alt="<?php the_title(); ?>">
                    <?php
                endif;
                ?>
                <header class="entry-header">

                    <?php
                    the_title('<a href="' . esc_url(get_permalink()) . '" rel="bookmark"><h2 class="entry-title">', '</h2></a>');

                    if ('post' === get_post_type()) :
                        ?>
                        <div class="entry-meta">
                            <?php litae_posted_on(); ?>
                        </div><!-- .entry-meta -->
                        <?php
                    endif;
                    ?>
                </header><!-- .entry-header -->

                <div class="entry-content">
                    <?php
                    
                    if (has_excerpt($post->ID)):
                        echo get_the_excerpt();
                    else:
                        the_excerpt();
                    endif;

                    wp_link_pages(array(
                        'before' => '<div class="page-links">' . esc_html__('Pages:', 'litae'),
                        'after' => '</div>',
                    ));
                    ?>
                </div><!-- .entry-content -->

                <footer class="entry-footer">
                    <?php litae_entry_footer(); ?>
                </footer><!-- .entry-footer -->
                <a href="<?php echo esc_url(get_permalink()); ?>"><div class="blog-link"><?php echo esc_html__('read more', 'litae'); ?></div></a>
            </div><!-- .content-in -->
        </article><!-- #post-## -->
    </div><!-- .blog-box-two-columns -->
    <?php
else:
    //single post
    ?>
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

        <?php
        ?>
        <header class="entry-header">
            <div class="h-wrap <?php echo ( $single_post_watcher != '') ? esc_attr($single_post_watcher) : ''; ?>" data-rev-settings="<?php echo esc_attr( wp_json_encode($single_post_title_rev_settings) );?>">
    <?php the_title('<h1 class="entry-title">', '</h1>'); ?>
            </div>
                <?php
                if ('post' === get_post_type()) :
                    ?>
                <div class="entry-meta <?php echo ( $single_post_entry_watcher != '') ? esc_attr($single_post_entry_watcher) : ''; ?>" data-rev-settings="<?php echo esc_attr( wp_json_encode($single_post_page_entry_rev_settings) );?>">
                <?php litae_posted_on(); ?>
                </div><!-- .entry-meta -->
                    <?php
                endif;
                ?>
        </header><!-- .entry-header -->

        <div class="entry-content">
    <?php
    if (has_post_thumbnail()) { // check if the post has a Post Thumbnail assigned to it.
    ?>
        <div class="single-feature-image">  
    <?php
        the_post_thumbnail('full');
    ?>
        </div>
    <?php
    }

    the_content(sprintf(
                    /* translators: %s: Name of current post. */
                    wp_kses(__('Continue reading %s <span class="meta-nav">&rarr;</span>', 'litae'), array('span' => array('class' => array()))), the_title('<span class="screen-reader-text">"', '"</span>', false)
    ));

    wp_link_pages(array(
        'before' => '<div class="page-links">' . esc_html__('Pages:', 'litae'),
        'after' => '</div>',
    ));
    ?>
        </div><!-- .entry-content -->

        <footer class="entry-footer">
            <?php litae_entry_footer(); ?>
        </footer><!-- .entry-footer -->

    </article><!-- #post-## -->

<?php    
endif;
