<?php
/**
 * The template for displaying 404 pages (not found).
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Piroll
 */

get_header(); ?>
    <div class="nk-header-title nk-header-title-full">
        <div class="nk-header-table">
            <div class="nk-header-table-cell">
                <div class="container">
                    <div class="nk-header-text">

                        <div class="nk-gap-4"></div>
                        <div class="container">
                            <div class="text-xs-center">
                                <h2 class="nk-title display-4"><?php echo esc_html__( 'Page Not Found', 'piroll' ); ?></h2>
                                <?php if ( piroll_get_theme_mod( 'not_found_show_text' ) || piroll_get_theme_mod( 'not_found_show_search' ) || piroll_get_theme_mod( 'not_found_show_home_button' ) ) : ?>
                                    <div class="nk-gap-2"></div>
                                    <div class="row">
                                        <div class="col-md-8 offset-md-2">
                                            <?php if ( piroll_get_theme_mod( 'not_found_show_text' ) ) : ?>
                                                <p class="lead"><?php echo esc_html__( 'The page you are looking for no longer exists. Perhaps you can return back to the site\'s homepage and see if you can find what you are looking for.', 'piroll' ); ?></p>
                                            <?php endif; ?>
                                            <?php if ( piroll_get_theme_mod( 'not_found_show_search' ) ) : ?>
                                                <?php if ( piroll_get_theme_mod( 'not_found_show_text' ) ) : ?>
                                                    <div class="nk-gap"></div>
                                                <?php endif; ?>
                                                <div class="mw-400 m-auto">
                                                    <?php get_search_form( true ); ?>
                                                </div>
                                            <?php endif; ?>
                                            <?php if ( piroll_get_theme_mod( 'not_found_show_home_button' ) ) : ?>
                                                <?php if ( piroll_get_theme_mod( 'not_found_show_text' ) || piroll_get_theme_mod( 'not_found_show_search' ) ) : ?>
                                                    <div class="nk-gap-2"></div>
                                                <?php endif; ?>
                                                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="nk-btn nk-btn-long"><?php echo esc_html__( 'Go to Homepage', 'piroll' ); ?></a>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="nk-gap-4"></div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- END: Header Title -->
<?php
get_footer();
