<?php
/**
 * Init Admin Theme Pages
 */

if ( ! function_exists( 'nk_theme' ) ) {
    return;
}

$piroll_theme_demo_path = nk_admin()->admin_path . '/demos/';

nk_theme()->theme_dashboard(
    array(
        'theme_title'         => 'Piroll',
        'theme_version'       => '1.1.3',
        'theme_id'            => '20672319',
        'theme_uri'           => 'https://themeforest.net/item/piroll-portfolio-wordpress-theme/20672319?ref=_nK',
        'theme_documentation' => 'https://nkdev.info/docs/piroll-wp/',
        'theme_changelog'     => 'https://nkdev.info/docs/piroll-wp/log/',
        'ask_for_review'      => true,
        'is_envato_elements'  => true,
        'demos' => array(
            'main' => array(
                'title'      => esc_html__( 'Main', 'piroll' ),
                'preview'    => 'https://wp.nkdev.info/piroll/',
                'thumbnail'  => get_template_directory_uri() . '/admin/assets/images/demos/main.jpg',
                'demo_data'  => array(
                    'blog_options' => array(
                        'permalink' => '/%postname%/',
                        'page_on_front_title' => 'Main',
                        'posts_per_page' => 6,
                    ),
                    'navigations' => array(
                        'Main Menu' => 'primary',
                    ),
                    'demo_data_file' => $piroll_theme_demo_path . 'main/content.xml',
                    'customizer_file' => $piroll_theme_demo_path . 'main/customizer.dat',
                    'widgets_file' => $piroll_theme_demo_path . 'main/widgets.json',
                ),
            ),
            'creative-dark' => array(
                'title'      => esc_html__( 'Creative Dark', 'piroll' ),
                'preview'    => 'https://wp.nkdev.info/piroll/creative-dark/',
                'thumbnail'  => get_template_directory_uri() . '/admin/assets/images/demos/creative-dark.jpg',
                'demo_data'  => array(
                    'blog_options' => array(
                        'permalink' => '/%postname%/',
                        'page_on_front_title' => 'Main',
                        'posts_per_page' => 6,
                    ),
                    'navigations' => array(
                        'Main Menu' => 'primary',
                    ),
                    'demo_data_file' => $piroll_theme_demo_path . 'creative-dark/content.xml',
                    'customizer_file' => $piroll_theme_demo_path . 'creative-dark/customizer.dat',
                    'widgets_file' => $piroll_theme_demo_path . 'creative-dark/widgets.json',
                ),
            ),
            'fullscreen' => array(
                'title'      => esc_html__( 'Fullscreen Slider', 'piroll' ),
                'preview'    => 'https://wp.nkdev.info/piroll/fullscreen-slider/',
                'thumbnail'  => get_template_directory_uri() . '/admin/assets/images/demos/fullscreen.jpg',
                'demo_data'  => array(
                    'blog_options' => array(
                        'permalink' => '/%postname%/',
                        'page_on_front_title' => 'Main',
                        'posts_per_page' => 6,
                    ),
                    'navigations' => array(
                        'Main Menu' => 'primary',
                    ),
                    'demo_data_file' => $piroll_theme_demo_path . 'fullscreen/content.xml',
                    'customizer_file' => $piroll_theme_demo_path . 'fullscreen/customizer.dat',
                    'widgets_file' => $piroll_theme_demo_path . 'fullscreen/widgets.json',
                ),
            ),
        ),
    )
);
